{ Copyright (C) by Tobias Schwarz, 2003-2007
  Distributed under the GNU General Public License }

unit Progress;

interface

uses
  {$IFDEF WIN32}
  Windows, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ComCtrls, Buttons;
  {$ELSE}
  SysUtils, Classes, QStdCtrls, QButtons,
  QControls, QForms, QComCtrls;
  {$ENDIF}

type
  TProgressForm = class(TForm)
    ProgressBar: TProgressBar;
    Doing_What_Label: TLabel;
    Doing_With_Label: TLabel;
    CancelBtn: TSpeedButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation

{$IFDEF WIN32}
uses Main, VistaFuncs;

{$R *.DFM}

{$ELSE}
uses Main;

{$R *.xfm}
{$ENDIF}

procedure TProgressForm.CancelBtnClick(Sender: TObject);
begin
MainForm.Webalize.Terminate;
end;

procedure TProgressForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Action:=caFree;
end;

procedure TProgressForm.FormCreate(Sender: TObject);
begin
{$IFDEF WIN32}
SetOSFont(Self);
{$ENDIF}
CancelBtn.Glyph.LoadFromResourceName(HInstance,'cancel');
end;

end.
