{ Copyright (C) by Tobias Schwarz, 2003-2007
  Distributed under the GNU General Public License }

unit Config_File;

interface

uses Sysutils, 
{$IFDEF WIN32}
Graphics;
{$ELSE}
QGraphics;
{$ENDIF}

procedure CreateConfigFile;
function ColorToHex(Color: TColor): String;

implementation

uses Main, Resourcestrings;

function ColorToHex(Color: TColor): String;
begin
Result:=IntToHex(Color,6);
Result:=Result[5]+Result[6]+Result[3]+Result[4]+Result[1]+Result[2];
end;

procedure CreateConfigFile;      { Konfigurationsdatei erstellen }
var Ctr: Integer;
begin
With MainForm do begin
Config.Clear;
Config.Lines.Add(webalizer_config_file);
Config.Lines.Add(config_created_by);
Config.Lines.Add('#');
If Trim(TargetDir)<>'' then Config.Lines.Add('OutputDir '+Trim(TargetDir));
If not DailyStat.Checked then Config.Lines.Add('DailyStats no');
If not DailyGraph.Checked then Config.Lines.Add('DailyGraph no');
If not HourlyStats.Checked then Config.Lines.Add('HourlyStats no');
If not HourlyGraphCheck.Checked then Config.Lines.Add('HourlyGraph no');
If not CountryCheck.Checked then Config.Lines.Add('CountryGraph no');
If IncrementalCheck.Checked then Config.Lines.Add('Incremental yes');
If Timeout.Value<>30 then Config.Lines.Add('VisitTimeout '+IntToStr(Timeout.Value*60));
If Trim(ReportTitle.Text)<>'' then Config.Lines.Add('ReportTitle '+Trim(ReportTitle.Text));
If Trim(HostName.Text)<>'' then begin
   Config.Lines.Add('HostName '+Trim(HostName.Text));
   If HideOwnSiteAsReferrer.Checked then begin
      If Copy(Trim(HostName.Text),1,4)='www.' then Config.Lines.Add('HideReferrer '+Copy(Trim(HostName.Text),5,Length(Trim(HostName.Text))))
      else Config.Lines.Add('HideReferrer '+Trim(HostName.Text));
   end;
end;
If not GraphLegend.Checked then Config.Lines.Add('GraphLegend no');
If GraphLines.Value<>2 then Config.Lines.Add('GraphLines '+IntToStr(GraphLines.Value));
If not GraphLegend.Checked then Config.Lines.Add('GraphLegend no');
If Trim(LogTypeBox.Text)='apache' then begin
   If Trim(ApacheLogFormat.Text)<>'' then begin
      Config.Lines.Add('LogType apache');
      Config.Lines.Add('ApacheLogFormat '+Trim(ApacheLogFormat.Text));
   end else Config.Lines.Add('LogType clf');
end else if Trim(LogTypeBox.Text)<>'' then Config.Lines.Add('LogType '+Trim(LogTypeBox.Text));
If Trim(HTMLExtension.Text)<>'' then Config.Lines.Add('HTMLExtension '+Trim(HTMLExtension.Text));
If MangleAgents.Value>0 then Config.Lines.Add('MangleAgents '+IntToStr(MangleAgents.Value));
For Ctr:=0 to 15 do
   If PageType.Checked[Ctr] then Config.Lines.Add('PageType '+PageType.Items[Ctr]);
If HTTPSCheck.Checked then Config.Lines.Add('UseHTTPS yes');
If IgnoreSequenceErrorsCheck.Checked then Config.Lines.Add('FoldSeqErr yes');
If TopSites.Value<>30 then Config.Lines.Add('TopSites '+IntToStr(TopSites.Value));
If TopKBytes.Value<>10 then Config.Lines.Add('TopKSites '+IntToStr(TopKBytes.Value));
If TopURLs.Value<>30 then Config.Lines.Add('TopURLs '+IntToStr(TopURLs.Value));
If TopURLsKBytes.Value<>10 then Config.Lines.Add('TopKURLs '+IntToStr(TopURLsKBytes.Value));
If TopReferrers.Value<>30 then Config.Lines.Add('TopReferrers '+IntToStr(TopReferrers.Value));
If TopAgents.Value<>15 then Config.Lines.Add('TopAgents '+IntToStr(TopAgents.Value));
If TopCountries.Value<>30 then Config.Lines.Add('TopCountries '+IntToStr(TopCountries.Value));
If TopEntryPages.Value<>10 then Config.Lines.Add('TopEntry '+IntToStr(TopEntryPages.Value));
If TopExitPages.Value<>10 then Config.Lines.Add('TopExit '+IntToStr(TopExitPages.Value));
If TopSearches.Value<>20 then Config.Lines.Add('TopSearch '+IntToStr(TopSearches.Value));
If TopUsers.Value<>20 then Config.Lines.Add('TopUsers '+IntToStr(TopUsers.Value));
If AllSites.Checked then Config.Lines.Add('AllSites yes');
If AllURLs.Checked then Config.Lines.Add('AllURLs yes');
If AllReferrers.Checked then Config.Lines.Add('AllReferrers yes');
If AllAgents.Checked then Config.Lines.Add('AllAgents yes');
If AllSearchesCheck.Checked then Config.Lines.Add('AllSearchStr yes');
If AllUsersCheck.Checked then Config.Lines.Add('AllUsers yes');
For Ctr:=0 to SearchEngines.Lines.Count-1 do if Trim(SearchEngines.Lines[Ctr])<>'' then Config.Lines.Add('SearchEngine '+Trim(SearchEngines.Lines[Ctr]));
For Ctr:=0 to HTMLPre.Lines.Count-1 do if Trim(HTMLPre.Lines[Ctr])<>'' then Config.Lines.Add('HTMLPre '+Trim(HTMLPre.Lines[Ctr]));
For Ctr:=0 to HTMLHead.Lines.Count-1 do if Trim(HTMLHead.Lines[Ctr])<>'' then Config.Lines.Add('HTMLHead '+Trim(HTMLHead.Lines[Ctr]));
For Ctr:=0 to HTMLBody.Lines.Count-1 do if Trim(HTMLBody.Lines[Ctr])<>'' then Config.Lines.Add('HTMLBody '+Trim(HTMLBody.Lines[Ctr]));
For Ctr:=0 to HTMLPost.Lines.Count-1 do if Trim(HTMLPost.Lines[Ctr])<>'' then Config.Lines.Add('HTMLPost '+Trim(HTMLPost.Lines[Ctr]));
For Ctr:=0 to HTMLTail.Lines.Count-1 do if Trim(HTMLTail.Lines[Ctr])<>'' then Config.Lines.Add('HTMLTail '+Trim(HTMLTail.Lines[Ctr]));
For Ctr:=0 to HTMLEnd.Lines.Count-1 do if Trim(HTMLEnd.Lines[Ctr])<>'' then Config.Lines.Add('HTMLEnd '+Trim(HTMLEnd.Lines[Ctr]));
For Ctr:=0 to HideHostMemo.Lines.Count-1 do if Trim(HideHostMemo.Lines[Ctr])<>'' then Config.Lines.Add('HideSite '+Trim(HideHostMemo.Lines[Ctr]));
For Ctr:=0 to HideURLMemo.Lines.Count-1 do if Trim(HideURLMemo.Lines[Ctr])<>'' then Config.Lines.Add('HideURL '+Trim(HideURLMemo.Lines[Ctr]));
For Ctr:=0 to HideReferrerMemo.Lines.Count-1 do if Trim(HideReferrerMemo.Lines[Ctr])<>'' then Config.Lines.Add('HideReferrer '+Trim(HideReferrerMemo.Lines[Ctr]));
For Ctr:=0 to HideAgentMemo.Lines.Count-1 do if Trim(HideAgentMemo.Lines[Ctr])<>'' then Config.Lines.Add('HideAgent '+Trim(HideAgentMemo.Lines[Ctr]));
For Ctr:=0 to HideUserMemo.Lines.Count-1 do if Trim(HideUserMemo.Lines[Ctr])<>'' then Config.Lines.Add('HideUser '+Trim(HideUserMemo.Lines[Ctr]));
For Ctr:=0 to GroupHostMemo.Lines.Count-1 do if Trim(GroupHostMemo.Lines[Ctr])<>'' then Config.Lines.Add('GroupSite '+Trim(GroupHostMemo.Lines[Ctr]));
For Ctr:=0 to GroupURLMemo.Lines.Count-1 do if Trim(GroupURLMemo.Lines[Ctr])<>'' then Config.Lines.Add('GroupURL '+Trim(GroupURLMemo.Lines[Ctr]));
For Ctr:=0 to GroupReferrerMemo.Lines.Count-1 do if Trim(GroupReferrerMemo.Lines[Ctr])<>'' then Config.Lines.Add('GroupReferrer '+Trim(GroupReferrerMemo.Lines[Ctr]));
For Ctr:=0 to GroupAgentMemo.Lines.Count-1 do if Trim(GroupAgentMemo.Lines[Ctr])<>'' then Config.Lines.Add('GroupAgent '+Trim(GroupAgentMemo.Lines[Ctr]));
For Ctr:=0 to GroupUserMemo.Lines.Count-1 do if Trim(GroupUserMemo.Lines[Ctr])<>'' then Config.Lines.Add('GroupUser '+Trim(GroupUserMemo.Lines[Ctr]));
For Ctr:=0 to IgnoreHostMemo.Lines.Count-1 do if Trim(IgnoreHostMemo.Lines[Ctr])<>'' then Config.Lines.Add('IgnoreSite '+Trim(IgnoreHostMemo.Lines[Ctr]));
For Ctr:=0 to IgnoreURLMemo.Lines.Count-1 do if Trim(IgnoreURLMemo.Lines[Ctr])<>'' then Config.Lines.Add('IgnoreURL '+Trim(IgnoreURLMemo.Lines[Ctr]));
For Ctr:=0 to IgnoreReferrerMemo.Lines.Count-1 do if Trim(IgnoreReferrerMemo.Lines[Ctr])<>'' then Config.Lines.Add('IgnoreReferrer '+Trim(IgnoreReferrerMemo.Lines[Ctr]));
For Ctr:=0 to IgnoreAgentMemo.Lines.Count-1 do if Trim(IgnoreAgentMemo.Lines[Ctr])<>'' then Config.Lines.Add('IgnoreAgent '+Trim(IgnoreAgentMemo.Lines[Ctr]));
For Ctr:=0 to IgnoreUserMemo.Lines.Count-1 do if Trim(IgnoreUserMemo.Lines[Ctr])<>'' then Config.Lines.Add('IgnoreUser '+Trim(IgnoreUserMemo.Lines[Ctr]));
For Ctr:=0 to IncludeHost.Lines.Count-1 do if Trim(IncludeHost.Lines[Ctr])<>'' then Config.Lines.Add('IncludeSite '+Trim(IncludeHost.Lines[Ctr]));
For Ctr:=0 to IncludeURLMemo.Lines.Count-1 do if Trim(IncludeURLMemo.Lines[Ctr])<>'' then Config.Lines.Add('IncludeURL '+Trim(IncludeURLMemo.Lines[Ctr]));
For Ctr:=0 to IncludeReferrer.Lines.Count-1 do if Trim(IncludeReferrer.Lines[Ctr])<>'' then Config.Lines.Add('IncludeReferrer '+Trim(IncludeReferrer.Lines[Ctr]));
For Ctr:=0 to IncludeUserAgent.Lines.Count-1 do if Trim(IncludeUserAgent.Lines[Ctr])<>'' then Config.Lines.Add('IncludeAgent '+Trim(IncludeUserAgent.Lines[Ctr]));
For Ctr:=0 to IncludeUserMemo.Lines.Count-1 do if Trim(IncludeUserMemo.Lines[Ctr])<>'' then Config.Lines.Add('IncludeUser '+Trim(IncludeUserMemo.Lines[Ctr]));
If HideAllHosts.Checked then Config.Lines.Add('HideAllSites yes');
If GroupDomains.Value>0 then Config.Lines.Add('GroupDomains '+IntToStr(GroupDomains.Value));
If ShadeGroups.Checked then Config.Lines.Add('GroupShading yes');
If HighlightGroups.Checked then Config.Lines.Add('GroupHighlight yes');
If DebugOutput.Checked then Config.Lines.Add('Debug yes');

{$IFDEF WIN32}
If WebalizerVersion>2011000 then begin      { Die Windows-Variante von Webalizer 2.01-10 kann noch keine reversen DNS-lookups }
{$ENDIF}
   If EnableRevDNSLookupsCheck.Checked then begin
      If DNSCachefile.Text<>'' then Config.Lines.Add('DNSCache '+Trim(DNSCachefile.Text))
      else Config.Lines.Add('DNSCache dns_cache.db');
      Config.Lines.Add('DNSChildren '+IntToStr(DNSChild.Value));
   end else Config.Lines.Add('DNSChildren 0');
{$IFDEF WIN32}
end;
{$ENDIF}

If WebalizerVersion=2011010 then begin
   Config.Lines.Add('CodeNotFound '+IntToStr(TopErrors.Value));
end;

If WebalizerVersion>=2020000 then begin
   If DNSTTL.Value<>3 then Config.Lines.Add('DNSCacheTTL '+IntToStr(DNSTTL.Value));
   If TopErrors.Value<>20 then Config.Lines.Add('TopErrors '+IntToStr(TopErrors.Value));
   If AllErrors.Checked then Config.Lines.Add('AllErrors yes');
   If not BundleGroups.Checked then Config.Lines.Add('BundleGroups no');
   If ConvertURLs.Checked then Config.Lines.Add('ConvURLsLowercase yes');
   If CSSDir.Text<>'' then Config.Lines.Add('HTMLCSSPath '+CSSDir.Text);
   If HTMLCharset.Text<>'' then begin
      If Pos('(',HTMLCharset.Text)>0 then Config.Lines.Add('HTMLCharset '+Copy(HTMLCharset.Text,Pos('(',HTMLCharset.Text)+1,Pos(')',HTMLCharset.Text)-Pos('(',HTMLCharset.Text)-1))
      else Config.Lines.Add('HTMLCharset '+HTMLCharset.Text);
   end;
   If TopDownloads.Value<>20 then Config.Lines.Add('TopDownloads '+IntToStr(TopDownloads.Value));
   If AllDownloads.Checked then Config.Lines.Add('AllDownloads yes');
   If DownloadTimeout.Value<>180 then Config.Lines.Add('DownloadTimeout '+IntToStr(DownloadTimeout.Value));
   For Ctr:=0 to DownloadPath.Lines.Count-1 do if Trim(DownloadPath.Lines[Ctr])<>'' then Config.Lines.Add('DownloadPath '+Trim(DownloadPath.Lines[Ctr]));
   If StatLanguage.Text<>english then Config.Lines.Add('LanguageFile '+WebalizerDir+'lang\webalizer_lang.'+LangTextToFilename(StatLanguage.Text));
   For Ctr:=0 to IgnoreReferrerRedirect.Lines.Count-1 do if Trim(IgnoreReferrerRedirect.Lines[Ctr])<>'' then Config.Lines.Add('IgnoreReferrerRedirect '+Trim(IgnoreReferrerRedirect.Lines[Ctr]));
   For Ctr:=0 to IncludeSearchArg.Lines.Count-1 do if Trim(IncludeSearchArg.Lines[Ctr])<>'' then Config.Lines.Add('IncludeSearchArg '+Trim(IncludeSearchArg.Lines[Ctr]));
   For Ctr:=0 to ExcludeSearchArg.Lines.Count-1 do if Trim(ExcludeSearchArg.Lines[Ctr])<>'' then Config.Lines.Add('ExcludeSearchArg '+Trim(ExcludeSearchArg.Lines[Ctr]));
   If not IgnoreReferrerPartial.Checked then Config.Lines.Add('IgnoreReferrerPartial no');
   If GraphBackgroundColor.Font.Color<>$02e0e0e0 then Config.Lines.Add('GraphBackgroundColor '+ColorToHex(GraphBackgroundColor.Font.Color));
   If GraphGridlineColor.Font.Color<>$02808080 then Config.Lines.Add('GraphGridlineColor '+ColorToHex(GraphGridlineColor.Font.Color));
   If GraphHitsColor.Font.Color<>$025C8000 then Config.Lines.Add('GraphHitsColor '+ColorToHex(GraphHitsColor.Font.Color));
   If GraphHostsColor.Font.Color<>$020080FF then Config.Lines.Add('GraphHostsColor '+ColorToHex(GraphHostsColor.Font.Color));
   If GraphFilesColor.Font.Color<>$02FF0000 then Config.Lines.Add('GraphFilesColor '+ColorToHex(GraphFilesColor.Font.Color));
   If GraphLegendColor.Font.Color<>$02000000 then Config.Lines.Add('GraphLegendColor '+ColorToHex(GraphLegendColor.Font.Color));
   If GraphOutlineColor.Font.Color<>$02000000 then Config.Lines.Add('GraphOutlineColor '+ColorToHex(GraphOutlineColor.Font.Color));
   If GraphPagesColor.Font.Color<>$02FFC000 then Config.Lines.Add('GraphPagesColor '+ColorToHex(GraphPagesColor.Font.Color));
   If GraphTitleColor.Font.Color<>$02FF0000 then Config.Lines.Add('GraphTitleColor '+ColorToHex(GraphTitleColor.Font.Color));
   If GraphVisitsColor.Font.Color<>$0200FFFF then Config.Lines.Add('GraphVisitsColor '+ColorToHex(GraphVisitsColor.Font.Color));
   If GraphVolumeColor.Font.Color<>$020000FF then Config.Lines.Add('GraphVolumeColor '+ColorToHex(GraphVolumeColor.Font.Color));
   If GraphWeekendColor.Font.Color<>$025C8000 then Config.Lines.Add('GraphWeekendColor '+ColorToHex(GraphWeekendColor.Font.Color));
   If GraphShadowColor.Font.Color<>$02333333 then Config.Lines.Add('GraphShadowColor '+ColorToHex(GraphShadowColor.Font.Color));
   If Trim(GraphFontNormal.Text)<>'' then Config.Lines.Add('GraphFontNormal '+Trim(GraphFontNormal.Text));
   If Trim(GraphFontBold.Text)<>'' then Config.Lines.Add('GraphFontBold '+Trim(GraphFontBold.Text));
   If GraphFontSmall.Value>0 then Config.Lines.Add('GraphFontSmall '+IntToStr(GraphFontSmall.Value));
   If GraphFontMedium.Value>0 then Config.Lines.Add('GraphFontMedium '+IntToStr(GraphFontMedium.Value));
   If not GraphFontSmoothing.Checked then Config.Lines.Add('GraphFontSmoothing no');
   If GraphBorderWidth.Value>0 then Config.Lines.Add('GraphBorderWidth '+IntToStr(GraphBorderWidth.Value));
   If GraphBackgroundAlpha.Position>0 then Config.Lines.Add('GraphBackgroundAlpha '+IntToStr(GraphBackgroundAlpha.Position));
   If GraphTrueColor.Checked then Config.Lines.Add('GraphTrueColor yes');
end;

If WebalizerVersion>=2050000 then begin
   If GeoIPDB.Text<>'' then Config.Lines.Add('GeoIPDBPath '+GeoIPDB.Text);
   For Ctr:=0 to SpamReferrer.Lines.Count-1 do if Trim(SpamReferrer.Lines[Ctr])<>'' then Config.Lines.Add('SpamReferrer '+Trim(SpamReferrer.Lines[Ctr]));
end;

Config.Lines.Add('# User defined configuration lines:');
For Ctr:=0 to AdditionalTags.Lines.Count-1 do if Trim(AdditionalTags.Lines[Ctr])<>'' then Config.Lines.Add(Trim(AdditionalTags.Lines[Ctr]));
Config.Text:=AnsiToUTF8(Config.Text);
end;
end;

end.
 