{ Copyright (C) by Tobias Schwarz, 2003-2007
  Distributed under the GNU General Public License }

unit Main;

interface

uses
  Classes, Resourcestrings, Progress, Webalize,
  {$IFDEF WIN32}
  Windows, SysUtils, Messages, Graphics, Controls, Forms, Dialogs_new,
  Buttons, ComCtrls, ExtCtrls, StdCtrls, Registry, Spin,
  ImgList, ShellAPI, ConsoleApp, ReInit, Menus, CheckLst, Dialogs, HelpIntfs,
  GIFImage;
  {$ELSE}
  SysUtils, QForms, QImgList, QDialogs, QStdCtrls, QComCtrls,
  QExtCtrls, QControls, QButtons, QMenus, QCheckLst, QGraphics, Qt, Types, Libc;
  {$ENDIF}

type
  TMainForm = class(TForm)
  {$REGION 'TMainForm Controls'}
    PageControl: TPageControl;
    LayoutTab: TTabSheet;
    ChoseFiles: TTabSheet;
    InputLbl: TLabel;
    OutputLbl: TLabel;
    LogList: TListBox;
    LogfilesListLbl: TLabel;
    OutputDir: TEdit;
    TargetDirLbl: TLabel;
    DeleteExisting: TCheckBox;
    OpenDialog: TOpenDialog;
    ChooseTargetDirBtn: TBitBtn;
    SaveDialog: TSaveDialog;
    VertLine: TPanel;
    Panel2: TPanel;
    ShowLbl: TLabel;
    DailyStat: TCheckBox;
    DailyGraph: TCheckBox;
    HourlyStats: TCheckBox;
    HourlyGraphCheck: TCheckBox;
    CountryCheck: TCheckBox;
    DeleteExistingStatsLbl: TLabel;
    SettingsTab: TTabSheet;
    AdditionalHTMLTab: TTabSheet;
    HTMLPre: TMemo;
    HTMLHead: TMemo;
    HTMLBody: TMemo;
    HTMLPost: TMemo;
    HTMLTail: TMemo;
    HTMLEnd: TMemo;
    HTMLPreLbl: TLabel;
    HTMLHeadLbl: TLabel;
    HTMLBodyLbl: TLabel;
    HTMLPostLbl: TLabel;
    HTMLTailLbl: TLabel;
    HTMLEndLbl: TLabel;
    HGIITab: TTabSheet;
    OutputTab: TTabSheet;
    HTMLEndingLbl: TLabel;
    HTMLExtension: TComboBox;
    HTTPSCheck: TCheckBox;
    GUIOptionsTab: TTabSheet;
    Config: TMemo;
    IncludeLabel: TLabel;
    IgnoreLabel: TLabel;
    BackupCheck: TCheckBox;
    LanguageLbl: TLabel;
    Language: TComboBox;
    Bevel3: TBevel;
    ShowStatsCheck: TCheckBox;
    LoadListCheck: TCheckBox;
    AboutBtn: TBitBtn;
    AdditionalTags: TMemo;
    AdditionalTagsLbl: TLabel;
    PopupMenu: TPopupMenu;
    DateienAuswaehlenBtn: TMenuItem;
    WebalizerOptionenBtn: TMenuItem;
    WeitereOptionenBtn: TMenuItem;
    ZusaetzlicherHTMLCodeBtn: TMenuItem;
    HideGroupIgnoreIncludeBtn: TMenuItem;
    KonfigurationsdateiOutputBtn: TMenuItem;
    GUIOptionenBtn: TMenuItem;
    N1: TMenuItem;
    AktivenReiterAusblendenBtn: TMenuItem;
    Output: TMemo;
    OpenRecentPopupMenu: TPopupMenu;
    UseStandartBrowserCheck: TCheckBox;
    StatisticsList: TListBox;
    AvailableStatsLbl: TLabel;
    NeuOeffnenBtn1: TMenuItem;
    NeuOeffnenBtn2: TMenuItem;
    NeuOeffnenBtn3: TMenuItem;
    NeuOeffnenBtn4: TMenuItem;
    ConfigfileLbl: TLabel;
    WebalizerOutputLbl: TLabel;
    SearchEngines: TMemo;
    SearchEnginesLbl: TLabel;
    ShowHintsCheck: TCheckBox;
    SpeedButton1: TBitBtn;
    SpeedButton2: TBitBtn;
    LogPreprocessingTab: TTabSheet;
    Bevel6: TBevel;
    DomainToFilterLbl: TLabel;
    OutputFileDialogBtn: TBitBtn;
    Label73: TLabel;
    DomainEdit: TEdit;
    SaveCompressedLogIn: TEdit;
    RemoveDomainBox: TCheckBox;
    EnableDomainFilterCheck: TCheckBox;
    SaveFilteredLogCheck: TCheckBox;
    MixDomainsCheck: TCheckBox;
    CompressLogCheck: TCheckBox;
    ProviderComboBox: TComboBox;
    DomainFilterLbl: TLabel;
    Bevel9: TBevel;
    EnableRevDNSLookupsCheck: TCheckBox;
    DNSChild: TSpinEdit;
    DNSCachefile: TEdit;
    DNSChildProcessesLbl: TLabel;
    DNSCachefileLbl: TLabel;
    LogTypeBox: TComboBox;
    Label13: TLabel;
    DNSLookupLbl: TLabel;
    IncrementalCheck: TCheckBox;
    AllSearchesCheck: TCheckBox;
    AllUsersCheck: TCheckBox;
    TopUsers: TSpinEdit;
    TopSearches: TSpinEdit;
    TopExitPages: TSpinEdit;
    TopEntryPages: TSpinEdit;
    TopCountries: TSpinEdit;
    TopAgents: TSpinEdit;
    AllAgents: TCheckBox;
    AllReferrers: TCheckBox;
    TopReferrers: TSpinEdit;
    TopURLsKBytes: TSpinEdit;
    TopURLs: TSpinEdit;
    AllURLs: TCheckBox;
    TopKBytes: TSpinEdit;
    TopSites: TSpinEdit;
    AllSites: TCheckBox;
    TopErrors: TSpinEdit;
    AllErrors: TCheckBox;
    TopUsersLbl: TLabel;
    TopSearchesLbl: TLabel;
    TopExitPagesLbl: TLabel;
    TopEntryPagesLbl: TLabel;
    Label62: TLabel;
    TopCountriesLbl: TLabel;
    TopAgentsLbl: TLabel;
    TopReferrersLbl: TLabel;
    TopUrlsKbytesLbl: TLabel;
    TopURLsLbl: TLabel;
    Label22: TLabel;
    TopHostsLbl: TLabel;
    Label33: TLabel;
    TopsLbl: TLabel;
    Bevel4: TBevel;
    IgnoreSequenceErrorsCheck: TCheckBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    DNSCacheBtn: TBitBtn;
    Timeout: TSpinEdit;
    Label10: TLabel;
    minLbl: TLabel;
    HostName: TEdit;
    ReportTitle: TEdit;
    HostNameLbl: TLabel;
    ReporTitleLbl: TLabel;
    TitleLbl: TLabel;
    GeneralLbl: TLabel;
    LogfileBtn: TMenuItem;
    TopErrorsLbl: TLabel;
    ConvertURLs: TCheckBox;
    DNSTTL: TSpinEdit;
    DNSValidityLbl: TLabel;
    CSSDirLbl: TLabel;
    CSSDir: TEdit;
    CSSDirBtn: TBitBtn;
    WebalizerVersionLbl: TLabel;
    WebalizerExecutable: TEdit;
    ChangeWebalizer: TBitBtn;
    GroupLabel: TLabel;
    HTMLCharset: TComboBox;
    HTMLCharsetLbl: TLabel;
    GeoIPDBLbl: TLabel;
    GeoIPDB: TEdit;
    GeoIPDBBtn: TBitBtn;
    StatLanguage: TComboBox;
    StatLanguageLbl: TLabel;
    PageType: TCheckListBox;
    PageTypeLbl: TLabel;
    HGIIPageControl: TPageControl;
    HostTab: TTabSheet;
    URLTab: TTabSheet;
    ReferrerTab: TTabSheet;
    AgentTab: TTabSheet;
    UserTab: TTabSheet;
    HideHostLbl: TLabel;
    GroupHostLbl: TLabel;
    IgnoreHostLbl: TLabel;
    IgnoreHostMemo: TMemo;
    GroupHostMemo: TMemo;
    HideHostMemo: TMemo;
    HideURLMemo: TMemo;
    GroupURLMemo: TMemo;
    IgnoreURLMemo: TMemo;
    IncludeURLMemo: TMemo;
    IncludeUrlLbl: TLabel;
    IgnoreUrlLbl: TLabel;
    GroupUrlLbl: TLabel;
    HideUrlLbl: TLabel;
    HideReferrerMemo: TMemo;
    GroupReferrerMemo: TMemo;
    IgnoreReferrerMemo: TMemo;
    IgnoreReferrerLbl: TLabel;
    GroupReferrerLbl: TLabel;
    HideReferrerLbl: TLabel;
    GroupAgentMemo: TMemo;
    IgnoreAgentMemo: TMemo;
    HideAgentMemo: TMemo;
    HideAgentLbl: TLabel;
    GroupAgentLbl: TLabel;
    IgnoreAgentLbl: TLabel;
    HideUserMemo: TMemo;
    GroupUserMemo: TMemo;
    IgnoreUserMemo: TMemo;
    IncludeUserMemo: TMemo;
    IncludeUserLbl: TLabel;
    IgnoreUserLbl: TLabel;
    GroupUserLbl: TLabel;
    HideUserLbl: TLabel;
    HideLabel: TLabel;
    TopDownloads: TSpinEdit;
    AllDownloads: TCheckBox;
    TopDownloadsLbl: TLabel;
    DownloadPathLbl: TLabel;
    DownloadPath: TMemo;
    DownloadTimeoutLbl: TLabel;
    DownloadTimeout: TSpinEdit;
    secLbl: TLabel;
    HideAllHosts: TCheckBox;
    GroupDomains: TSpinEdit;
    GroupDomainsLbl: TLabel;
    BundleGroups: TCheckBox;
    ShadeGroups: TCheckBox;
    HighlightGroups: TCheckBox;
    DebugOutput: TCheckBox;
    HideOwnSiteAsReferrer: TCheckBox;
    IncludeHost: TMemo;
    IncludeHostLbl: TLabel;
    IncludeReferrer: TMemo;
    IncludeReferrerLbl: TLabel;
    IncludeUserAgent: TMemo;
    IncludeUserAgentLbl: TLabel;
    GroupPanel4: TPanel;
    RunBtn: TBitBtn;
    ModeBtn: TBitBtn;
    HelpBtn: TBitBtn;
    ExitBtn: TBitBtn;
    GroupPanel1: TPanel;
    DailyStatisticsBtn: TButton;
    HourlyStatisticsBtn: TButton;
    MonthlyStatisticsBtn: TButton;
    LastYearStatisticsBtn: TButton;
    URLsBtn: TButton;
    SitesBtn: TButton;
    EntryPagesBtn: TButton;
    ExitPagesBtn: TButton;
    UserAgentsBtn: TButton;
    UserNamesBtn: TButton;
    SearchesBtn: TButton;
    ReferrersBtn: TButton;
    GroupPanel2: TPanel;
    ImportBtn: TBitBtn;
    NewListBtn: TBitBtn;
    LoadListBtn: TBitBtn;
    SaveListBtn: TBitBtn;
    SaveListAsBtn: TBitBtn;
    GroupPanel3: TPanel;
    AddBtn: TBitBtn;
    DelBtn: TBitBtn;
    UpBtn: TBitBtn;
    DownBtn: TBitBtn;
    AgentsLevelLbl: TLabel;
    MangleAgents: TSpinEdit;
    ApacheLogFormatLbl: TLabel;
    ApacheLogFormat: TEdit;
    IgnoreReferrerRedirectLbl: TLabel;
    IgnoreReferrerRedirect: TMemo;
    IgnoreReferrerPartial: TCheckBox;
    SpamReferrer: TMemo;
    SpamReferrerLbl: TLabel;
    SearchesTab: TTabSheet;
    ExcludeSearchArgLbl: TLabel;
    ExcludeSearchArg: TMemo;
    IncludeSearchArg: TMemo;
    IncludeSearchArgLbl: TLabel;
    FormatGraphsTab: TTabSheet;
    GraphHostsColor: TBitBtn;
    ColorDialog: TColorDialog;
    GraphBackgroundAlpha: TScrollBar;
    GraphBackgroundAlphaLbl: TLabel;
    GraphBorderWidth: TSpinEdit;
    GraphBorderWidthLbl: TLabel;
    GraphBackgroundColor: TBitBtn;
    GraphGridlineColor: TBitBtn;
    GraphHitsColor: TBitBtn;
    GraphFontMedium: TSpinEdit;
    GraphFontSmall: TSpinEdit;
    GraphFontMediumLbl: TLabel;
    GraphFontSmallLbl: TLabel;
    GraphFontSmoothing: TCheckBox;
    GraphLegendColor: TBitBtn;
    GraphOutlineColor: TBitBtn;
    GraphPagesColor: TBitBtn;
    GraphTitleColor: TBitBtn;
    GraphVisitsColor: TBitBtn;
    GraphVolumeColor: TBitBtn;
    GraphWeekendColor: TBitBtn;
    GraphShadowColor: TBitBtn;
    GraphTrueColor: TCheckBox;
    GraphLegend: TCheckBox;
    LinesInDiagramsLbl: TLabel;
    GraphLines: TSpinEdit;
    GraphFontNormal: TEdit;
    GraphFontBold: TEdit;
    GraphFontNomalLbl: TLabel;
    GraphFontBoldLbl: TLabel;
    GraphFontNormalBtn: TBitBtn;
    GraphFontBoldBtn: TBitBtn;
    GraphFilesColor: TBitBtn;
    GraphImage: TImage;
    FormatGraphsBtn: TMenuItem;
    RemoveBeginningHostname: TCheckBox;
    {$ENDREGION}
    procedure GUIOptionsTabShow(Sender: TObject);
    procedure ShowHintsCheckClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RunBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure UpBtnClick(Sender: TObject);
    procedure DownBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure OnBtnClick(Sender: TObject);
    procedure DeleteExistingClick(Sender: TObject);
    {$IFDEF WIN32}
    procedure LogListDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    {$ELSE}
    procedure LogListDrawItem(Sender: TObject; Index: Integer; Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
    {$ENDIF}
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure ChoseFilesResize(Sender: TObject);
    procedure SettingsTabResize(Sender: TObject);
    procedure AdditionalHTMLTabResize(Sender: TObject);
    procedure HGIITabResize(Sender: TObject);
    procedure OutputTabResize(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    { Private-Deklarationen }
    AdvancedMode: Boolean;
    procedure SetLanguage(LangID: Integer; SaveBeforeChange: Boolean);
    {$IFDEF WIN32}
    procedure GetInstalledLanguages;
    function GetWinDir: String;
    {$ENDIF}
    procedure ChangeMode(TurnInAdvancedMode: Boolean);
    procedure SetTabStatus(TabIndex: Integer; Status: Boolean);
    procedure SetOSSpecifics;
    function CheckTargetDir(Directory: String): Boolean;
    procedure WebalizeDone(Sender: TObject);
    procedure ShowHelp(Keyword: String; UCommand: Cardinal);
  {$IFDEF WIN32}
    procedure HideAppFormTaskBarButton;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure WMSyscommand(var Message: TWmSysCommand); message WM_SYSCOMMAND;
  {$ENDIF}
  public
    { Public-Deklarationen }
    LanguageID, WebalizerVersion: Integer;
    TempDir, WebalizerDir, LastLogDir, TargetDir, ListFile: String;
    Changed: Boolean;
    StatisticsFiles: TStringList;
    WebalizerLangs: Array [0..32] of String;
    ProgressForm: TProgressForm;
    Webalize: TWebalize;
    procedure SetDomainFilter(Status: Boolean);
    procedure SetChanged(Status: Boolean);
    procedure SearchStatistics;
    procedure OpenStatistics(Index: Integer; Chapter: String);
    procedure SetWebalizerSpecifics(Version: Integer);
    procedure SetStandartBrowser;
    procedure SetRevDNSStatus(Status: Boolean);
    function CleanDir(Dir: String): String;
    function LangTextToFilename(LangText: String): String;
    function FilenameToLangText(Filename: String): String;
  end;

type
  TStartBrowserThread=class(TThread)
  private
    fURL: String;
  protected
    procedure Execute; override;
  public
    constructor Create(URL: String);
  end;

const Tabs: Array [0..8] of String = ('ShowFilelistTab','ShowLogPreprocessingTab','ShowOptionsTab','ShowAdvancedOptionsTab',
                                      'ShowAdditionalHTMLTab','ShowHGIITab','ShowFormatGraphsTab','ShowConfigOutputTab','ShowGUIOptionsTab');
      WebalizerLangFiles: Array [0..32] of String = ('catalan','croatian','czech','danish','dutch','english','estonian','finnish',
                          'french','galician','german','greek','hungarian','icelandic','indonesian','italian','japanese','korean',
                          'latvian','malay','norwegian','polish','portuguese','romanian','russian','serbian','simplified_chinese',
                          'slovak','slovene','spanish','swedish','turkish','ukrainian');
{$IFDEF WIN32}
    PathDelim = '\';
    HomeDir = 'c:\';
{$ELSE}
    PathDelim = '/';
    HomeDir = '/home/';
{$ENDIF}

var
  MainForm: TMainForm;

implementation

uses LoadSave, Config_File,
{The YclZlib Unit is part of the Y core library, which is copyright by
Peter J. Haas. Please visit http://delphi.pjh2.de/ for the most recent version
of the library, supporting documentation and license terms.}
{$IFDEF WIN32}
Browser, VistaFuncs,
{$ELSE}
Inifiles,
{$ENDIF}
Infofenster;

{$R shared_res.res}

{$IFDEF WIN32}

{$R *.DFM}

{$REGION 'Vista Funcs'}
procedure TMainForm.HideAppFormTaskBarButton;
begin
ShowWindow(Application.Handle, SW_HIDE);
SetWindowLong(Application.Handle, GWL_EXSTYLE,
GetWindowLong(Application.Handle, GWL_EXSTYLE) and not WS_EX_APPWINDOW or WS_EX_TOOLWINDOW);
ShowWindow(Application.Handle, SW_SHOW);
end;

procedure TMainForm.CreateParams(var Params: TCreateParams);
begin
inherited CreateParams(Params);
Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TMainForm.WMSyscommand(var Message: TWmSysCommand);
begin
case (Message.CmdType and $FFF0) of
   SC_MINIMIZE:
   begin
      ShowWindow(Handle, SW_MINIMIZE);
      Message.Result := 0;
   end;
   SC_RESTORE:
   begin
      ShowWindow(Handle, SW_RESTORE);
      Message.Result := 0;
   end;
else
   inherited;
end;
end;
{$ENDREGION}

procedure TMainForm.FormCreate(Sender: TObject);
var Registry: TRegistry;
    WinDir: PChar;
    i: Integer;
begin
SetOSFont(Self);
{ Start Vista specials }
HideAppFormTaskBarButton;
{ End Vista Specials }
StatisticsFiles:=TStringList.Create;
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
{ Determine temporary directory }
If Registry.KeyExists('Volatile Environment') then begin
   If Registry.OpenKeyReadOnly('Volatile Environment') then begin
      If Registry.ValueExists('APPDATA') then TempDir:=Registry.ReadString('APPDATA')+'\';
      Registry.CloseKey;
   end;
end else begin
   WinDir:=StrAlloc(MAX_PATH+1);
   GetWindowsDirectory(WinDir, MAX_PATH);
   TempDir:=WinDir+'\temp\';
   StrDispose(WinDir);
end;
{ Determine WebalizerGUI directories }
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\Directories') then begin
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\Directories') then begin
      If Registry.ValueExists('ListFile') then ListFile:=Registry.ReadString('ListFile');    { Der Name der zuletzt verwendeten Logliste wird geladen }
      If Registry.ValueExists('LogDir') then LastLogDir:=Registry.ReadString('LogDir');      { Das Verzeichnis des zuletzt verwendeten Logfiles wird geladen }
      If Registry.ValueExists('TargetDir') then TargetDir:=Registry.ReadString('TargetDir'); { Das zuletzt gewhlte Zielverzeichnis wird geladen }
      Registry.CloseKey;
   end;
end else begin
   ListFile:='unknown';
   LastLogDir:='c:\';
   TargetDir:='c:\';
end;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\Configuration') then begin  { Sonstiges wird aus der Registry geladen }
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\Configuration') then begin
      If Registry.ValueExists('Language') then SetLanguage(Registry.ReadInteger('Language'),false) else SetLanguage(1,false);
      If Registry.ValueExists('Mode') then ChangeMode(Registry.ReadBool('Mode'));
      If Registry.ValueExists('LoadLastList') then LoadListCheck.Checked:=Registry.ReadBool('LoadLastList');
      If Registry.ValueExists('UseStandartBrowser') then begin
         UseStandartBrowserCheck.Checked:=Registry.ReadBool('UseStandartBrowser');
         SetStandartBrowser;
      end;
      If Registry.ValueExists('ShowHints') then ShowHintsCheck.Checked:=Registry.ReadBool('ShowHints');
      Application.ShowHint:=ShowHintsCheck.Checked;
      For i:=0 to 8 do if Registry.ValueExists(Tabs[i]) then SetTabStatus(i,Registry.ReadBool(Tabs[i]));
      Registry.CloseKey;
   end;
end else begin
   SetLanguage(1,false);
   ChangeMode(true);
   LoadListCheck.Checked:=true;
   UseStandartBrowserCheck.Checked:=false;
end;
{ Determine recent loglist-files }
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\OpenNew') then begin
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\OpenNew') then begin
      If Registry.ValueExists('Open1') then NeuOeffnenBtn1.Caption:=Registry.ReadString('Open1');
      If Registry.ValueExists('Open2') then NeuOeffnenBtn2.Caption:=Registry.ReadString('Open2');
      If Registry.ValueExists('Open3') then NeuOeffnenBtn3.Caption:=Registry.ReadString('Open3');
      If Registry.ValueExists('Open4') then NeuOeffnenBtn4.Caption:=Registry.ReadString('Open4');
      Registry.CloseKey;
   end;
end;
Registry.Free;

{$ELSE}
{$R *.xfm}

procedure TMainForm.FormCreate(Sender: TObject);
var Inifile: TInifile;
    IniFileVersion, i: Integer;
begin
TempDir:='/tmp/';
LanguageID:=0;
StatisticsFiles:=TStringList.Create;
IniFile:=TIniFile.Create(GetEnvironmentVariable('HOME')+'/.xwebalizer');
IniFileVersion:=IniFile.ReadInteger('ProgramProperty','IniFileVersion',232);
ListFile:=IniFile.ReadString('Directories','ListFile','unknown');     { Der Name der zuletzt verwendeten Log-Liste wird geladen }
LastLogDir:=IniFile.ReadString('Directories','LogDir',GetEnvironmentVariable('HOME'));  { Das Verzeichnis des zuletzt verwendeten Log-Files wird geladen }
TargetDir:=IniFile.ReadString('Directories','TargetDir',GetEnvironmentVariable('HOME'));{ Das zuletzt gewlte Zielverzeichnis wird geladen }
ChangeMode(IniFile.ReadBool('Configuration','Mode',true));
LoadListCheck.Checked:=IniFile.ReadBool('Configuration','LoadLastList',true);
If IniFileVersion >=200 then for i:=0 to 8 do SetTabStatus(i,IniFile.ReadBool('Configuration',Tabs[i],true));
NeuOeffnenBtn1.Caption:=IniFile.ReadString('OpenNew','Open1','1');
NeuOeffnenBtn2.Caption:=IniFile.ReadString('OpenNew','Open2','2');
NeuOeffnenBtn3.Caption:=IniFile.ReadString('OpenNew','Open3','3');
NeuOeffnenBtn4.Caption:=IniFile.ReadString('OpenNew','Open4','4');
IniFile.UpdateFile;
IniFile.Free;
SetLanguage(0,false);
{$ENDIF}

AddBtn.Glyph.LoadFromResourceName(HInstance,'add');
DelBtn.Glyph.LoadFromResourceName(HInstance,'delete');
UpBtn.Glyph.LoadFromResourceName(HInstance,'move_up');
DownBtn.Glyph.LoadFromResourceName(HInstance,'move_down');
ChooseTargetDirBtn.Glyph.LoadFromResourceName(HInstance,'folders');
NewListBtn.Glyph.LoadFromResourceName(HInstance,'new');
ImportBtn.Glyph.LoadFromResourceName(HInstance,'import');
LoadListBtn.Glyph.LoadFromResourceName(HInstance,'open');
SaveListBtn.Glyph.LoadFromResourceName(HInstance,'save');
SaveListAsBtn.Glyph.LoadFromResourceName(HInstance,'save');
RunBtn.Glyph.LoadFromResourceName(HInstance,'run');
HelpBtn.Glyph.LoadFromResourceName(HInstance,'help');
ExitBtn.Glyph.LoadFromResourceName(HInstance,'close');
DNSCacheBtn.Glyph.LoadFromResourceName(HInstance,'folders');
OutputFileDialogBtn.Glyph.LoadFromResourceName(HInstance,'folders');
CSSDirBtn.Glyph.LoadFromResourceName(HInstance,'folders');
GeoIPDBBtn.Glyph.LoadFromResourceName(HInstance,'folders');
GraphFontNormalBtn.Glyph.LoadFromResourceName(HInstance,'folders');
GraphFontBoldBtn.Glyph.LoadFromResourceName(HInstance,'folders');
SpeedButton1.Glyph.LoadFromResourceName(HInstance,'save');
SpeedButton2.Glyph.LoadFromResourceName(HInstance,'save');
ChangeWebalizer.Glyph.LoadFromResourceName(HInstance,'folders');
AboutBtn.Glyph.LoadFromResourceName(HInstance,'globe');
{$IFDEF WIN32}
GraphImage.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+'graph.gif');
{$ELSE}
GraphImage.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+'graph.png');
{$ENDIF}
WebalizerDir:=CleanDir(GetWebalizerDir);
GetWebalizerVersion;
If (LoadListCheck.Checked) and (FileExists(ListFile)) then LoadList(ListFile) else NewList;
end;

procedure TMainForm.FormShow(Sender: TObject);
{$IFDEF WIN32}
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin  { Die Position des Programm-Fensters wird aus der Registry geladen }
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin
      If Registry.ValueExists('Left') then Left:=Registry.ReadInteger('Left');
      If Registry.ValueExists('Top') then Top:=Registry.ReadInteger('Top');
      If Registry.ValueExists('Width') then Width:=Registry.ReadInteger('Width');
      If Registry.ValueExists('Height') then Height:=Registry.ReadInteger('Height');
      Registry.CloseKey;
   end;
end;
Registry.Free;
GetInstalledLanguages;
{$ELSE}
var Inifile: TInifile;
    IniFileVersion: Integer;
begin
IniFile:=TIniFile.Create(GetEnvironmentVariable('HOME')+'/.xwebalizer');
IniFileVersion:=IniFile.ReadInteger('ProgramProperty','IniFileVersion',232);
Left:=IniFile.ReadInteger('WindowPos','Left',20);
Top:=IniFile.ReadInteger('WindowPos','Top',20);
If IniFileVersion>=232 then begin
Width:=IniFile.ReadInteger('WindowPos','Width',674);
Height:=IniFile.ReadInteger('WindowPos','Height',499);
end;
IniFile.UpdateFile;
IniFile.Free;
{$ENDIF}
SetOSSpecifics;
end;

{$REGION 'Initialize GUI'}
procedure TMainForm.SetOSSpecifics;
begin
{$IFDEF LINUX}
UseStandartBrowserCheck.Checked:=true;
SetStandartBrowser;
UseStandartBrowserCheck.Enabled:=false;
Language.Enabled:=false;
{$ENDIF}
end;

procedure TMainForm.SetWebalizerSpecifics(Version: Integer);
var Status: Boolean;
    i: Integer;
begin
Status:=true;
{$IFDEF WIN32}
If Version<=2011000 then Status:=false;      { Die Windows-Variante von Webalizer 2.01-10 kann noch keine reversen DNS-lookups }
   EnableRevDNSLookupsCheck.Checked:=false;
   SetRevDNSStatus(false);
{$ENDIF}
   EnableRevDNSLookupsCheck.Enabled:=Status;
   DNSLookupLbl.Enabled:=Status;
If (Version<2011008) and (LogTypeBox.Items.IndexOf('apache')>-1) then LogTypeBox.Items.Delete(LogTypeBox.Items.IndexOf('apache'));
If (Version>=2011008) and (LogTypeBox.Items.IndexOf('apache')=-1) then LogtypeBox.Items.Add('apache');
If Version<2011010 then Status:=false;
   TopErrors.Enabled:=Status;
   TopErrorsLbl.Enabled:=Status;
If Version<2020000 then Status:=false;
   ConvertURLs.Enabled:=Status;
   AllErrors.Enabled:=Status;
   BundleGroups.Enabled:=Status;
   CSSDirLbl.Enabled:=Status;
   CSSDirBtn.Enabled:=Status;
   CSSDir.Enabled:=Status;
   HTMLCharset.Enabled:=Status;
   HTMLCharsetLbl.Enabled:=Status;
   StatLanguage.Enabled:=Status;
   If Status then begin
      StatLanguage.Clear;
      For i:=0 to 32 do
         If FileExists(WebalizerDir+'lang'+PathDelim+'webalizer_lang.'+WebalizerLangFiles[i]) then StatLanguage.Items.Add(WebalizerLangs[i]);
   end;
   StatLanguageLbl.Enabled:=Status;
   TopDownloads.Enabled:=Status;
   TopDownloadsLbl.Enabled:=Status;
   AllDownloads.Enabled:=Status;
   DownloadTimeout.Enabled:=Status;
   DownloadTimeoutLbl.Enabled:=Status;
   secLbl.Enabled:=Status;
   DownloadPath.Enabled:=Status;
   DownloadPathLbl.Enabled:=Status;
   IgnoreReferrerRedirect.Enabled:=Status;
   IgnoreReferrerRedirectLbl.Enabled:=Status;
   SearchesTab.Enabled:=Status;
   IncludeSearchArgLbl.Enabled:=Status;
   IncludeSearchArg.Enabled:=Status;
   ExcludeSearchArgLbl.Enabled:=Status;
   ExcludeSearchArg.Enabled:=Status;
   GraphTrueColor.Enabled:=Status;
   GraphShadowColor.Enabled:=Status; 
   GraphBackgroundColor.Enabled:=Status;
   GraphFontMedium.Enabled:=Status;
   GraphFontMediumLbl.Enabled:=Status;
   GraphFontSmall.Enabled:=Status;
   GraphFontSmallLbl.Enabled:=Status;
   GraphFontNormal.Enabled:=Status;
   GraphFontNormalBtn.Enabled:=Status;
   GraphFontBold.Enabled:=Status;
   GraphFontBoldBtn.Enabled:=Status;  
   GraphFontSmoothing.Enabled:=Status;
If Version<2030000 then Status:=false;
   GraphGridlineColor.Enabled:=Status;
   IgnoreReferrerPartial.Enabled:=Status;
If Version<2040000 then Status:=false;
   GraphBackgroundAlpha.Enabled:=Status;
   GraphBackgroundAlphaLbl.Enabled:=Status;
   GraphBorderWidth.Enabled:=Status;
   GraphBorderWidthLbl.Enabled:=Status;
   GraphHitsColor.Enabled:=Status;
   GraphHostsColor.Enabled:=Status;
   GraphLegendColor.Enabled:=Status;
   GraphOutlineColor.Enabled:=Status;
   GraphPagesColor.Enabled:=Status;
   GraphTitleColor.Enabled:=Status;
   GraphVisitsColor.Enabled:=Status;
   GraphVolumeColor.Enabled:=Status;
   GraphWeekendColor.Enabled:=Status;
   GraphFilesColor.Enabled:=Status;
If Version<2050000 then Status:=false;
   GeoIPDB.Enabled:=Status;
   GeoIPDBBtn.Enabled:=Status;
   GeoIPDBLbl.Enabled:=Status;
   SpamReferrer.Enabled:=Status;
   SpamReferrerLbl.Enabled:=Status;
If Version=9999999 then MessageDlg(webalizer_version_unknown,mtInformation,[mbOK],0);
end;

procedure TMainForm.SetStandartBrowser;
begin
DailyStatisticsBtn.Enabled:=not UseStandartBrowserCheck.Checked;
HourlyStatisticsBtn.Enabled:=not UseStandartBrowserCheck.Checked;
URLsBtn.Enabled:=not UseStandartBrowserCheck.Checked;
SitesBtn.Enabled:=not UseStandartBrowserCheck.Checked;
EntryPagesBtn.Enabled:=not UseStandartBrowserCheck.Checked;
ExitPagesBtn.Enabled:=not UseStandartBrowserCheck.Checked;
ReferrersBtn.Enabled:=not UseStandartBrowserCheck.Checked;
SearchesBtn.Enabled:=not UseStandartBrowserCheck.Checked;
UserNamesBtn.Enabled:=not UseStandartBrowserCheck.Checked;
UserAgentsBtn.Enabled:=not UseStandartBrowserCheck.Checked;
end;

procedure TMainForm.SetDomainFilter(Status: Boolean);
begin
ProviderComboBox.Enabled:=Status;
DomainEdit.Enabled:=Status;
SaveFilteredLogCheck.Enabled:=Status;
If (Status) and (SaveFilteredLogCheck.Checked) then begin
   SaveCompressedLogIn.Enabled:=true;
   OutputFileDialogBtn.Enabled:=true;
   CompressLogCheck.Enabled:=true;
end else begin
   SaveCompressedLogIn.Enabled:=false;
   OutputFileDialogBtn.Enabled:=false;
   CompressLogCheck.Enabled:=false;
end;
RemoveDomainBox.Enabled:=Status;
MixDomainsCheck.Enabled:=Status;
DomainToFilterLbl.Enabled:=Status;
Label73.Enabled:=Status;
SetChanged(true);
end;

procedure TMainForm.SetTabStatus(TabIndex: Integer; Status: Boolean);
begin
PageControl.Pages[TabIndex].TabVisible:=Status;
Case TabIndex of
   0: DateienAuswaehlenBtn.Checked:=Status;
   1: LogFileBtn.Checked:=Status;
   2: WebalizerOptionenBtn.Checked:=Status;
   3: WeitereOptionenBtn.Checked:=Status;
   4: ZusaetzlicherHTMLCodeBtn.Checked:=Status;
   5: HideGroupIgnoreIncludeBtn.Checked:=Status;
   6: FormatGraphsBtn.Checked:=Status;
   7: KonfigurationsdateiOutputBtn.Checked:=Status;
   8: GUIOptionenBtn.Checked:=Status;
end;
end;

procedure TMainForm.SetChanged(Status: Boolean);
begin
SaveListBtn.Enabled:=Status;
Changed:=Status;
end;

procedure TMainForm.SetRevDNSStatus(Status: Boolean);
begin
DNSCachefileLbl.Enabled:=Status; DNSChildProcessesLbl.Enabled:=Status;
DNSCachefile.Enabled:=Status; DNSCacheBtn.Enabled:=Status;
DNSChild.Enabled:=Status;
If WebalizerVersion>2020000 then begin
   DNSTTL.Enabled:=Status;
   DNSValidityLbl.Enabled:=Status;
end else begin
   DNSTTL.Enabled:=false;
   DNSValidityLbl.Enabled:=false;
end;
end;
{$ENDREGION}

{$REGION 'Find and Show Statistics'}
constructor TStartBrowserThread.Create(URL: String);
begin
inherited Create(false);
fURL:=URL;
FreeOnTerminate:=true;
end;

procedure TStartBrowserThread.Execute;
{$IFDEF WIN32}
begin
ShellExecute(Application.Handle,'open',PCHar(fURL),nil,nil,sw_ShowNormal);
end;
{$ELSE}
const Browsers: Array[0..3] of String = ('konqueror','kfmclient openURL','mozilla','netscape');
var Command, ReturnVAL: String;
   i: Integer;
   Success: Boolean;
begin
Success:=false;
For i:=0 to 3 do if Success=false then begin
   { Nach vorhandenem Browser suchen => starten }
   Command:=Browsers[i]+' '+fURL;
   If Libc.system(PChar(Command))=0 then Success:=true;
end;
If Success=false then begin
   { keiner der obigen Browser gefunden, manuelle Eingabe erforderlich }
   If InputQuery(no_browser_found,select_browser,ReturnVAL) then begin
      Command:=ReturnVAL+' '+fURL;
      Libc.system(PChar(Command));
   end;
end;
end;
{$ENDIF}

procedure TMainForm.SearchStatistics;
var SearchRec: TSearchRec;
    EOFound: Boolean;
    DateString: String;
    Month: Array[1..12] of String;
begin
Month[1]:=january; Month[2]:=february; Month[3]:=march; Month[4]:=april; Month[5]:=may; Month[6]:=june; Month[7]:=july; Month[8]:=august;
Month[9]:=september; Month[10]:=october; Month[11]:=november; Month[12]:=december;
StatisticsList.Clear;
StatisticsFiles.Clear;
EOFound:=false;
If FindFirst(TargetDir+'usage_*.htm*',faAnyFile,SearchRec)=0 then
while not EOFound do begin
   DateString:=Month[StrToInt(Copy(SearchRec.Name,11,2))];
   DateString:=DateString+' '+Copy(SearchRec.Name,7,4);
   StatisticsList.Items.Add(DateString);
   StatisticsFiles.Add(SearchRec.Name);
   EOFound:=(FindNext(SearchRec)<>0);
end;
FindClose(SearchRec);
StatisticsList.ItemIndex:=StatisticsList.Items.Count-1;
end;

procedure TMainForm.OpenStatistics(Index: Integer; Chapter: String);
var Filename: String;
begin
If Index=-1 then begin
   MessageDlg(select_month,mtInformation,[mbOK],0);
   Exit;
end;
If Chapter='index' then begin
   If FileExists(TargetDir+'index.html') then Filename:=TargetDir+'index.html'
   else if FileExists(TargetDir+'index.htm') then Filename:=TargetDir+'index.htm'
   else MessageDlg(statistic_files_not_found,mtInformation,[mbOK],0);
end else begin
   If FileExists(TargetDir+StatisticsFiles.Strings[Index]) then Filename:=TargetDir+StatisticsFiles.Strings[Index]+Chapter
   else MessageDlg(statistic_files_not_found,mtInformation,[mbOK],0);
end; 
{$IFDEF WIN32}
If UseStandartBrowserCheck.Checked then
   TStartBrowserThread.Create(Filename)
else begin
   If BrowserForm=nil then BrowserForm:=TBrowserForm.Create(Application);
   BrowserForm.Show;
   BrowserForm.WebBrowser.Navigate(Filename);
   If Chapter='index' then BrowserForm.StatisticsComboBox.ItemIndex:=StatisticsList.ItemIndex
   else BrowserForm.StatisticsComboBox.ItemIndex:=Index;
end;
{$ELSE}
TStartBrowserThread.Create(Filename);
{$ENDIF}
end;
{$ENDREGION}

{$REGION 'On Button Click'}
procedure TMainForm.OnBtnClick(Sender: TObject);
var Info: TInfofenster;
begin
Case TComponent(Sender).Tag of
1: begin
      SetTabStatus(0,true);
      PageControl.ActivePage:=ChoseFiles;
   end;
53: begin
      SetTabStatus(1,true);
      PageControl.ActivePage:=LogPreprocessingTab;
    end;
2: begin
      SetTabStatus(2,true);
      PageControl.ActivePage:=LayoutTab;
   end;
3: begin
      SetTabStatus(3,true);
      PageControl.ActivePage:=SettingsTab;
   end;
4: begin
      SetTabStatus(4,true);
      PageControl.ActivePage:=AdditionalHTMLTab;
   end;
5: begin
      SetTabStatus(5,true);
      PageControl.ActivePage:=HGIITab;
   end;
6: begin
      SetTabStatus(7,true);
      PageControl.ActivePage:=OutputTab;
   end;
7: begin
      SetTabStatus(8,true);
      PageControl.ActivePage:=GUIOptionsTab;
   end;
8: SetTabStatus(PageControl.ActivePageIndex,false);
11: If AdvancedMode=true then ChangeMode(false) else ChangeMode(true);
12: ShowHelp(PageControl.ActivePage.HelpKeyword,{$IFDEF WIN32}HH_DISPLAY_TOPIC{$ELSE}0{$ENDIF});
13: Close;
14: If CheckForChangedList then begin
       NewList;
       SetChanged(false);
    end;
15: If CheckForChangedList then ImportConfigurationFile;
16: If CheckForChangedList then LoadList('');
17: SaveList;
18: begin
       ListFile:='unknown';
       SaveList;
    end;
23: begin
       SetDomainFilter(EnableDomainFilterCheck.Checked);
    end;
25: begin { Zielverzeichniss whlen } 
       OpenDialog.Filename:='index.html';
       OpenDialog.Filter:=all_files_dlg;
       TargetDir:=CleanDir(OutputDir.Text);
       If DirectoryExists(TargetDir) then OpenDialog.InitialDir:=TargetDir else OpenDialog.InitialDir:=HomeDir;
       If OpenDialog.Execute then begin
          TargetDir:=ExtractFilePath(OpenDialog.Filename);
          OutputDir.Text:=TargetDir;
          SearchStatistics;
          SetChanged(true);
       end;
    end;
30: begin { Verlassen des OutputDir Eingabefeldes }
       TargetDir:=CleanDir(OutputDir.Text);
       OutputDir.Text:=TargetDir;
       SearchStatistics;
       SetChanged(true);
    end;
26: begin { Reverse DNS Lookups aktivieren }
       SetRevDNSStatus(EnableRevDNSLookupsCheck.Checked);
       SetChanged(true);
    end;
{$IFDEF WIN32}
29: SetLanguage(Language.ItemIndex,true);
{$ENDIF}
31: begin
       Info:=TInfofenster.Create(self);
       {$IFDEF WIN32} Info.PopupParent:=self; {$ENDIF}
       Try Info.ShowModal;
       finally FreeAndNil(Info);
       end;
    end;
42: OpenStatistics(0,'index');
10: OpenStatistics(StatisticsList.ItemIndex,'');
32: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#DAYSTATS')
       else OpenStatistics(StatisticsList.ItemIndex,'#daily');
33: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#HOURSTATS')
       else OpenStatistics(StatisticsList.ItemIndex,'#hourly');
34: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPURLS')
       else OpenStatistics(StatisticsList.ItemIndex,'#urls');
35: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPSITES')
       else OpenStatistics(StatisticsList.ItemIndex,'#hosts');
36: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPENTRY')
       else OpenStatistics(StatisticsList.ItemIndex,'#entry');
37: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPEXIT')
       else OpenStatistics(StatisticsList.ItemIndex,'#exit');
38: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPREFS')
       else OpenStatistics(StatisticsList.ItemIndex,'#referrers');
39: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPSEARCH')
       else OpenStatistics(StatisticsList.ItemIndex,'#search');
40: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPUSERS')
       else OpenStatistics(StatisticsList.ItemIndex,'#users');
41: If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPAGENTS')
       else OpenStatistics(StatisticsList.ItemIndex,'#useragents');
43: If (CheckForChangedList) and (FileExists(TMenuItem(Sender).Caption)) then LoadList(TMenuItem(Sender).Caption);
45: begin { Konfigurationsdatei speichern unter... }
      SaveDialog.Filename:='';
      SaveDialog.Filter:=configfile_dlg;
      SaveDialog.DefaultExt:='*.config';
      If SaveDialog.Execute then begin
        CreateConfigFile;
        Config.Lines.SaveToFile(SaveDialog.FileName);
      end;
    end;
46: begin { Webalizer Output speichern unter... }
      SaveDialog.Filename:='';
      SaveDialog.Filter:=all_files_dlg;
      SaveDialog.DefaultExt:='*.txt';
      If SaveDialog.Execute then Output.Lines.SaveToFile(SaveDialog.FileName);
    end;
47: begin { Gesplittetes Logfile speichern unter... }
      OpenDialog.FileName:=SaveCompressedLogIn.Text+'logfile';
      OpenDialog.Filter:=all_files_dlg;
      If DirectoryExists(SaveCompressedLogIn.Text) then OpenDialog.InitialDir:=SaveCompressedLogIn.Text
         else OpenDialog.InitialDir:=HomeDir;
      If OpenDialog.Execute then SaveCompressedLogIn.Text:=CleanDir(ExtractFileDir(OpenDialog.FileName));
    end;
48: begin { Verlassen des SaveCompressedLogIn Eingabefeldes }
      SaveCompressedLogIn.Text:=CleanDir(SaveCompressedLogIn.Text);
      If SaveCompressedLogIn.Text='' then MessageDlg(no_dir_for_splitted_log,mtError,[mbOK],0);
      SetChanged(true);
    end;
49: begin
      DNSCachefile.Text:=Trim(DNSCachefile.Text);
      SetChanged(true);
    end;
50: begin
      DomainEdit.Text:=Trim(DomainEdit.Text);
      SetChanged(true);
    end;
51: SetDomainFilter(EnableDomainFilterCheck.Checked);
52: begin { DNS-Cachefile auswhlen }
      OpenDialog.FileName:=ExtractFileName(DNSCachefile.Text);
      OpenDialog.DefaultExt:='*.db';
      OpenDialog.Filter:=all_files_dlg;
      If DirectoryExists(ExtractFileDir(DNSCachefile.Text)) then OpenDialog.InitialDir:=ExtractFileDir(DNSCachefile.Text)
         else OpenDialog.InitialDir:=HomeDir;
      If OpenDialog.Execute then begin
         DNSCachefile.Text:=OpenDialog.FileName;
         SetChanged(true);
      end;
    end;
54: begin { CSS-Verzeichiss auswhlen... }
      OpenDialog.FileName:='webalizer.css';
      OpenDialog.DefaultExt:='*.css';
      OpenDialog.Filter:=css_dlg;
      If DirectoryExists(CSSDir.Text) then OpenDialog.InitialDir:=CSSDir.Text else OpenDialog.InitialDir:=HomeDir;
      If OpenDialog.Execute then begin
         CSSDir.Text:=CleanDir(ExtractFileDir(OpenDialog.FileName));
         SetChanged(true);
      end;
    end;
55: begin { Verlassen des CSS Dir Eingabefeldes }
      CSSDir.Text:=CleanDir(CSSDir.Text);
      SetChanged(true);
    end;
56: begin { Webalizer Executable auswhlen... }
      {$IFDEF WIN32}
      OpenDialog.FileName:='webalizer.exe';
      OpenDialog.DefaultExt:='*.exe';
      {$ELSE}
      OpenDialog.FileName:='webalizer';
      OpenDialog.DefaultExt:='';
      {$ENDIF}
      OpenDialog.Filter:=all_files_dlg;
      If DirectoryExists(WebalizerDir) then OpenDialog.InitialDir:=WebalizerDir else OpenDialog.InitialDir:=HomeDir;
      If OpenDialog.Execute then begin
         If FileExists(OpenDialog.Filename) then begin
            WebalizerDir:=CleanDir(ExtractFilePath(OpenDialog.FileName));
            WriteWebalizerDir(WebalizerDir);
            GetWebalizerVersion;
         end;
      end;
    end;
60: SetStandartBrowser;
63: begin { Verlassen des GeoIP Database Eingabefeldes }
      Trim(GeoIPDB.Text);
      SetChanged(true);
    end;
64: begin { GeoIPDB auswhlen... }
      OpenDialog.FileName:='GeoIP.dat';
      OpenDialog.DefaultExt:='*.dat';
      OpenDialog.Filter:=all_files_dlg;
      If DirectoryExists(GeoIPDB.Text) then OpenDialog.InitialDir:=GeoIPDB.Text else OpenDialog.InitialDir:=HomeDir;
      If OpenDialog.Execute then begin
         GeoIPDB.Text:=OpenDialog.FileName;
         SetChanged(true);
      end;
    end;
65: begin { Logtype ndern }
       If LogTypeBox.Text='apache' then begin
         ApacheLogFormat.Enabled:=true;
         ApacheLogFormatLbl.Enabled:=true;
       end else begin
         ApacheLogFormat.Enabled:=false;
         ApacheLogFormatLbl.Enabled:=false;
       end;
    end;
76: begin
       ColorDialog.Color:=GraphGridlineColor.Font.Color;
       If ColorDialog.Execute then GraphGridlineColor.Font.Color:=ColorDialog.Color;
    end;
77: begin
       ColorDialog.Color:=GraphBackgroundColor.Font.Color;
       If ColorDialog.Execute then GraphBackgroundColor.Font.Color:=ColorDialog.Color;
    end;
78: begin
       ColorDialog.Color:=GraphLegendColor.Font.Color;
       If ColorDialog.Execute then GraphLegendColor.Font.Color:=ColorDialog.Color;
    end;
79: begin
       ColorDialog.Color:=GraphVolumeColor.Font.Color;
       If ColorDialog.Execute then GraphVolumeColor.Font.Color:=ColorDialog.Color;
    end;
80: begin
       ColorDialog.Color:=GraphShadowColor.Font.Color;
       If ColorDialog.Execute then GraphShadowColor.Font.Color:=ColorDialog.Color;
    end;
81: begin
       ColorDialog.Color:=GraphOutlineColor.Font.Color;
       If ColorDialog.Execute then GraphOutlineColor.Font.Color:=ColorDialog.Color;
    end;
82: begin
       ColorDialog.Color:=GraphTitleColor.Font.Color;
       If ColorDialog.Execute then GraphTitleColor.Font.Color:=ColorDialog.Color;
    end;
83: begin
       ColorDialog.Color:=GraphVisitsColor.Font.Color;
       If ColorDialog.Execute then GraphVisitsColor.Font.Color:=ColorDialog.Color;
    end;
84: begin
       ColorDialog.Color:=GraphHitsColor.Font.Color;
       If ColorDialog.Execute then GraphHitsColor.Font.Color:=ColorDialog.Color;
    end;
85: begin
       ColorDialog.Color:=GraphPagesColor.Font.Color;
       If ColorDialog.Execute then GraphPagesColor.Font.Color:=ColorDialog.Color;
    end;
86: begin
       ColorDialog.Color:=GraphHostsColor.Font.Color;
       If ColorDialog.Execute then GraphHostsColor.Font.Color:=ColorDialog.Color;
    end;
87: begin
       ColorDialog.Color:=GraphWeekendColor.Font.Color;
       If ColorDialog.Execute then GraphWeekendColor.Font.Color:=ColorDialog.Color;
    end;
88: begin
       ColorDialog.Color:=GraphFilesColor.Font.Color;
       If ColorDialog.Execute then GraphFilesColor.Font.Color:=ColorDialog.Color;
    end;
91: begin
      OpenDialog.FileName:='';
      {$IFDEF WIN32}
      If DirectoryExists(GetWinDir+'\fonts\') then OpenDialog.InitialDir:=GetWinDir+'\fonts\';
      {$ELSE}
      OpenDialog.InitialDir:='/';
      {$ENDIF}
      OpenDialog.DefaultExt:='*.ttf';
      OpenDialog.Filter:='True Type Fonts (*.ttf)|*.ttf';
      If OpenDialog.Execute then begin
         GraphFontNormal.Text:=OpenDialog.FileName;
         SetChanged(true);
      end;
    end;
92: begin
      OpenDialog.FileName:='';
      {$IFDEF WIN32}
      If DirectoryExists(GetWinDir+'\fonts\') then OpenDialog.InitialDir:=GetWinDir+'\fonts\';
      {$ELSE}
      OpenDialog.InitialDir:='/';
      {$ENDIF}
      OpenDialog.DefaultExt:='*.ttf';
      OpenDialog.Filter:='True Type Fonts (*.ttf)|*.ttf';
      If OpenDialog.Execute then begin
         GraphFontBold.Text:=OpenDialog.FileName;
         SetChanged(true);
      end;
    end;
93: begin
       If WebalizerVersion<2020000 then OpenStatistics(StatisticsList.ItemIndex,'#TOPCTRYS')
       else OpenStatistics(StatisticsList.ItemIndex,'#countries');
    end;
94: begin
       If WebalizerVersion>=2020000 then OpenStatistics(StatisticsList.ItemIndex,'#errors');
    end;
95: begin
      SetTabStatus(6,true);
      PageControl.ActivePage:=FormatGraphsTab;
    end;
96: begin
      If (ProviderComboBox.ItemIndex=1) or (ProviderComboBox.ItemIndex=2) or (ProviderComboBox.ItemIndex=4) then begin
         MessageDlg(splitting_not_possible,mtError,[mbOK],0);
         ProviderComboBox.ItemIndex:=0;
      end;
      SetChanged(true);
    end;
end;
end;
{$ENDREGION}

function TMainForm.CleanDir(Dir: String): string;
begin
Result:=Trim(Dir);
If (Result<>'') and (Result[Length(Result)]<>PathDelim) then Result:=Result+PathDelim;
end;

{$REGION 'Logfile Add / Delete / Up / Down'}
procedure TMainForm.AddBtnClick(Sender: TObject);   { Logfile zur Liste hinzufgen }
var Exists: Boolean;
    CtrI, CtrII: Integer;
begin
OpenDialog.Filename:='';
If DirectoryExists(LastLogDir) then OpenDialog.InitialDir:=LastLogDir else OpenDialog.InitialDir:=HomeDir;
OpenDialog.Filter:=all_files_dlg;
If OpenDialog.Execute then begin
   For CtrI:=0 to OpenDialog.Files.Count-1 do begin
       Exists:=false;
       For CtrII:=0 to LogList.Items.Count-1 do begin
           If CompareText(OpenDialog.Files[CtrI],LogList.Items[CtrII])=0 then begin
              Exists:=true;
              Break;
           end;
       end;
       If Exists=false then begin
          LogList.Items.Add('0'+OpenDialog.Files[CtrI]);   { Ein '0' vor der Dateiangabe bedeutet, da das Logfile noch nicht analysiert wurde }
          LogList.Selected[LogList.Items.Count-1]:=true;
       end;
   end;
   SetChanged(true);
   LastLogDir:=ExtractFileDir(OpenDialog.Filename);
end;
end;

procedure TMainForm.DelBtnClick(Sender: TObject);    { Logfile aus der Liste lschen }
var Ctr: Integer;
begin
Ctr:=0;
While Ctr<LogList.Items.Count do begin
   If LogList.Selected[Ctr] then begin
      LogList.Items.Delete(Ctr);
      Dec(Ctr);
   end;
   Inc(Ctr);
end;
SetChanged(true);
end;

procedure TMainForm.UpBtnClick(Sender: TObject);  { Logfile nach oben verschieben }
var Ctr: Integer;
begin
For Ctr:=1 to LogList.Items.Count-1 do if LogList.Selected[Ctr] then begin
   LogList.Items.Move(Ctr,Ctr-1);
   LogList.Selected[Ctr-1]:=true;
end;
SetChanged(true);
end;

procedure TMainForm.DownBtnClick(Sender: TObject);  { Logfile nach unten verschieben }
var Ctr: Integer;
begin
For Ctr:=LogList.Items.Count-2 downto 0 do if LogList.Selected[Ctr] then begin
    LogList.Items.Move(Ctr,Ctr+1);
    LogList.Selected[Ctr+1]:=true;
end;
SetChanged(true);
end;
{$ENDREGION}

procedure TMainForm.LogListDrawItem(
  {$IFDEF WIN32}Control: TWinControl;Index: Integer; Rect: TRect; State: TOwnerDrawState
  {$ELSE}Sender: TObject; Index: Integer; Rect: TRect; State: TOwnerDrawState; var Handled: Boolean{$ENDIF});
var Logfile: String;
    Bitmap: TBitmap;
begin
Bitmap:=TBitmap.Create;
LogList.Canvas.FillRect(Rect); { Rechteck lschen }
Case StrToInt(Copy(LogList.Items[Index],1,1)) of   { Status-LED anzeigen }
0: Bitmap.LoadFromResourceName(HInstance,'yellow');
1: Bitmap.LoadFromResourceName(HInstance,'green');
2: Bitmap.LoadFromResourceName(HInstance,'red');
end;
LogList.Canvas.Draw(1,Rect.Top+1,Bitmap);
Logfile:=LogList.Items[Index]; Delete(Logfile,1,1);
If LogList.Canvas.TextWidth(Logfile)>(Rect.Right-25) then begin   { Falls die Dateiangabe nicht in die List-Box passt... }
   Repeat                                                         { ...wird aus der Mitte solange ein Zeichen entfernt... }
      Delete(Logfile,Trunc(Length(Logfile)/2)-2,4);
      Insert('...',Logfile,Trunc(Length(Logfile)/2));             { ...und drei Punkte eingefgt... }
   until LogList.Canvas.TextWidth(Logfile)<=(Rect.Right-25);      { ...bis es passt. }
end;
LogList.Canvas.TextOut(18,Rect.Top+2,Logfile);                    { Text anzeigen }
Bitmap.Free;
end;

procedure TMainForm.RunBtnClick(Sender: TObject);   { Webalizer ausfhren }
begin
If LogList.SelCount<1 then begin
   MessageDlg(select_logfiles,mtInformation,[mbOK],0);
   Exit;
end;
If CheckTargetDir(TargetDir)=false then begin
   MessageDlg(chose_stats_dir,mtError,[mbOK],0);
   Exit;
end;
ChoseFiles.Enabled:=false;
Webalize:=TWebalize.Create;
Webalize.OnTerminate:=WebalizeDone;
Webalize.Logfiles:=LogList;
Webalize.EnableFilter:=EnableDomainFilterCheck.Checked;
If EnableDomainFilterCheck.Checked then begin
   Webalize.Provider:=ProviderComboBox.ItemIndex;
   Webalize.Domain:=DomainEdit.Text;
   Webalize.MixDomains:=MixDomainsCheck.Checked;
   Webalize.RemoveDomain:=RemoveDomainBox.Checked;
   Webalize.SaveFilteredLog:=SaveFilteredLogCheck.Checked;
   Webalize.CompressLog:=CompressLogCheck.Checked;
   Webalize.SaveCompressedLogIn:=CleanDir(SaveCompressedLogIn.Text);
end else begin Webalize.SaveFilteredLog:=false; { Damit beim Entfernen der Hostnamen das gefilterte Logfile nicht aus versehen gespeichert wird }
   Webalize.CompressLog:=false;
end;
Webalize.RemoveHost:=RemoveBeginningHostname.Checked;
If RemoveBeginningHostname.Checked then begin
   Webalize.Hostname:=Hostname.Text;
   If Copy(Webalize.Hostname,1,7)='http://' then Delete(Webalize.Hostname,1,7);
   If Copy(Webalize.Hostname,1,4)='www.' then Delete(Webalize.Hostname,1,4);
   If Webalize.Hostname<>'' then begin
      If Webalize.Hostname[Length(Webalize.Hostname)]='/' then Delete(Webalize.Hostname,Length(Webalize.Hostname),1);
   end else Webalize.RemoveHost:=false;
end;
Webalize.TempDir:=TempDir;
Webalize.WebalizerDir:=WebalizerDir;
ProgressForm:=TProgressForm.Create(Application);
ProgressForm.ProgressBar.Max:=LogList.SelCount*2;
ProgressForm.Doing_With_Label.Caption:=creating_configfile;
ProgressForm.Show;
{$IFDEF WIN32}
{ Ein bisschen Spa mu sein }
If FileExists(GetWinDir+'\cursors\dinosaur.ani') then Screen.Cursors[1]:=LoadCursorFromFile(PChar(GetWinDir+'\cursors\dinosaur.ani')) else Screen.Cursor:=crHourGlass;
Screen.Cursor:=1;
{$ENDIF}
Output.Clear;
CreateConfigFile;   { Konfigurationsdatei fr webalizer.exe erzeugen }
{$IFDEF WIN32}
Config.Lines.SaveToFile(TempDir+'webalizer.conf');
{$ELSE}
If FileExists(GetEnvironmentVariable('HOME')+'/.webalizer.conf.bak') then DeleteFile(GetEnvironmentVariable('HOME')+'/.webalizer.conf.bak');
If FileExists(GetEnvironmentVariable('HOME')+'/.webalizer.conf') then RenameFile(GetEnvironmentVariable('HOME')+'/.webalizer.conf',GetEnvironmentVariable('HOME')+'/.webalizer.conf.bak');
Config.Lines.SaveToFile(GetEnvironmentVariable('HOME')+'/.webalizer.conf');
{$ENDIF}
Webalize.Resume;
end;

procedure TMainForm.WebalizeDone(Sender: TObject);
{$IFDEF WIN32}
var Locat: String;
    Posi: Integer;
{$ENDIF}
begin
If FileExists(TempDir+'webalizer.conf') then DeleteFile(TempDir+'webalizer.conf');  { Die erzeugte Konfigurationsdatei wird wieder gelscht }
If FileExists(TempDir+'splitted_log.tmp') then DeleteFile(TempDir+'splitted_log.tmp');  { splitted_log.tmp wird eventuell gelscht }
SearchStatistics;
SetChanged(true);
{$IFDEF WIN32}
If BrowserForm<>nil then begin
   Locat:=BrowserForm.WebBrowser.LocationURL;
   Delete(Locat,1,8);
   Posi:=Pos('/',Locat);
   While Posi<>0 do begin
     Delete(Locat,Posi,1);
     Insert('\',Locat,Posi);
     Posi:=Pos('/',Locat);
   end;
   Posi:=Pos('%20',Locat);
   While Posi<>0 do begin
     Delete(Locat,Posi,3);
     Insert(' ',Locat,Posi);
     Posi:=Pos('%20',Locat);
   end;
   If FileExists(Locat) then begin
      BrowserForm.WebBrowser.Refresh;
   end;
end else {$ENDIF} if ShowStatsCheck.Checked then OpenStatistics(0,'index');
ProgressForm.Free;
ChoseFiles.Enabled:=true;
Screen.Cursor:=crDefault;
end;

function TMainForm.CheckTargetDir(Directory: String): Boolean;
var Verz: String;
    Search: TSearchRec;
begin
Result:=true;
If Trim(TargetDir)='' then begin
   Result:=false;
end else begin
   If DirectoryExists(TargetDir) then begin  { Ausgabeverzeichnis existiert bereits }
      {$IFDEF WIN32}
      If ((FileGetAttr(TargetDir) and faReadOnly)<>0) { Checke, ob man auch Schreibzugriff auf das Zielverzeichnis hat }
      or ((FileExists(TargetDir+'index.htm')) and ((FileGetAttr(TargetDir+'index.htm') and faReadOnly)<>0))
      or ((FileExists(TargetDir+'index.html')) and ((FileGetAttr(TargetDir+'index.html') and faReadOnly)<>0))
      or ((FileExists(TargetDir+'webalizer.current')) and ((FileGetAttr(TargetDir+'webalizer.current') and faReadOnly)<>0))
      or ((FileExists(TargetDir+'webalizer.hist')) and ((FileGetAttr(TargetDir+'webalizer.hist') and faReadOnly)<>0)) then begin
         MessageDlg(no_write_access,mtError,[mbOK],0);
         Result:=false;
         Exit;
      end;
      {$ENDIF}
      If DeleteExisting.Checked then begin   { Gegebenenfalls Ziel-Verzeichnis lschen }
         Verz:=TargetDir;
         If FindFirst(Verz+'*',$23,Search)=0 then repeat
            DeleteFile(Verz+Search.Name);
         until FindNext(Search)<>0;
         FindClose(Search);
      end;
   end else CreateDir(TargetDir); { Falls das Ausgabe-Verzeichniss nicht existiert wird es erzeugt }
end;
end;

function TMainForm.LangTextToFilename(LangText: String): String;
var i: Integer;
begin
i:=-1;
Repeat
  Inc(i);
until (i=33) or (LangText=WebalizerLangs[i]);
If i<33 then Result:=WebalizerLangFiles[i] else Result:='english';
end;

function TMainForm.FilenameToLangText(FileName: String): String;
var i: Integer;
begin
i:=-1;
Repeat
  Inc(i);
until (i=33) or (FileName=WebalizerLangFiles[i]);
If i<33 then Result:=WebalizerLangs[i] else Result:=english;
end;

{$IFDEF WIN32}
procedure TMainForm.GetInstalledLanguages;
var Ctr: Integer;
begin
Ctr:=0;
If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.DEU') then begin Language.Items.Add('Deutsch'); Inc(Ctr); end;
If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.ENU') then begin Language.Items.Add('English'); Inc(Ctr); end;
If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.ESP') then begin Language.Items.Add('Espanol'); Inc(Ctr); end;
If Ctr>1 then begin
   Language.Enabled:=true; LanguageLbl.Enabled:=true;
end else begin
   Language.Enabled:=false; LanguageLbl.Enabled:=false;
end;
end;
{$ENDIF}

procedure TMainForm.SetLanguage(LangID: Integer; SaveBeforeChange: Boolean);
{$IFDEF WIN32}
var TmpListFile, TmpMode, TmpWebalizerExe, TmpLanguage: String;
    TmpBackup: Boolean;
    TmpTop, TmpLeft, TmpWidth, TmpHeight: Integer;
{$ENDIF} begin {$IFDEF WIN32}
TmpBackup:=BackupCheck.Checked;
TmpTop:=Top; TmpLeft:=Left; TmpWidth:=Width; TmpHeight:=Height;
TmpWebalizerExe:=WebalizerExecutable.Text;
TmpLanguage:=LangTextToFilename(StatLanguage.Text);
If SaveBeforeChange then begin
   TmpListFile:=ListFile; ListFile:=TempDir+'ListFile.tmp';
   BackupCheck.Checked:=false;
   SaveList;
end;
Case LangID of
0: { Deutsch }
    If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.DEU') and (LoadNewResourceModule((SUBLANG_GERMAN shl 10) or LANG_GERMAN) <> 0) then begin
       ReinitializeForms;
       If StatLanguage.Items.IndexOf(german)<>-1 then StatLanguage.Text:=german;
       If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.DEU.chm') then Application.HelpFile:=ExtractFilePath(Application.ExeName)+'WebalizerGUI.DEU.chm';
    end;
1: { Englisch }
    If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.ENU') and (LoadNewResourceModule((SUBLANG_ENGLISH_US shl 10) or LANG_ENGLISH) <> 0) then begin
       ReinitializeForms;
       If StatLanguage.Items.IndexOf(english)<>-1 then StatLanguage.Text:=english;
       If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.ENU.chm') then Application.HelpFile:=ExtractFilePath(Application.ExeName)+'WebalizerGUI.ENU.chm';
    end;
2: { Spanisch }
    If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.ESP') and (LoadNewResourceModule((SUBLANG_SPANISH shl 10) or LANG_SPANISH) <> 0) then begin
       ReinitializeForms;
       If StatLanguage.Items.IndexOf(spanish)<>-1 then StatLanguage.Text:=spanish;
       If FileExists(ExtractFilePath(Application.ExeName)+'WebalizerGUI.ESP.chm') then Application.HelpFile:=ExtractFilePath(Application.ExeName)+'WebalizerGUI.ESP.chm';
    end;
end;
LanguageID:=LangID;
If SaveBeforeChange then begin
   LoadList(ListFile);
   If FileExists(ListFile) then DeleteFile(ListFile);
   ListFile:=TmpListFile;
   Caption:='Webalizer - '+ExtractFileName(ListFile);
   BackupCheck.Checked:=TmpBackup;
end;
If AdvancedMode then TmpMode:=simple_mode else TmpMode:=advanced_mode; { Ansonsten zeigt der Mode-Button nach dem Reinitialisieren immer 'Simple Mode' an }
ModeBtn.Caption:=TmpMode;
SetBounds(TmpLeft,TmpTop,TmpWidth,TmpHeight);
WebalizerExecutable.Text:=TmpWebalizerExe;
{$ENDIF}
WebalizerLangs[0]:=catalan; WebalizerLangs[1]:=croatian; WebalizerLangs[2]:=czech; WebalizerLangs[3]:=danish; WebalizerLangs[4]:=dutch;
WebalizerLangs[5]:=english; WebalizerLangs[6]:=estonian; WebalizerLangs[7]:=finnish; WebalizerLangs[8]:=french; WebalizerLangs[9]:=galician;
WebalizerLangs[10]:=german; WebalizerLangs[11]:=greek; WebalizerLangs[12]:=hungarian; WebalizerLangs[13]:=icelandic; WebalizerLangs[14]:=indonesian;
WebalizerLangs[15]:=italian; WebalizerLangs[16]:=japanese; WebalizerLangs[17]:=korean; WebalizerLangs[18]:=latvian; WebalizerLangs[19]:=malay;
WebalizerLangs[20]:=norwegian;WebalizerLangs[21]:=polish; WebalizerLangs[22]:=portuguese; WebalizerLangs[23]:=romanian;
WebalizerLangs[24]:=russian; WebalizerLangs[25]:=serbian; WebalizerLangs[26]:=simplified_chinese; WebalizerLangs[27]:=slovak;
WebalizerLangs[28]:=slovene; WebalizerLangs[29]:=spanish; WebalizerLangs[30]:=swedish; WebalizerLangs[31]:=turkish; WebalizerLangs[32]:=ukrainian;
{$IFDEF WIN32} StatLanguage.Text:=FilenameToLangtext(TmpLanguage); {$ENDIF}
end;

{$IFDEF WIN32}
function TMainForm.GetWinDir: String;
var CursorFile: PChar;
begin
CursorFile:=StrAlloc(MAX_PATH+1);
GetWindowsDirectory(CursorFile, MAX_PATH+25);
Result:=CursorFile;
StrDispose(CursorFile);
end;
{$ENDIF}

procedure TMainForm.GUIOptionsTabShow(Sender: TObject);
begin
Case LanguageID of
0: Language.Text:=german;
1: Language.Text:=english;
2: Language.Text:=spanish;
end;
end;

procedure TMainForm.DeleteExistingClick(Sender: TObject);
begin
SetChanged(true);
end;

procedure TMainForm.ShowHintsCheckClick(Sender: TObject);
begin
Application.ShowHint:=ShowHintsCheck.Checked;
end;

procedure TMainForm.ChangeMode(TurnInAdvancedMode: Boolean);
var Ctr: Integer;
begin
If TurnInAdvancedMode=false then begin { In Simple Mode schalten }
   AdvancedMode:=false;
   ModeBtn.Caption:=advanced_mode;   {'Advanced Mode'}
   ModeBtn.Glyph.LoadFromResourceName(HInstance,'complex');
   SetTabStatus(0,true); SetTabStatus(2,true); SetTabStatus(8,true);
   SetTabStatus(1,false); SetTabStatus(3,false); SetTabStatus(4,false); SetTabStatus(5,false); SetTabStatus(6,false); SetTabStatus(7,false);
end else begin       { In Advanced Mode schalten }
   AdvancedMode:=true;
   ModeBtn.Caption:=simple_mode;    {'Simple Mode' }
   ModeBtn.Glyph.LoadFromResourceName(HInstance,'simple');
   For Ctr:=0 to 8 do SetTabStatus(Ctr,true);
end;
end;
 
procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
{$IFDEF WIN32}
If (Key=VK_F1) and (TControl(ActiveControl).HelpKeyword<>'') then begin
   If ActiveControl is TPageControl then ShowHelp(PageControl.ActivePage.HelpKeyword,HH_DISPLAY_TOPIC)
   else ShowHelp('descriptions/'+TControl(ActiveControl).HelpKeyword,HH_DISPLAY_INDEX);
{$ELSE}
If (Key=Key_F1) and (TControl(ActiveControl).HelpKeyword<>'') then begin
   If ActiveControl is TPageControl then ShowHelp(PageControl.ActivePage.HelpKeyword,0)
   else ShowHelp('descriptions/'+TControl(ActiveControl).HelpKeyword,0);
{$ENDIF}
end;
end;

procedure TMainForm.ShowHelp(Keyword: String; UCommand: Cardinal);
{$IFDEF WIN32}
begin
HTMLHelp(self.Handle,PChar(Application.HelpFile+'::/'+Keyword+'.html'),UCommand,0);
{$ELSE}
var Command: String;
begin
If DirectoryExists(ExtractFilePath(Application.ExeName)+'help/') then Command:=ExtractFilePath(Application.ExeName)+'help/'
else if DirectoryExists('/usr/local/doc/xwebalizer/') then Command:='/usr/local/doc/xwebalizer/'
else if DirectoryExists('/usr/share/doc/xwebalizer/') then Command:='/usr/share/doc/xwebalizer/'
else if DirectoryExists('/usr/doc/xwebalizer/') then Command:='/usr/doc/xwebalizer/';
Case LanguageID of
0: Command:=Command+'deu/';
1: Command:=Command+'enu/';
2: Command:=Command+'esp/';
end;
Command:=Command+Keyword+'.html';
If FileExists(Command) then begin
   TStartBrowserThread.Create(Command);
end else MessageDlg(help_not_found,mtInformation,[mbOK],0);
{$ENDIF}
end;

{$REGION 'Resize Application'}
{$IFDEF WIN32}
procedure TMainForm.ChoseFilesResize(Sender: TObject);
begin
LogList.Width:=VertLine.Left-25;
ChooseTargetDirBtn.Left:=VertLine.Left-35;
OutputDir.Width:=VertLine.Left-50;
StatisticsList.SetBounds(VertLine.Left+15,60,ChoseFiles.Width-StatisticsList.Left-13,StatisticsList.Height);
OutputLbl.Left:=VertLine.Left+20;
AvailableStatsLbl.Left:=OutputLbl.Left;
end;

procedure TMainForm.SettingsTabResize(Sender: TObject);
begin
SearchEngines.SetBounds(400,35,SettingsTab.Width-418,Round((SettingsTab.Height-116)/3));
DownloadPathLbl.Top:=SearchEngines.Top+SearchEngines.Height+15;
DownloadPath.SetBounds(DownloadPath.Left,DownloadPathLbl.Top+15,SearchEngines.Width,SearchEngines.Height);
AdditionalTagsLbl.Top:=DownloadPath.Top+DownloadPath.Height+15;
AdditionalTags.SetBounds(AdditionalTags.Left,AdditionalTagsLbl.Top+15,SearchEngines.Width,SearchEngines.Height);
end;

procedure TMainForm.AdditionalHTMLTabResize(Sender: TObject);
begin
HTMLPre.SetBounds(15,30,Round(AdditionalHTMLTab.Width/2)-20,HTMLHeadLbl.Top-40);
HTMLHead.SetBounds(15,HTMLHeadLbl.Top+15,HTMLPre.Width,HTMLBodyLbl.Top-HTMLHead.Top-10);
HTMLBody.SetBounds(15,HTMLBodyLbl.Top+15,HTMLPre.Width,AdditionalHTMLTab.Height-HTMLBody.Top-10);
HTMLPost.SetBounds(HTMLPre.Width+25,30,HTMLPre.Width,HTMLPre.Height);
HTMLTail.SetBounds(HTMLPost.Left,HTMLHead.Top,HTMLPre.Width,HTMLHead.Height);
HTMLEnd.SetBounds(HTMLPost.Left,HTMLBody.Top,HTMLPre.Width,HTMLBody.Height);
HTMLPostLbl.Left:=HTMLPost.Left;
HTMLTailLbl.Left:=HTMLPost.Left;
HTMLEndLbl.Left:=HTMLPost.Left;
end;

procedure TMainForm.HGIITabResize(Sender: TObject);
begin
HideHostMemo.Width:=Round((HostTab.Width-40)/3);
GroupHostMemo.SetBounds(HideHostMemo.Width+20,25,HideHostMemo.Width,GroupHostMemo.Height);
IgnoreHostMemo.SetBounds(GroupHostMemo.Left+GroupHostMemo.Width+10,25,HideHostMemo.Width,Round((HostTab.Height-65)/2));
IncludeHostLbl.Top:=IgnoreHostMemo.Height+40;
IncludeHost.SetBounds(IgnoreHostMemo.Left,IncludeHostLbl.Top+15,HideHostMemo.Width,IgnoreHostMemo.Height);
GroupHostLbl.Left:=GroupHostMemo.Left;
IgnoreHostLbl.Left:=IgnoreHostMemo.Left;
IncludeHostLbl.Left:=IncludeHost.Left;

HideURLMemo.Width:=HideHostMemo.Width;
GroupURLMemo.SetBounds(GroupHostMemo.Left,25,GroupHostMemo.Width,GroupURLMemo.Height);
IgnoreURLMemo.BoundsRect:=IgnoreHostMemo.BoundsRect;
IncludeURLMemo.BoundsRect:=IncludeHost.BoundsRect;
GroupURLLbl.Left:=GroupHostLbl.Left;
IgnoreURLLbl.Left:=IgnoreHostLbl.Left;
IncludeURLLbl.Left:=IncludeHostLbl.Left;
IncludeURLLbl.Top:=IncludeHostLbl.Top;
RemoveBeginningHostname.Left:=GroupURLMemo.Left+15;

HideReferrerMemo.SetBounds(10,25,HideHostMemo.Width,IgnoreHostMemo.Height);
GroupReferrerMemo.SetBounds(GroupHostMemo.Left,25,GroupHostMemo.Width,IgnoreHostMemo.Height);
IgnoreReferrerMemo.BoundsRect:=IgnoreHostMemo.BoundsRect;
IncludeReferrer.SetBounds(GroupReferrerMemo.Left,IncludeHost.Top,IncludeHost.Width,IncludeHost.Height);
IgnoreReferrerRedirect.SetBounds(IgnoreReferrerMemo.Left,IncludeHost.Top,HideHostMemo.Width,IgnoreHostMemo.Height-40);
SpamReferrer.SetBounds(10,IncludeHost.Top,HideHostMemo.Width,IgnoreHostMemo.Height);
GroupReferrerLbl.Left:=GroupHostLbl.Left;
IgnoreReferrerLbl.Left:=IgnoreHostLbl.Left;
IgnoreReferrerRedirectLbl.SetBounds(IgnoreReferrerLbl.Left,IncludeHostLbl.Top,196,13);
IgnoreReferrerPartial.Left:=IgnoreReferrerLbl.Left+10;
IncludeReferrerLbl.SetBounds(GroupReferrerLbl.Left,IncludeHostLbl.Top,166,13);
SpamReferrerLbl.Top:=IncludeHostLbl.Top;

IncludeSearchArg.Width:=Round((SearchesTab.Width-30)/2);
ExcludeSearchArg.SetBounds(IncludeSearchArg.Width+20,25,IncludeSearchArg.Width,ExcludeSearchArg.Height);
ExcludeSearchArgLbl.Left:=ExcludeSearchArg.Left;

HideAgentMemo.Width:=HideHostMemo.Width;
GroupAgentMemo.BoundsRect:=GroupHostMemo.BoundsRect;
IgnoreAgentMemo.BoundsRect:=IgnoreHostMemo.BoundsRect;
IncludeUserAgent.BoundsRect:=IncludeHost.BoundsRect;
GroupAgentLbl.Left:=GroupHostLbl.Left;
AgentsLevelLbl.Left:=GroupHostLbl.Left+15;
MangleAgents.Left:=GroupHostLbl.Left+125;
IgnoreAgentLbl.Left:=IgnoreHostLbl.Left;
IncludeUserAgentLbl.SetBounds(IncludeHostLbl.Left,IncludeHostLbl.Top,153,13);

HideUserMemo.Width:=HideHostMemo.Width;
GroupUserMemo.BoundsRect:=GroupURLMemo.BoundsRect;
IgnoreUserMemo.BoundsRect:=IgnoreHostMemo.BoundsRect;
IncludeUserMemo.BoundsRect:=IncludeHost.BoundsRect;
GroupUserLbl.Left:=GroupHostLbl.Left;
IgnoreUserLbl.Left:=IgnoreHostLbl.Left;
IncludeUserLbl.SetBounds(IncludeHostLbl.Left,IncludeHostLbl.Top,153,13);
end;

procedure TMainForm.OutputTabResize(Sender: TObject);
begin
Config.Width:=Round(OutputTab.Width/2)-10;
Output.SetBounds(Config.Width+15,25,Config.Width,Output.Height);
WebalizerOutputLbl.Left:=Output.Left+5;
end;
{$ENDIF}
{$ENDREGION}

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
{$IFDEF WIN32}
var i: Integer;
    Registry: TRegistry;
begin
canClose:=CheckForChangedList;
If canClose then begin
   Registry:=TRegistry.Create;
   Registry.RootKey:=HKEY_CURRENT_USER;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true) then begin   { Fensterposition in der Registry speichern }
      Registry.WriteInteger('Left',Left);
      Registry.WriteInteger('Top',Top);
      Registry.WriteInteger('Height',Height);
      Registry.WriteInteger('Width',Width);
      Registry.CloseKey;
   end;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\Directories',true) then begin  { Verzeichnisse in der Registry speichern }
      Registry.WriteString('ListFile',ListFile);
      Registry.WriteString('LogDir',LastLogDir);
      Registry.WriteString('TargetDir',TargetDir);
      Registry.CloseKey;
   end;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\Configuration',true) then begin  { Sonstiges in der Registry speichern }
      Registry.WriteBool('Mode',AdvancedMode);
      Registry.WriteInteger('Language',LanguageID);
      Registry.WriteBool('LoadLastList',LoadListCheck.Checked);
      Registry.WriteBool('UseStandartBrowser',UseStandartBrowserCheck.Checked);
      Registry.WriteBool('ShowHints',ShowHintsCheck.Checked);
      Registry.WriteString('LastOpenList',SaveDialog.Filename);
      For i:=0 to 8 do Registry.WriteBool(Tabs[i],PageControl.Pages[i].TabVisible);
      Registry.CloseKey;
   end;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\OpenNew',true) then begin
      Registry.WriteString('Open1',NeuOeffnenBtn1.Caption);
      Registry.WriteString('Open2',NeuOeffnenBtn2.Caption);
      Registry.WriteString('Open3',NeuOeffnenBtn3.Caption);
      Registry.WriteString('Open4',NeuOeffnenBtn4.Caption);
      Registry.CloseKey;
   end;
   Registry.Free;
end;

{$ELSE}
var IniFile: TIniFile;
    i: Integer;
begin
canClose:=CheckForChangedList;
If canClose then begin
   IniFile:=TIniFile.Create(GetEnvironmentVariable('HOME')+'/.xwebalizer');
   IniFile.WriteInteger('ProgramProperty','IniFileVersion',232);
   IniFile.WriteString('Directories','ListFile',ListFile);     { Der Name der zuletzt verwendeten Log-Liste wird gespeichert }
   IniFile.WriteString('Directories','LogDir',LastLogDir);     { Das Verzeichnis des zuletzt verwendeten Log-Files wird gespeichert }
   IniFile.WriteString('Directories','TargetDir',TargetDir);   { Das zuletzt gewlte Zielverzeichnis wird gespeichert }
   {IniFile.WriteInteger('Configuration','Language',LanguageID);}
   IniFile.WriteBool('Configuration','Mode',AdvancedMode);
   IniFile.WriteBool('Configuration','LoadLastList',LoadListCheck.Checked);
   {IniFile.WriteBool('Configuration','UseStandartBrowser',UseStandartBrowserCheck.Checked);}
   For i:=0 to 8 do IniFile.WriteBool('Configuration',Tabs[i],PageControl.Pages[i].TabVisible);
   IniFile.WriteString('OpenNew','Open1',NeuOeffnenBtn1.Caption);
   IniFile.WriteString('OpenNew','Open2',NeuOeffnenBtn2.Caption);
   IniFile.WriteString('OpenNew','Open3',NeuOeffnenBtn3.Caption);
   IniFile.WriteString('OpenNew','Open4',NeuOeffnenBtn4.Caption);
   IniFile.WriteInteger('WindowPos','Left',Left);
   IniFile.WriteInteger('WindowPos','Top',Top);
   IniFile.WriteInteger('WindowPos','Width',Width);
   IniFile.WriteInteger('WindowPos','Height',Height);
   IniFile.WriteString('ProgramProperty','WebalizerExe',WebalizerDir); { Das Verzeichnis in dem Webalizer.exe liegt wird gespeichert }
   IniFile.UpdateFile;
   IniFile.Free;
end;
{$ENDIF}
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
StatisticsFiles.Free;
end;

end.
