{ Copyright (C) by Tobias Schwarz, 2003-2007
  Distributed under the GNU General Public License }

unit LoadSave;

interface

uses
SysUtils, 
{$IFDEF WIN32}
Controls, Dialogs, Classes, Windows, Forms, Graphics;
{$ELSE}
QControls, QForms, QDialogs, QGraphics;
{$ENDIF}

procedure LoadList(FileName: String);
procedure SaveList;
procedure NewList;
procedure ImportConfigurationFile;
procedure UpdateOpenNewMenu;
function CheckForChangedList: Boolean;
function HexToColor(Hex: String): TColor;

implementation

uses Main, Resourcestrings;

function CheckForChangedList:Boolean;
begin
Result:=true;
If MainForm.Changed then    { Bei nderungen an der Log-Liste nach Speichern fragen }
   Case MessageDlg(loglist_has_changed,mtConfirmation,[mbYes, mbNo, mbCancel],0) of
      mrYes: begin SaveList; Result:=true; end;
      mrNo: Result:=true;
      mrCancel: Result:=false;
   end;
end;

procedure UpdateOpenNewMenu; {OpenNew Men aktualisieren}
var Caption1, Caption2: String;
    Ctr, CtrII: Integer;
begin
If (MainForm.ListFile<>'unknown') and (MainForm.ListFile<>'') then begin
   Caption1:=MainForm.NeuOeffnenBtn4.Caption;
   MainForm.NeuOeffnenBtn4.Caption:=MainForm.NeuOeffnenBtn3.Caption;
   MainForm.NeuOeffnenBtn3.Caption:=MainForm.NeuOeffnenBtn2.Caption;
   MainForm.NeuOeffnenBtn2.Caption:=MainForm.NeuOeffnenBtn1.Caption;
   MainForm.NeuOeffnenBtn1.Caption:=MainForm.ListFile;
   For Ctr:=2 to 4 do begin
      Caption2:=MainForm.OpenRecentPopupMenu.Items[Ctr-1].Caption;
      If Caption2=MainForm.ListFile then begin
         For CtrII:=Ctr+1 to 4 do MainForm.OpenRecentPopupMenu.Items[CtrII-2].Caption:=MainForm.OpenRecentPopupMenu.Items[CtrII-1].Caption;
         MainForm.NeuOeffnenBtn4.Caption:=Caption1;
      end;
   end;
end;
end;

procedure NewList;  { Alle Bedienelemente werden auf Default-Werte gesetzt }
begin
If FileExists(ExtractFilePath(Application.ExeName)+'default.lst') then LoadList(ExtractFilePath(Application.ExeName)+'default.lst');
With MainForm do begin
   ListFile:='unknown';
   Caption:='Webalizer - unknown';
   {$IFDEF WIN32}
   TargetDir:='c:\';
   {$ELSE}
   TargetDir:=GetEnvironmentVariable('HOME');
   {$ENDIF}
   OutputDir.Text:=TargetDir;
   If FileExists(ExtractFilePath(Application.ExeName)+'GeoIP.dat') then GeoIPDB.Text:=ExtractFilePath(Application.ExeName)+'GeoIP.dat';
end;
end;

procedure LoadList(FileName: String);
var f :Textfile;
    Ctr, LogCount, Status, ProgramVersion: Integer;
    StatusT: String;
begin
UpdateOpenNewMenu;
With MainForm do begin
If FileName='' then begin
   OpenDialog.Filename:='';
   If ListFile<>'unknown' then
      If DirectoryExists(ExtractFileDir(ListFile)) then OpenDialog.InitialDir:=ExtractFileDir(ListFile)
      else OpenDialog.InitialDir:=HomeDir;
   OpenDialog.Filter:=loglist_dlg;
   If OpenDialog.Execute then FileName:=OpenDialog.Filename else Exit;
end;

If FileName<>ExtractFilePath(Application.ExeName)+'default.lst' then
   { Fr den Fall, da jemand ein Listfile einer alten GUI-Version ldt, in dem nicht alle Werte gespeichert sind }
   If FileExists(ExtractFilePath(Application.ExeName)+'default.lst') then LoadList(ExtractFilePath(Application.ExeName)+'default.lst');
AssignFile(f,Filename);
{$i-} Reset(f); {$i+}
If IOResult<>0 then begin
   MessageDlg(open_loglist_err,mtInformation,[mbOK],0);
   Exit;
end;
LogList.Clear;
AdditionalTags.Clear;
SearchEngines.Clear;
DownloadPath.Clear;
HTMLPre.Clear; HTMLHead.Clear; HTMLBody.Clear;
HTMLPost.Clear; HTMLTail.Clear; HTMLEnd.Clear;
HideHostMemo.Clear; HideURLMemo.Clear; HideReferrerMemo.Clear; HideAgentMemo.Clear; HideUserMemo.Clear;
GroupHostMemo.Clear; GroupURLMemo.Clear; GroupReferrerMemo.Clear; GroupAgentMemo.Clear; GroupUserMemo.Clear;
IgnoreHostMemo.Clear; IgnoreURLMemo.Clear; IgnoreReferrerMemo.Clear; IgnoreAgentMemo.Clear; IgnoreUserMemo.Clear;
IncludeHost.Clear; IncludeURLMemo.Clear; IncludeReferrer.Clear; IncludeUserAgent.Clear; IncludeUserMemo.Clear;
SpamReferrer.Clear; IgnoreReferrerRedirect.Clear;
IncludeSearchArg.Clear; ExcludeSearchArg.Clear; 
Config.Clear; Output.Clear;
Read(f,ProgramVersion); ReadLn(f);  { Die Programmversion unter dem die Log-Liste gespeichert wurde wird bestimmt }
Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
For Ctr:=0 to LogCount-1 do begin
   ReadLn(f,StatusT); LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
end;
ReadLn(f,TargetDir); OutputDir.Text:=TargetDir;            { Zielverzeichnis }
ReadLn(f,LastLogDir);            { Verzeichnis des zuletzt gewhlten Logfiles }
Read(f,Status); ReadLn(f);
If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false; { Soll das Ziel-Verzeichnis erst gelscht werden? }
If ProgramVersion>=151 then begin
   Read(f,Status); ReadLn(f);
   If Status=1 then EnableDomainFilterCheck.Checked:=true else EnableDomainFilterCheck.Checked:=false;  { Domain Filter Status }
   If ProgramVersion>=161 then begin
      Read(f,Status); ReadLn(f);
      ProviderComboBox.ItemIndex:=Status;
   end;
   Read(f,Status); ReadLn(f);
   If Status=1 then MixDomainsCheck.Checked:=true else MixDomainsCheck.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then RemoveDomainBox.Checked:=true else RemoveDomainBox.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then SaveFilteredLogCheck.Checked:=true else SaveFilteredLogCheck.Checked:=false;
   ReadLn(f,StatusT); DomainEdit.Text:=StatusT;
   ReadLn(f,StatusT); SaveCompressedLogIn.Text:=StatusT;
   If ProgramVersion>=200 then begin
      Read(f,Status); ReadLn(f);
      If Status=1 then CompressLogCheck.Checked:=true else CompressLogCheck.Checked:=false;
   end;
end;
Read(f,Status); ReadLn(f);
If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false; { Backup der Log-Liste erstellen }
Read(f,Status); ReadLn(f);
If Status=1 then DailyStat.Checked:=true else DailyStat.Checked:=false;   { Webalizer Optionen laden }
Read(f,Status); ReadLn(f);
If Status=1 then DailyGraph.Checked:=true else DailyGraph.Checked:=false;
Read(f,Status); ReadLn(f);
If Status=1 then HourlyStats.Checked:=true else HourlyStats.Checked:=false;
Read(f,Status); ReadLn(f);
If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
Read(f,Status); ReadLn(f);
If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
Read(f,Status); ReadLn(f);
If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
If ProgramVersion>=130 then begin
   Read(f,Status); ReadLn(f);
   If Status=1 then ShowStatsCheck.Checked:=true else ShowStatsCheck.Checked:=false;
end;
Read(f,Status); ReadLn(f); Timeout.Value:=Status;
ReadLn(f,StatusT); ReportTitle.Text:=StatusT;
ReadLn(f,StatusT); HostName.Text:=StatusT;
If ProgramVersion>=110 then begin
   If ProgramVersion>=232 then begin
      Read(f,Status); ReadLn(f);
      If Status=1 then HideOwnSiteAsReferrer.Checked:=true else HideOwnSiteAsReferrer.Checked:=false;
   end;
   Read(f,Status); ReadLn(f); GraphLines.Value:=Status;
   ReadLn(f,StatusT); LogTypeBox.Text:=StatusT;
   If ProgramVersion<=231 then begin ReadLn(f,StatusT); HideReferrerMemo.Lines.Add(StatusT); end;
   If ProgramVersion>=120 then begin
      If ProgramVersion>=250 then begin
         ReadLn(f,StatusT); ApacheLogFormat.Text:=StatusT;
      end;
      ReadLn(f,StatusT); HTMLExtension.Text:=StatusT;
      If ProgramVersion>=151 then begin
         Read(f,Status); ReadLn(f);
         If Status=1 then EnableRevDNSLookupsCheck.Checked:=true else EnableRevDNSLookupsCheck.Checked:=false;
         ReadLn(f,StatusT); DNSCachefile.Text:=StatusT;
         Read(f,Status); ReadLn(f); DNSChild.Value:=Status;
         If ProgramVersion>=210 then begin
            Read(f,Status); ReadLn(f); DNSTTL.Value:=Status;
            Read(f,Status); ReadLn(f); TopErrors.Value:=Status;
            Read(f,Status); ReadLn(f);
            If Status=1 then AllErrors.Checked:=true else AllErrors.Checked:=false;
            Read(f,Status); ReadLn(f);
            If Status=1 then BundleGroups.Checked:=true else BundleGroups.Checked:=false;
            Read(f,Status); ReadLn(f);
            If Status=1 then ConvertURLs.Checked:=true else ConvertURLs.Checked:=false;
            ReadLn(f,StatusT); CSSDir.Text:=StatusT;
            If ProgramVersion>=220 then begin
               ReadLn(f,StatusT); StatLanguage.Text:=FilenameToLangText(StatusT);
               ReadLn(f,StatusT); GeoIPDB.Text:=StatusT;
               ReadLn(f,StatusT); HTMLCharset.Text:=StatusT;
               If ProgramVersion>=230 then begin
                  Read(f,Status); ReadLn(f); TopDownloads.Value:=Status;
                  Read(f,Status); ReadLn(f); If Status=1 then AllDownloads.Checked:=true else AllDownloads.Checked:=false;
                  Read(f,Status); ReadLn(f); DownloadTimeout.Value:=Status;
                  Read(f,Status); ReadLn(f);
                  For Ctr:=1 to Status do begin
                     ReadLn(f,StatusT); DownloadPath.Lines.Add(StatusT);
                  end;
               end;
            end;
         end;
         Read(f,Status); ReadLn(f); MangleAgents.Value:=Status;
      end;
      For Ctr:=0 to 1 do begin
         Read(f,Status); ReadLn(f);
         If Status=1 then PageType.Checked[Ctr]:=true else PageType.Checked[Ctr]:=false;
      end;
      If ProgramVersion>=140 then begin
         Read(f,Status); ReadLn(f);
         If Status=1 then PageType.Checked[2]:=true else PageType.Checked[2]:=false;
      end;
      For Ctr:=3 to 5 do begin
         Read(f,Status); ReadLn(f);
         If Status=1 then PageType.Checked[Ctr]:=true else PageType.Checked[Ctr]:=false;
      end;
      If ProgramVersion>=220 then for Ctr:=6 to 15 do begin
         Read(f,Status); ReadLn(f);
         If Status=1 then PageType.Checked[Ctr]:=true else PageType.Checked[Ctr]:=false;
      end;
      Read(f,Status); ReadLn(f);
      If Status=1 then HTTPSCheck.Checked:=true else HTTPSCheck.Checked:=false;
      Read(f,Status); ReadLn(f);
      If Status=1 then IgnoreSequenceErrorsCheck.Checked:=true else IgnoreSequenceErrorsCheck.Checked:=false;
   end;
   Read(f,Status); ReadLn(f); TopSites.Value:=Status;
   Read(f,Status); ReadLn(f); TopKBytes.Value:=Status;
   Read(f,Status); ReadLn(f); TopURLs.Value:=Status;
   Read(f,Status); ReadLn(f); TopURLsKBytes.Value:=Status;
   Read(f,Status); ReadLn(f); TopReferrers.Value:=Status;
   Read(f,Status); ReadLn(f); TopAgents.Value:=Status;
   Read(f,Status); ReadLn(f); TopCountries.Value:=Status;
   Read(f,Status); ReadLn(f); TopEntryPages.Value:=Status;
   Read(f,Status); ReadLn(f); TopExitPages.Value:=Status;
   Read(f,Status); ReadLn(f); TopSearches.Value:=Status;
   Read(f,Status); ReadLn(f); TopUsers.Value:=Status;
   Read(f,Status); ReadLn(f);
   If Status=1 then AllSites.Checked:=true else AllSites.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then AllURLs.Checked:=true else AllURLs.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then AllReferrers.Checked:=true else AllReferrers.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then AllAgents.Checked:=true else AllAgents.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
   Read(f,Status); ReadLn(f);
   If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
   If ProgramVersion=110 then begin
      ReadLn(f,StatusT); HTMLPre.Text:=StatusT;
      ReadLn(f,StatusT); HTMLHead.Text:=StatusT;
      ReadLn(f,StatusT); HTMLBody.Text:=StatusT;
      ReadLn(f,StatusT); HTMLPost.Text:=StatusT;
      ReadLn(f,StatusT); HTMLTail.Text:=StatusT;
      ReadLn(f,StatusT); HTMLEnd.Text:=StatusT;
   end else if ProgramVersion>=120 then begin
      If ProgramVersion>=131 then begin
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
            ReadLn(f,StatusT); AdditionalTags.Lines.Add(StatusT);
         end;
      end;
      If ProgramVersion>=152 then begin
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
            ReadLn(f,StatusT); SearchEngines.Lines.Add(StatusT);
         end;
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HTMLPre.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HTMLHead.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HTMLBody.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HTMLPost.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HTMLTail.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HTMLEnd.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HideHostMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HideURLMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HideReferrerMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HideAgentMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); HideUserMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); GroupHostMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); GroupURLMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); GroupReferrerMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); GroupAgentMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); GroupUserMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IgnoreHostMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IgnoreURLMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IgnoreReferrerMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IgnoreAgentMemo.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IgnoreUserMemo.Lines.Add(StatusT);
      end;
      If ProgramVersion>=232 then begin
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IncludeHost.Lines.Add(StatusT);
      end;
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IncludeURLMemo.Lines.Add(StatusT);
      end;
      If ProgramVersion>=232 then begin
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IncludeReferrer.Lines.Add(StatusT);
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IncludeUserAgent.Lines.Add(StatusT);
      end;
      end;
      Read(f,Status); ReadLn(f);
      For Ctr:=1 to Status do begin
         ReadLn(f,StatusT); IncludeUserMemo.Lines.Add(StatusT);
      end;
      If ProgramVersion>=231 then begin
         If ProgramVersion>=250 then begin
            Read(f,Status); ReadLn(f);
            For Ctr:=1 to Status do begin
               ReadLn(f,StatusT); SpamReferrer.Lines.Add(StatusT);
            end;
            Read(f,Status); ReadLn(f);
            For Ctr:=1 to Status do begin
               ReadLn(f,StatusT); IgnoreReferrerRedirect.Lines.Add(StatusT);
            end;
            Read(f,Status); ReadLn(f);
            For Ctr:=1 to Status do begin
               ReadLn(f,StatusT); IncludeSearchArg.Lines.Add(StatusT);
            end;
            Read(f,Status); ReadLn(f);
            For Ctr:=1 to Status do begin
               ReadLn(f,StatusT); ExcludeSearchArg.Lines.Add(StatusT);
            end;
            If ProgramVersion>=251 then begin
               Read(f,Status); ReadLn(f);
               If Status=1 then RemoveBeginningHostname.Checked:=true else RemoveBeginningHostname.Checked:=false;
            end;
            Read(f,Status); ReadLn(f);
            If Status=1 then IgnoreReferrerPartial.Checked:=true else IgnoreReferrerPartial.Checked:=false;
         end;
         Read(f,Status); ReadLn(f);
         If Status=1 then ShadeGroups.Checked:=true else ShadeGroups.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HighlightGroups.Checked:=true else HighlightGroups.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HideAllHosts.Checked:=true else HideAllHosts.Checked:=false;
         Read(f,Status); ReadLn(f);
         GroupDomains.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then DebugOutput.Checked:=true else DebugOutput.Checked:=false;
         If ProgramVersion>=250 then begin
            ReadLn(f,StatusT); GraphFontNormal.Text:=StatusT;
            ReadLn(f,StatusT); GraphFontBold.Text:=StatusT;
            Read(f,Status); ReadLn(f); GraphFontSmall.Value:=Status;
            Read(f,Status); ReadLn(f); GraphFontMedium.Value:=Status;
            Read(f,Status); ReadLn(f);
            If Status=1 then GraphFontSmoothing.Checked:=true else GraphFontSmoothing.Checked:=false;
            Read(f,Status); ReadLn(f); GraphBorderWidth.Value:=Status;
            Read(f,Status); ReadLn(f);
            If Status=1 then GraphLegend.Checked:=true else GraphLegend.Checked:=false;
            Read(f,Status); ReadLn(f); GraphBackgroundColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphGridlineColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphHitsColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphHostsColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphFilesColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphLegendColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphOutlineColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphPagesColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphTitleColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphVisitsColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphVolumeColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphWeekendColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphShadowColor.Font.Color:=Status;
            Read(f,Status); ReadLn(f); GraphBackgroundAlpha.Position:=Status;
            Read(f,Status); ReadLn(f);
            If Status=1 then GraphTrueColor.Checked:=true else GraphTrueColor.Checked:=false;    
         end;
      end;
   end;
end;
CloseFile(f);
SetRevDNSStatus(EnableRevDNSLookupsCheck.Checked);
SetDomainFilter(EnableDomainFilterCheck.Checked);
OnBtnClick(LogTypeBox);
SetChanged(false);
ListFile:=FileName;
LogList.ItemIndex:=LogList.Items.Count-1;
Caption:='Webalizer - '+ExtractFileName(ListFile);
SearchStatistics;
end;
end;

procedure SaveList;
var f :Textfile;
    Ctr: Integer;
begin
With MainForm do begin
If (ListFile='unknown') or (ListFile='') then begin
   SaveDialog.Filter:=loglist_dlg;
   SaveDialog.DefaultExt:='*.lst';
   If SaveDialog.Execute then ListFile:=SaveDialog.Filename else Exit;
end;
If FileExists(ListFile) then begin  { Von einer bestehenden Log-Liste wird ein Backup erstellt }
   If FileExists(ChangeFileExt(ListFile,'.bak')) then DeleteFile(PChar(ChangeFileExt(ListFile,'.bak')));
   RenameFile(ListFile,ChangeFileExt(ListFile,'.bak'));
end;
AssignFile(f,ListFile);
{$i-} Rewrite(f); {$i+}
If IOResult<>0 then begin
   RenameFile(ListFile,ChangeFileExt(ListFile,'.lst')); { Tritt beim Speichern ein Fehler auf wird die Backup-Datei wieder umbenannt }
   MessageDlg(save_loglist_err,mtInformation,[mbOK],0);
end else begin
   Write(f,251); WriteLn(f);                     { Programm-Version speichern }
   Write(f,LogList.Items.Count); WriteLn(f);     { Anzahl an Log-Files speichern }
   For Ctr:=0 to LogList.Items.Count-1 do WriteLn(f,LogList.Items[Ctr]);  { Log-Files speichern }
   WriteLn(f,TargetDir);                         { Zielverzeichnis speichern}
   WriteLn(f,LastLogDir);                        { Verzeichnis des zuletzt gewhlten Logfiles speichern }
   If DeleteExisting.Checked then Write(f,1) else Write(f,0); WriteLn(f);  { Bestehende Statistik lschen-Status speichern }
   If EnableDomainFilterCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,ProviderComboBox.ItemIndex); WriteLn(f);
   If MixDomainsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If RemoveDomainBox.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If SaveFilteredLogCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   WriteLn(f,DomainEdit.Text);
   WriteLn(f,SaveCompressedLogIn.Text);
   If CompressLogCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If BackupCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);     { Backup-Status speichern }
   If DailyStat.Checked then Write(f,1) else Write(f,0); WriteLn(f);  { Webalizer Optionen speichern }
   If DailyGraph.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If HourlyStats.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If HourlyGraphCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If CountryCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If IncrementalCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If ShowStatsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,Timeout.Value); WriteLn(f);
   WriteLn(f,ReportTitle.Text);
   WriteLn(f,HostName.Text);
   If HideOwnSiteAsReferrer.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,GraphLines.Value); WriteLn(f);
   WriteLn(f,LogTypeBox.Text);
   WriteLn(f,ApacheLogFormat.Text);
   WriteLn(f,HTMLExtension.Text);
   If EnableRevDNSLookupsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   WriteLn(f,DNSCachefile.Text);
   Write(f,DNSChild.Value); WriteLn(f);
   Write(f,DNSTTL.Value); WriteLn(f);
   Write(f,TopErrors.Value); WriteLn(f);
   If AllErrors.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If BundleGroups.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If ConvertURLs.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   WriteLn(f,CSSDir.Text);
   WriteLn(f,LangTextToFilename(StatLanguage.Text));
   WriteLn(f,GeoIPDB.Text);
   WriteLn(f,HTMLCharset.Text);
   Write(f,TopDownloads.Value); WriteLn(f);
   If AllDownloads.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,DownloadTimeout.Value); WriteLn(f);
   Write(f,DownloadPath.Lines.Count); WriteLn(f);
   For Ctr:=0 to DownloadPath.Lines.Count-1 do WriteLn(f,DownloadPath.Lines[Ctr]);
   Write(f,MangleAgents.Value); WriteLn(f);
   For Ctr:=0 to 15 do begin
      If PageType.Checked[Ctr] then Write(f,1) else Write(f,0);
      WriteLn(f);
   end;
   If HTTPSCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If IgnoreSequenceErrorsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,TopSites.Value); WriteLn(f);
   Write(f,TopKBytes.Value); WriteLn(f);
   Write(f,TopURLs.Value); WriteLn(f);
   Write(f,TopURLsKBytes.Value); WriteLn(f);
   Write(f,TopReferrers.Value); WriteLn(f);
   Write(f,TopAgents.Value); WriteLn(f);
   Write(f,TopCountries.Value); WriteLn(f);
   Write(f,TopEntryPages.Value); WriteLn(f);
   Write(f,TopExitPages.Value); WriteLn(f);
   Write(f,TopSearches.Value); WriteLn(f);
   Write(f,TopUsers.Value); WriteLn(f);
   If AllSites.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If AllURLs.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If AllReferrers.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If AllAgents.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If AllSearchesCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If AllUsersCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,AdditionalTags.Lines.Count); WriteLn(f);
   For Ctr:=0 to AdditionalTags.Lines.Count-1 do WriteLn(f,AdditionalTags.Lines[Ctr]);
   Write(f,SearchEngines.Lines.Count); WriteLn(f);
   For Ctr:=0 to SearchEngines.Lines.Count-1 do WriteLn(f,SearchEngines.Lines[Ctr]);
   Write(f,HTMLPre.Lines.Count); WriteLn(f);
   For Ctr:=0 to HTMLPre.Lines.Count-1 do WriteLn(f,HTMLPre.Lines[Ctr]);
   Write(f,HTMLHead.Lines.Count); WriteLn(f);
   For Ctr:=0 to HTMLHead.Lines.Count-1 do WriteLn(f,HTMLHead.Lines[Ctr]);
   Write(f,HTMLBody.Lines.Count); WriteLn(f);
   For Ctr:=0 to HTMLBody.Lines.Count-1 do WriteLn(f,HTMLBody.Lines[Ctr]);
   Write(f,HTMLPost.Lines.Count); WriteLn(f);
   For Ctr:=0 to HTMLPost.Lines.Count-1 do WriteLn(f,HTMLPost.Lines[Ctr]);
   Write(f,HTMLTail.Lines.Count); WriteLn(f);
   For Ctr:=0 to HTMLTail.Lines.Count-1 do WriteLn(f,HTMLTail.Lines[Ctr]);
   Write(f,HTMLEnd.Lines.Count); WriteLn(f);
   For Ctr:=0 to HTMLEnd.Lines.Count-1 do WriteLn(f,HTMLEnd.Lines[Ctr]);
   Write(f,HideHostMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to HideHostMemo.Lines.Count-1 do WriteLn(f,HideHostMemo.Lines[Ctr]);
   Write(f,HideURLMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to HideURLMemo.Lines.Count-1 do WriteLn(f,HideURLMemo.Lines[Ctr]);
   Write(f,HideReferrerMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to HideReferrerMemo.Lines.Count-1 do WriteLn(f,HideReferrerMemo.Lines[Ctr]);
   Write(f,HideAgentMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to HideAgentMemo.Lines.Count-1 do WriteLn(f,HideAgentMemo.Lines[Ctr]);
   Write(f,HideUserMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to HideUserMemo.Lines.Count-1 do WriteLn(f,HideUserMemo.Lines[Ctr]);
   Write(f,GroupHostMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to GroupHostMemo.Lines.Count-1 do WriteLn(f,GroupHostMemo.Lines[Ctr]);
   Write(f,GroupURLMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to GroupURLMemo.Lines.Count-1 do WriteLn(f,GroupURLMemo.Lines[Ctr]);
   Write(f,GroupReferrerMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to GroupReferrerMemo.Lines.Count-1 do WriteLn(f,GroupReferrerMemo.Lines[Ctr]);
   Write(f,GroupAgentMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to GroupAgentMemo.Lines.Count-1 do WriteLn(f,GroupAgentMemo.Lines[Ctr]);
   Write(f,GroupUserMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to GroupUserMemo.Lines.Count-1 do WriteLn(f,GroupUserMemo.Lines[Ctr]);
   Write(f,IgnoreHostMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IgnoreHostMemo.Lines.Count-1 do WriteLn(f,IgnoreHostMemo.Lines[Ctr]);
   Write(f,IgnoreURLMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IgnoreURLMemo.Lines.Count-1 do WriteLn(f,IgnoreURLMemo.Lines[Ctr]);
   Write(f,IgnoreReferrerMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IgnoreReferrerMemo.Lines.Count-1 do WriteLn(f,IgnoreReferrerMemo.Lines[Ctr]);
   Write(f,IgnoreAgentMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IgnoreAgentMemo.Lines.Count-1 do WriteLn(f,IgnoreAgentMemo.Lines[Ctr]);
   Write(f,IgnoreUserMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IgnoreUserMemo.Lines.Count-1 do WriteLn(f,IgnoreUserMemo.Lines[Ctr]);
   Write(f,IncludeHost.Lines.Count); WriteLn(f);
   For Ctr:=0 to IncludeHost.Lines.Count-1 do WriteLn(f,IncludeHost.Lines[Ctr]);
   Write(f,IncludeURLMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IncludeURLMemo.Lines.Count-1 do WriteLn(f,IncludeURLMemo.Lines[Ctr]);
   Write(f,IncludeReferrer.Lines.Count); WriteLn(f);
   For Ctr:=0 to IncludeReferrer.Lines.Count-1 do WriteLn(f,IncludeReferrer.Lines[Ctr]);
   Write(f,IncludeUserAgent.Lines.Count); WriteLn(f);
   For Ctr:=0 to IncludeUserAgent.Lines.Count-1 do WriteLn(f,IncludeUserAgent.Lines[Ctr]);
   Write(f,IncludeUserMemo.Lines.Count); WriteLn(f);
   For Ctr:=0 to IncludeUserMemo.Lines.Count-1 do WriteLn(f,IncludeUserMemo.Lines[Ctr]);
   Write(f,SpamReferrer.Lines.Count); WriteLn(f);
   For Ctr:=0 to SpamReferrer.Lines.Count-1 do WriteLn(f,SpamReferrer.Lines[Ctr]);
   Write(f,IgnoreReferrerRedirect.Lines.Count); WriteLn(f);
   For Ctr:=0 to IgnoreReferrerRedirect.Lines.Count-1 do WriteLn(f,IgnoreReferrerRedirect.Lines[Ctr]);
   Write(f,IncludeSearchArg.Lines.Count); WriteLn(f);
   For Ctr:=0 to IncludeSearchArg.Lines.Count-1 do WriteLn(f,IncludeSearchArg.Lines[Ctr]);
   Write(f,ExcludeSearchArg.Lines.Count); WriteLn(f);
   For Ctr:=0 to ExcludeSearchArg.Lines.Count-1 do WriteLn(f,ExcludeSearchArg.Lines[Ctr]);
   If RemoveBeginningHostname.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If IgnoreReferrerPartial.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If ShadeGroups.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If HighlightGroups.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   If HideAllHosts.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,GroupDomains.Value); WriteLn(f);
   If DebugOutput.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   WriteLn(f,GraphFontNormal.Text);
   WriteLn(f,GraphFontBold.Text);
   Write(f,GraphFontSmall.Value); WriteLn(f);
   Write(f,GraphFontMedium.Value); WriteLn(f);
   If GraphFontSmoothing.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,GraphBorderWidth.Value); WriteLn(f);
   If GraphLegend.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   Write(f,GraphBackgroundColor.Font.Color); WriteLn(f);
   Write(f,GraphGridlineColor.Font.Color); WriteLn(f);
   Write(f,GraphHitsColor.Font.Color); WriteLn(f);
   Write(f,GraphHostsColor.Font.Color); WriteLn(f);
   Write(f,GraphFilesColor.Font.Color); WriteLn(f);
   Write(f,GraphLegendColor.Font.Color); WriteLn(f);
   Write(f,GraphOutlineColor.Font.Color); WriteLn(f);
   Write(f,GraphPagesColor.Font.Color); WriteLn(f);
   Write(f,GraphTitleColor.Font.Color); WriteLn(f);
   Write(f,GraphVisitsColor.Font.Color); WriteLn(f);
   Write(f,GraphVolumeColor.Font.Color); WriteLn(f);
   Write(f,GraphWeekendColor.Font.Color); WriteLn(f);
   Write(f,GraphShadowColor.Font.Color); WriteLn(f);
   Write(f,GraphBackgroundAlpha.Position); WriteLn(f);
   If GraphTrueColor.Checked then Write(f,1) else Write(f,0); WriteLn(f);
   SetChanged(false);
   { Wenn kein Backup der Log-Liste erstellt werden soll, kann die Backup-Datei gelscht werden }
   If (BackupCheck.Checked=false) and (FileExists(ChangeFileExt(ListFile,'.bak'))) then DeleteFile(PChar(ChangeFileExt(ListFile,'.bak')));
end;
CloseFile(f);
Caption:='Webalizer - '+ExtractFileName(ListFile);
end;
end;

procedure ImportConfigurationFile;
var LineCtr, CaseCtr: Integer;
    Value: String;
    Command: ShortString;
begin
With MainForm do begin
If DirectoryExists(ExtractFileDir(ListFile)) then OpenDialog.InitialDir:=ExtractFileDir(ListFile)
   else OpenDialog.InitialDir:=HomeDir;
OpenDialog.Filter:=all_files_dlg;
If OpenDialog.Execute then if FileExists(OpenDialog.Filename) then begin
   { Alle Werte werden auf die Default-Werte zurckgesetzt }
   NewList;
   HTMLPre.Clear; HTMLHead.Clear; HTMLBody.Clear; HTMLPost.Clear; HTMLTail.Clear; HTMLEnd.Clear;
   SearchEngines.Clear;
   Config.Lines.LoadFromFile(OpenDialog.Filename);
   For LineCtr:=0 to Config.Lines.Count-1 do begin
      { Leer- und Steuerzeichen werden entfernt }
      Config.Lines[LineCtr]:=Trim(Config.Lines[LineCtr]);
      { Lehre Zeilen und Kommentare in der Konfigurationsdatei werden ignoriert }
      If (Config.Lines[LineCtr]<>'') and (Config.Lines[LineCtr][1]<>'#') then begin
         CaseCtr:=1; Command:=''; Value:='';
         { Es wird nach dem ersten Wort in einer Zeile gesucht und dieses als Konfigurationsoption interpretiert}
         Repeat
            Command:=Command+Config.Lines[LineCtr][CaseCtr];
            Inc(CaseCtr);
         until (CaseCtr>Length(Config.Lines[LineCtr])) or (Config.Lines[LineCtr][CaseCtr]=' ') or (Config.Lines[LineCtr][CaseCtr]=#9);
         Command:=LowerCase(Command);
         If CaseCtr<=Length(Config.Lines[LineCtr]) then begin
            Inc(CaseCtr);
            { Der Rest jeder Zeile wird als Wert der Konfiguationsoption interpretiert }
            Repeat
               Value:=Value+Config.Lines[LineCtr][CaseCtr];
               Inc(CaseCtr);
            until CaseCtr>Length(Config.Lines[LineCtr]);
         end;
         Value:=Trim(Value);
         If Value<>'' then begin
            { Die Optionen werden interpretiert }
            If          Command='logfile' then LogList.Items.Add(Value)
            else if     Command='logtype' then LogTypeBox.Text:=Value
            else if     Command='apachelogformat' then ApacheLogFormat.Text:=Value                 
            else if     Command='outputdir' then OutputDir.Text:=Value
            else if     Command='incremental' then begin
               If Value='no' then IncrementalCheck.Checked:=false else if Value='yes' then IncrementalCheck.Checked:=true;
            end else if Command='reporttitle' then ReportTitle.Text:=Value
            else if     Command='hostname' then HostName.Text:=Value
            else if     Command='htmlextension' then HTMLExtension.Text:=Value
            else if     Command='dnscache' then DNSCachefile.Text:=Value
            else if     Command='dnschildren' then DNSChild.Value:=StrToInt(Value)
            else if     Command='mangleagents' then MangleAgents.Value:=StrToInt(Value)
            else if     Command='pagetype' then begin
               If Value='htm' then PageType.Checked[0]:=true
               else if Value='html' then PageType.Checked[0]:=true
               else if Value='cgi' then PageType.Checked[1]:=true
               else if Value='asp' then PageType.Checked[2]:=true
               else if Value='phtml' then PageType.Checked[3]:=true
               else if Value='php' then PageType.Checked[4]:=true
               else if Value='php3' then PageType.Checked[4]:=true
               else if Value='php4' then PageType.Checked[4]:=true
               else if Value='pl' then PageType.Checked[5]:=true
               else if Value='jsp' then PageType.Checked[6]:=true
               else if Value='pdf' then PageType.Checked[7]:=true
               else if Value='py' then PageType.Checked[8]:=true
               else if Value='shtml' then PageType.Checked[9]:=true
               else if Value='txt' then PageType.Checked[10]:=true
               else if Value='cfm' then PageType.Checked[11]:=true
               else if Value='doc' then PageType.Checked[12]:=true
               else if Value='zip' then PageType.Checked[1]:=true
               else if Value='acs' then PageType.Checked[14]:=true
               else if Value='text' then PageType.Checked[15]:=true;
            end else if Command='usehttps' then begin
               If Value='yes' then HTTPSCheck.Checked:=true else if Value='no' then HTTPSCheck.Checked:=false;
            end else if Command='htmlhead' then HTMLHead.Lines.Add(Value)
            else if     Command='htmlpre' then HTMLPre.Lines.Add(Value)
            else if     Command='htmlbody' then HTMLBody.Lines.Add(Value)
            else if     Command='htmlpost' then HTMLPost.Lines.Add(Value)
            else if     Command='htmltail' then HTMLTail.Lines.Add(Value)
            else if     Command='htmlend' then HTMLEnd.Lines.Add(Value)
            else if     Command='foldseqerr' then begin
               If Value='yes' then IgnoreSequenceErrorsCheck.Checked:=true else if Value='no' then IgnoreSequenceErrorsCheck.Checked:=false;
            end else if Command='visittimeout' then Timeout.Value:=Round(StrToInt(Value)/60)
            else if Command='countrygraph' then begin
               If Value='yes' then CountryCheck.Checked:=true else if Value='no' then CountryCheck.Checked:=false;
            end else if Command='dailygraph' then begin
               If Value='yes' then DailyGraph.Checked:=true else if Value='no' then DailyGraph.Checked:=false;
            end else if Command='dailystats' then begin
               If Value='yes' then DailyStat.Checked:=true else if Value='no' then DailyStat.Checked:=false;
            end else if Command='hourlygraph' then begin
               If Value='yes' then HourlyGraphCheck.Checked:=true else if Value='no' then HourlyGraphCheck.Checked:=false;
            end else if Command='hourlystats' then begin
               If Value='yes' then HourlyStats.Checked:=true else if Value='no' then HourlyStats.Checked:=false;
            end else if Command='graphlines' then GraphLines.Value:=StrToInt(Value)
            else if Command='topsites' then TopSites.Value:=StrToInt(Value)
            else if Command='topksites' then TopKBytes.Value:=StrToInt(Value)
            else if Command='topurls' then TopURLs.Value:=StrToInt(Value)
            else if Command='topkurls' then TopURLsKBytes.Value:=StrToInt(Value)
            else if Command='topreferrers' then TopReferrers.Value:=StrToInt(Value)
            else if Command='topagents' then TopAgents.Value:=StrToInt(Value)
            else if Command='topcountries' then TopCountries.Value:=StrToInt(Value)
            else if Command='topentry' then TopEntryPages.Value:=StrToInt(Value)
            else if Command='topexit' then TopExitPages.Value:=StrToInt(Value)
            else if Command='topsearch' then TopSearches.Value:=StrToInt(Value)
            else if Command='topusers' then TopUsers.Value:=StrToInt(Value)
            else if Command='allsites' then begin
               If Value='yes' then AllSites.Checked:=true else if Value='no' then AllSites.Checked:=false;
            end else if Command='allurls' then begin
              If Value='yes' then AllURLs.Checked:=true else if Value='no' then AllURLs.Checked:=false;
            end else if Command='allreferrers' then begin
               If Value='yes' then AllReferrers.Checked:=true else if Value='no' then AllReferrers.Checked:=false;
            end else if Command='allagents' then begin
               If Value='yes' then AllAgents.Checked:=true else if Value='no' then AllAgents.Checked:=false;
            end else if Command='allsearchstr' then begin
               If Value='yes' then AllSearchesCheck.Checked:=true else if Value='no' then AllSearchesCheck.Checked:=false;
            end else if Command='allusers' then begin
              If Value='yes' then AllUsersCheck.Checked:=true else if Value='no' then AllUsersCheck.Checked:=false;
            end else if Command='hidesite' then HideHostMemo.Lines.Add(Value)
            else if Command='hidehost' then HideHostMemo.Lines.Add(Value)
            else if Command='hideurl' then HideURLMemo.Lines.Add(Value)
            else if Command='hidereferrer' then HideReferrerMemo.Lines.Add(Value)
            else if Command='hideagent' then HideAgentMemo.Lines.Add(Value)
            else if Command='hideuser' then HideUserMemo.Lines.Add(Value)
            else if Command='groupsite' then GroupHostMemo.Lines.Add(Value)
            else if Command='grouphost' then GroupHostMemo.Lines.Add(Value)
            else if Command='groupurl' then GroupURLMemo.Lines.Add(Value)
            else if Command='groupreferrer' then GroupReferrerMemo.Lines.Add(Value)
            else if Command='groupagent' then GroupAgentMemo.Lines.Add(Value)
            else if Command='groupuser' then GroupUserMemo.Lines.Add(Value)
            else if Command='ignoresite' then IgnoreHostMemo.Lines.Add(Value)
            else if Command='ignorehost' then IgnoreHostMemo.Lines.Add(Value)
            else if Command='ignoreurl' then IgnoreURLMemo.Lines.Add(Value)
            else if Command='ignorereferrer' then IgnoreReferrerMemo.Lines.Add(Value)
            else if Command='ignoreagent' then IgnoreAgentMemo.Lines.Add(Value)
            else if Command='ignoreuser' then IgnoreUserMemo.Lines.Add(Value)
            else if Command='includesite' then IncludeHost.Lines.Add(Value)
            else if Command='includehost' then IncludeHost.Lines.Add(Value)
            else if Command='includeurl' then IncludeURLMemo.Lines.Add(Value)
            else if Command='includereferrer' then IncludeReferrer.Lines.Add(Value)
            else if Command='includeagent' then IncludeUserAgent.Lines.Add(Value)
            else if Command='includeuser' then IncludeUserMemo.Lines.Add(Value)
            else if Command='spamreferrer' then SpamReferrer.Lines.Add(Value)
            else if Command='ignorereferrerredirect' then IgnoreReferrerRedirect.Lines.Add(Value)
            else if Command='includesearcharg' then IncludeSearchArg.Lines.Add(Value)
            else if Command='excludesearcharg' then ExcludeSearchArg.Lines.Add(Value)
            else if Command='ignorereferrerpartial' then begin
               If Value='yes' then IgnoreReferrerPartial.Checked:=true else if Value='no' then IgnoreReferrerPartial.Checked:=false;
            end else if Command='groupshading' then begin
               If Value='yes' then ShadeGroups.Checked:=true else if Value='no' then ShadeGroups.Checked:=false;
            end else if Command='grouphighlight' then begin
               If Value='yes' then HighlightGroups.Checked:=true else if Value='no' then HighlightGroups.Checked:=false;
            end else if Command='hideallsites' then begin
               If Value='yes' then HideAllHosts.Checked:=true else if Value='no' then HideAllHosts.Checked:=false;
            end else if Command='groupdomains' then GroupDomains.Value:=StrToInt(Value)
            else if Command='searchengine' then SearchEngines.Lines.Add(Value)
            else if Command='dnscachettl' then DNSTTL.Value:=StrToInt(Value)
            else if Command='allerrors' then begin
               If Value='yes' then AllErrors.Checked:=true else if Value='no' then AllErrors.Checked:=false;
            end else if Command='toperrors' then TopErrors.Value:=StrToInt(Value)
            else if Command='bundlegroups' then begin
              If Value='yes' then BundleGroups.Checked:=true else if Value='no' then BundleGroups.Checked:=false;
            end else if Command='convurlslowercase' then begin
              If Value='yes' then ConvertURLs.Checked:=true else if Value='no' then ConvertURLs.Checked:=false;
            end else if Command='htmlcsspath' then CssDir.Text:=Value
            else if Command='geoipdbpath' then GeoIPDB.Text:=Value
            else if Command='htmlcharset' then HTMLCharset.Text:=Value
            else if Command='topdownloads' then TopDownloads.Value:=StrToInt(Value)
            else if Command='alldownloads' then begin
               If Value='yes' then AllDownloads.Checked:=true else if Value='no' then AllDownloads.Checked:=false;
            end else if Command='downloadtimeout' then DownloadTimeout.Value:=StrToInt(Value)
            else if Command='downloadpath' then DownloadPath.Lines.Add(Value)
            else if Command='debug' then begin
               If Value='yes' then DebugOutput.Checked:=true else if Value='no' then DebugOutput.Checked:=false;

            end else if Command='graphfontnormal' then GraphFontNormal.Text:=Value
            else if Command='graphfontbold' then GraphFontBold.Text:=Value
            else if Command='graphfontsmall' then GraphFontSmall.Value:=StrToInt(Value)
            else if Command='graphfontmedium' then GraphFontMedium.Value:=StrToInt(Value)
            else if Command='graphfontsmoothing' then begin
               If Value='yes' then GraphFontSmoothing.Checked:=true else if Value='no' then GraphFontSmoothing.Checked:=false;
            end else if Command='graphborderwidth' then GraphBorderWidth.Value:=StrToInt(Value)
            else if Command='graphlegend' then begin
               If Value='yes' then GraphLegend.Checked:=true else if Value='no' then GraphLegend.Checked:=false;
            end else if Command='graphbackgroundcolor' then GraphBackgroundColor.Font.Color:=HexToColor(Value)
            else if Command='graphgridlinecolor' then GraphGridlineColor.Font.Color:=HexToColor(Value)
            else if Command='graphhitscolor' then GraphHitsColor.Font.Color:=HexToColor(Value)
            else if Command='graphhostscolor' then GraphHostsColor.Font.Color:=HexToColor(Value)
            else if Command='graphfilescolor' then GraphFilesColor.Font.Color:=HexToColor(Value)
            else if Command='graphlegendcolor' then GraphLegendColor.Font.Color:=HexToColor(Value)
            else if Command='graphoutlinecolor' then GraphOutlineColor.Font.Color:=HexToColor(Value)
            else if Command='graphpagescolor' then GraphPagesColor.Font.Color:=HexToColor(Value)
            else if Command='graphtitlecolor' then GraphTitleColor.Font.Color:=HexToColor(Value)
            else if Command='graphvisitscolor' then GraphVisitsColor.Font.Color:=HexToColor(Value)
            else if Command='graphvolumecolor' then GraphVolumeColor.Font.Color:=HexToColor(Value)
            else if Command='graphweekendcolor' then GraphWeekendColor.Font.Color:=HexToColor(Value)
            else if Command='graphshadowcolor' then GraphShadowColor.Font.Color:=HexToColor(Value)
            else if Command='grapgbackgroundalpha' then GraphBackgroundAlpha.Position:=StrToInt(Value)
            else if Command='graphtruecolor' then begin
               If Value='yes' then GraphTrueColor.Checked:=true else if Value='no' then GraphTrueColor.Checked:=false;  
            end else AdditionalTags.Lines.Add(Command+' '+Value);
         end;
      end;
   end;
   SearchStatistics;
   SetChanged(true);
end;
end;
end;

function HexToColor(Hex: String): TColor;
begin
Result:=StrToInt('$02'+Hex[5]+Hex[6]+Hex[3]+Hex[4]+Hex[1]+Hex[2]);
end;

end.
 
