{ Copyright (C) by Tobias Schwarz, 2003-2007
  Distributed under the GNU General Public License }

unit Browser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, SHDocVw, Registry, StdCtrls, Buttons, ExtCtrls;

type
  TBrowserForm = class(TForm)
    WebBrowser: TWebBrowser;
    Panel1: TPanel;
    MonthlyStatisticsBtn: TBitBtn;
    DailyStatisticsBtn: TBitBtn;
    HourlyStatisticsBtn: TBitBtn;
    URLsBtn: TBitBtn;
    HostsBtn: TBitBtn;
    ReferrerBtn: TBitBtn;
    EntryPagesBtn: TBitBtn;
    ExitPagesBtn: TBitBtn;
    SearchesBtn: TBitBtn;
    UserNamesBtn: TBitBtn;
    UserAgentsBtn: TBitBtn;
    StatisticsComboBox: TComboBox;
    LastYearStatisticsBtn: TBitBtn;
    HistBack: TBitBtn;
    HistForward: TBitBtn;
    ErrorsBtn: TBitBtn;
    CountriesBtn: TBitBtn;
    ReloadBtn: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure LastYearStatisticsBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure StatisticsComboBoxChange(Sender: TObject);
    procedure BrowserEvent(Sender: TObject);
  private
    { Private-Deklarationen }
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure WMSyscommand(var Message: TWmSysCommand); message WM_SYSCOMMAND;
  public
    { Public-Deklarationen }
  end;

var
  BrowserForm: TBrowserForm;

implementation

uses Main, VistaFuncs;

{$R *.DFM}

procedure TBrowserForm.FormCreate(Sender: TObject);
var Registry: TRegistry;
begin
HistBack.Glyph.LoadFromResourceName(HInstance,'hist_back');
HistForward.Glyph.LoadFromResourceName(HInstance,'hist_forward');
ReloadBtn.Glyph.LoadFromResourceName(HInstance,'reload');
SetOSFont(Self);
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin  { Die Position des Programm-Fensters wird aus der Registry geladen }
   Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true);
   If Registry.ValueExists('BrowserLeft') then Left:=Registry.ReadInteger('BrowserLeft');
   If Registry.ValueExists('BrowserTop') then Top:=Registry.ReadInteger('BrowserTop');
   If Registry.ValueExists('BrowserWidth') then Width:=Registry.ReadInteger('BrowserWidth');
   If Registry.ValueExists('BrowserHeight') then Height:=Registry.ReadInteger('BrowserHeight');
   Registry.CloseKey;
end;
Registry.Free;
end;

{$IFDEF WIN32}

procedure TBrowserForm.CreateParams(var Params: TCreateParams);
begin
inherited CreateParams(Params);
Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TBrowserForm.WMSyscommand(var Message: TWmSysCommand);
begin
case (Message.CmdType and $FFF0) of
   SC_MINIMIZE:
   begin
      ShowWindow(Handle, SW_MINIMIZE);
      Message.Result := 0;
   end;
   SC_RESTORE:
   begin
      ShowWindow(Handle, SW_RESTORE);
      Message.Result := 0;
   end;
else
   inherited;
end;
end;

{$ENDIF}

procedure TBrowserForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true);   { Fensterposition in der Registry speichern }
Registry.WriteInteger('BrowserLeft',Left);
Registry.WriteInteger('BrowserTop',Top);
Registry.WriteInteger('BrowserWidth',Width);
Registry.WriteInteger('BrowserHeight',Height);
Registry.CloseKey;
end;

procedure TBrowserForm.LastYearStatisticsBtnClick(Sender: TObject);
begin
MainForm.StatisticsList.ItemIndex:=StatisticsComboBox.ItemIndex;
MainForm.OnBtnClick(Sender);
end;

procedure TBrowserForm.StatisticsComboBoxChange(Sender: TObject);
begin
MainForm.StatisticsList.ItemIndex:=StatisticsComboBox.ItemIndex;
MainForm.MonthlyStatisticsBtn.Click;
end;

procedure TBrowserForm.FormShow(Sender: TObject);
begin
If MainForm.WebalizerVersion<2020000 then ErrorsBtn.Enabled:=false;
StatisticsComboBox.Items:=MainForm.StatisticsList.Items;
end;

procedure TBrowserForm.BrowserEvent(Sender: TObject);
begin
Case TComponent(Sender).Tag of
  15: Try WebBrowser.GoBack except end;
  16: Try WebBrowser.GoForward except end;
  17: WebBrowser.Refresh;
end;
end;

end.
