{ Copyright (C) by Tobias Schwarz, 2003-2005
  Distributed under the GNU General Public License }

unit LoadSave;

interface

uses
{$IFDEF WIN32}
Controls, Dialogs, SysUtils, Classes, Windows;
{$ELSE}
QControls, QForms, SysUtils, QDialogs;
{$ENDIF}

procedure LoadList(FileName: String);
procedure SaveList;
procedure NewList;
procedure ImportConfigurationFile;
procedure UpdateOpenNewMenu;
function CheckForChangedList: Boolean;

implementation

uses Main, GetTextLang;

function CheckForChangedList:Boolean;
begin
Result:=true;
If MainForm.Changed then begin   { Bei nderungen an der Log-Liste nach Speichern fragen }
   Case MessageDlg(GetLangText(10),mtConfirmation,[mbYes, mbNo, mbCancel],0) of
      mrYes: begin SaveList; Result:=true; end;
      mrNo:  begin Result:=true; end;
      mrCancel: begin Result:=false; end;
   end;
end;
end;

procedure UpdateOpenNewMenu; {OpenNew Men aktualisieren}
var Caption1, Caption2: String;
    Ctr, CtrII: Integer;
begin
If (MainForm.ListFile<>'unknown') and (MainForm.ListFile<>'') then begin
   Caption1:=MainForm.NeuOeffnenBtn4.Caption;
   MainForm.NeuOeffnenBtn4.Caption:=MainForm.NeuOeffnenBtn3.Caption;
   MainForm.NeuOeffnenBtn3.Caption:=MainForm.NeuOeffnenBtn2.Caption;
   MainForm.NeuOeffnenBtn2.Caption:=MainForm.NeuOeffnenBtn1.Caption;
   MainForm.NeuOeffnenBtn1.Caption:=MainForm.ListFile;
   For Ctr:=2 to 4 do begin
      Caption2:=MainForm.OpenRecentPopupMenu.Items[Ctr-1].Caption;
      If Caption2=MainForm.ListFile then begin
         For CtrII:=Ctr+1 to 4 do MainForm.OpenRecentPopupMenu.Items[CtrII-2].Caption:=MainForm.OpenRecentPopupMenu.Items[CtrII-1].Caption;
         MainForm.NeuOeffnenBtn4.Caption:=Caption1;
      end;
   end;
end;
end;

procedure NewList;
begin
UpdateOpenNewMenu;
With MainForm do begin
ListFile:='unknown';
Caption:='Webalizer - unknown';
LogList.Clear;                          { Alle Bedienelemente werden auf Default-Werte gesetzt }
OutputDir.Text:='';
DeleteExisting.Checked:=false;
EnableDomainFilter:=false;
MixDomains:=true;
RemoveDomainInLog:=true;
SaveFilteredLog:=true;
FilterDomain:='www.';
SaveFilteredLogIn:='';
CompressFilteredLog:=true;
LastURL:='ftp://';
SaveDownloadedLog:=true;
{$IFDEF WIN32}
TargetDir:='c:\';
SaveDownloadedLogIn:='c:\temp\';
{$ELSE}
TargetDir:=GetEnvironmentVariable('HOME');
SaveDownloadedLogIn:='/tmp/';
{$ENDIF}
OutputDir.Text:=TargetDir;
ReportTitleEdit.Text:=GetLangText(35);
HostNameEdit.Text:='www.';
IncrementalCheck.Checked:=true;
DailyStatCheck.Checked:=true;
DailyGraphCheck.Checked:=true;
HourlyStatCheck.Checked:=true;
HourlyGraphCheck.Checked:=true;
CountryCheck.Checked:=true;
LogTypeBox.Text:='clf';
HideReferrerEdit.Text:='';
EnableRevDNSLookupsCheck.Checked:=false;
DNSCacheEdit.Text:='dns_cache.db';
DNSChildSpin.Value:=5;
MangleAgentsSpin.Value:=4;
GraphLinesSpin.Value:=0;
TimeoutSpin.Value:=30;
HTMLExtensionBox.ItemIndex:=0;
htmCheck.Checked:=true;
cgiCheck.Checked:=true;
aspCheck.Checked:=false;
phtmlCheck.Checked:=false;
php3Check.Checked:=false;
plCheck.Checked:=false;
HTTPSCheck.Checked:=false;
IgnoreSequenceErrorsCheck.Checked:=false;
TopSitesSpin.Value:=30;
TopKBytesSpin.Value:=10;
TopURLsSpin.Value:=30;
TopURLsKBytesSpin.Value:=10;
TopReferrersSpin.Value:=30;
TopAgentsSpin.Value:=15;
TopCountriesSpin.Value:=30;
TopEntryPagesSpin.Value:=10;
TopExitPagesSpin.Value:=10;
TopSearchesSpin.Value:=20;
TopUsersSpin.Value:=20;
AllSitesCheck.Checked:=false;
AllURLsCheck.Checked:=false;
AllReferrersCheck.Checked:=false;
AllAgentsCheck.Checked:=false;
AllSearchesCheck.Checked:=false;
AllUsersCheck.Checked:=false;
AdditionalTagsMemo.Clear;
SearchEnginesMemo.Clear;
SearchEnginesMemo.Lines.Add('yahoo. p='); SearchEnginesMemo.Lines.Add('altavista. q=');
SearchEnginesMemo.Lines.Add('google. q='); SearchEnginesMemo.Lines.Add('eureka. q=');
SearchEnginesMemo.Lines.Add('lycos. query='); SearchEnginesMemo.Lines.Add('hotbot. MT=');
SearchEnginesMemo.Lines.Add('msn. MT='); SearchEnginesMemo.Lines.Add('infoseek. qt=');
SearchEnginesMemo.Lines.Add('webcrawler searchText='); SearchEnginesMemo.Lines.Add('excite search=');
SearchEnginesMemo.Lines.Add('netscape. search='); SearchEnginesMemo.Lines.Add('mamma. query=');
SearchEnginesMemo.Lines.Add('alltheweb. query='); SearchEnginesMemo.Lines.Add('northernlight. qr=');
HTMLPreMemo.Text:='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">';
HTMLHeadMemo.Text:='<META NAME="author" CONTENT="The Webalizer">';
HTMLBodyMemo.Text:='<BODY BGCOLOR="#E8E8E8" TEXT="#000000" LINK="#0000FF" VLINK="#FF0000">';
HTMLPostMemo.Text:='<BR CLEAR="all">';
HTMLTailMemo.Text:='<IMG SRC="msfree.png" ALT="100% Micro$oft free!">';
HTMLEndMemo.Text:='</BODY></HTML>';
Memo1.Clear; Memo2.Clear; Memo3.Clear; Memo4.Clear; Memo5.Clear;
Memo6.Clear; Memo7.Clear; Memo8.Clear; Memo9.Clear; Memo10.Clear;
Memo11.Clear; Memo12.Clear; Memo13.Clear; Memo14.Clear; Memo15.Clear;
Memo16.Clear; Memo17.Clear;
ConfigMemo.Clear;
OutputMemo.Clear;
ShowStatsCheck.Checked:=true;
BackupCheck.Checked:=false;
SearchStatistics;
SetChanged(false);
end;
end;

procedure LoadList(FileName: String);
var f :Textfile;
    Ctr, LogCount, Status: Integer;
    StatusT: String;
begin
UpdateOpenNewMenu;
With MainForm do begin
If FileName='' then begin
   OpenDialog.Filename:='';
   If ListFile<>'unknown' then OpenDialog.InitialDir:=ExtractFileDir(ListFile);
   OpenDialog.Filter:=GetLangText(2);
   If OpenDialog.Execute then FileName:=OpenDialog.Filename;
end;
If Filename<>'' then begin
   NewList; { Fr den Fall, da jemand ein Listfile einer alten GUI-Version ldt, in dem nicht alle Werte gespeichert sind }
   AssignFile(f,Filename);
   {$i-} Reset(f); {$i+}
   If IOResult<>0 then MessageDlg(GetLangText(3),mtInformation,[mbOK],0) else begin
      LogList.Clear;
      AdditionalTagsMemo.Clear;
      SearchEnginesMemo.Clear;
      HTMLPreMemo.Clear; HTMLHeadMemo.Clear; HTMLBodyMemo.Clear;
      HTMLPostMemo.Clear; HTMLTailMemo.Clear; HTMLEndMemo.Clear;
      Memo1.Clear; Memo2.Clear; Memo3.Clear; Memo4.Clear; Memo5.Clear;
      Memo6.Clear; Memo7.Clear; Memo8.Clear; Memo9.Clear; Memo10.Clear;
      Memo11.Clear; Memo12.Clear; Memo13.Clear; Memo14.Clear; Memo15.Clear;
      Memo16.Clear; Memo17.Clear;
      ConfigMemo.Clear; OutputMemo.Clear;
      Read(f,ProgramVersion); ReadLn(f);  { Die Programmversion unter dem die Log-Liste gespeichert wurde wird bestimmt }
      If ProgramVersion=100 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gew?lten Logfiles }
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         HTMLExtensionBox.ItemIndex:=0;
         htmCheck.Checked:=true;
         cgiCheck.Checked:=true;
         phtmlCheck.Checked:=false;
         php3Check.Checked:=false;
         plCheck.Checked:=false;
         HTTPSCheck.Checked:=false;
         IgnoreSequenceErrorsCheck.Checked:=false;
      end else if ProgramVersion=110 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gewhlten Logfiles }
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         GraphLinesSpin.Value:=Status;
         ReadLn(f,StatusT);
         LogTypeBox.Text:=StatusT;
         ReadLn(f,StatusT);
         HideReferrerEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         TopSitesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopReferrersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopCountriesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopEntryPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopExitPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopSearchesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopUsersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSitesCheck.Checked:=true else AllSitesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllURLsCheck.Checked:=true else AllURLsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllReferrersCheck.Checked:=true else AllReferrersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllAgentsCheck.Checked:=true else AllAgentsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
         ReadLn(f,StatusT);
         HTMLPreMemo.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLHeadMemo.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLBodyMemo.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLPostMemo.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLTailMemo.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLEndMemo.Text:=StatusT;
         HTMLExtensionBox.ItemIndex:=0;
         htmCheck.Checked:=true;
         cgiCheck.Checked:=true;
         phtmlCheck.Checked:=false;
         php3Check.Checked:=false;
         plCheck.Checked:=false;
         HTTPSCheck.Checked:=false;
         IgnoreSequenceErrorsCheck.Checked:=false;
      end else if ProgramVersion=120 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gewhlten Logfiles }
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         GraphLinesSpin.Value:=Status;
         ReadLn(f,StatusT);
         LogTypeBox.Text:=StatusT;
         ReadLn(f,StatusT);
         HideReferrerEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLExtensionBox.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         If Status=1 then htmCheck.Checked:=true else htmCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then cgiCheck.Checked:=true else cgiCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then phtmlCheck.Checked:=true else phtmlCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then php3Check.Checked:=true else php3Check.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then plCheck.Checked:=true else plCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HTTPSCheck.Checked:=true else HTTPSCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IgnoreSequenceErrorsCheck.Checked:=true else IgnoreSequenceErrorsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TopSitesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopReferrersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopCountriesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopEntryPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopExitPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopSearchesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopUsersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSitesCheck.Checked:=true else AllSitesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllURLsCheck.Checked:=true else AllURLsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllReferrersCheck.Checked:=true else AllReferrersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllAgentsCheck.Checked:=true else AllAgentsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             HTMLPreMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             HTMLHeadMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             HTMLBodyMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             HTMLPostMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             HTMLTailMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             HTMLEndMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo1.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo2.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo3.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo4.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo5.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo6.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo7.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo8.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo9.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo10.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo11.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo12.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo13.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo14.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo15.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo16.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo17.Lines.Add(StatusT);
         end;
      end else if ProgramVersion=130 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gewhlten Logfiles }
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then ShowStatsCheck.Checked:=true else ShowStatsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         GraphLinesSpin.Value:=Status;
         ReadLn(f,StatusT);
         LogTypeBox.Text:=StatusT;
         ReadLn(f,StatusT);
         HideReferrerEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLExtensionBox.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         If Status=1 then htmCheck.Checked:=true else htmCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then cgiCheck.Checked:=true else cgiCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then phtmlCheck.Checked:=true else phtmlCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then php3Check.Checked:=true else php3Check.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then plCheck.Checked:=true else plCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HTTPSCheck.Checked:=true else HTTPSCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IgnoreSequenceErrorsCheck.Checked:=true else IgnoreSequenceErrorsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TopSitesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopReferrersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopCountriesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopEntryPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopExitPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopSearchesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopUsersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSitesCheck.Checked:=true else AllSitesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllURLsCheck.Checked:=true else AllURLsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllReferrersCheck.Checked:=true else AllReferrersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllAgentsCheck.Checked:=true else AllAgentsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPreMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLHeadMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLBodyMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPostMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLTailMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLEndMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo1.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo2.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo3.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo4.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo5.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo6.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo7.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo8.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo9.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo10.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo11.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo12.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo13.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo14.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo15.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo16.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo17.Lines.Add(StatusT);
         end;
      end else if ProgramVersion=131 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gewhlten Logfiles }
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then ShowStatsCheck.Checked:=true else ShowStatsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         GraphLinesSpin.Value:=Status;
         ReadLn(f,StatusT);
         LogTypeBox.Text:=StatusT;
         ReadLn(f,StatusT);
         HideReferrerEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLExtensionBox.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         If Status=1 then htmCheck.Checked:=true else htmCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then cgiCheck.Checked:=true else cgiCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then phtmlCheck.Checked:=true else phtmlCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then php3Check.Checked:=true else php3Check.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then plCheck.Checked:=true else plCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HTTPSCheck.Checked:=true else HTTPSCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IgnoreSequenceErrorsCheck.Checked:=true else IgnoreSequenceErrorsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TopSitesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopReferrersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopCountriesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopEntryPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopExitPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopSearchesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopUsersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSitesCheck.Checked:=true else AllSitesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllURLsCheck.Checked:=true else AllURLsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllReferrersCheck.Checked:=true else AllReferrersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllAgentsCheck.Checked:=true else AllAgentsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             AdditionalTagsMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPreMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLHeadMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLBodyMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPostMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLTailMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLEndMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo1.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo2.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo3.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo4.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo5.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo6.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo7.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo8.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo9.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo10.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo11.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo12.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo13.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo14.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo15.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo16.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo17.Lines.Add(StatusT);
         end;
      end else if ProgramVersion=140 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gewhlten Logfiles }
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then ShowStatsCheck.Checked:=true else ShowStatsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         GraphLinesSpin.Value:=Status;
         ReadLn(f,StatusT);
         LogTypeBox.Text:=StatusT;
         ReadLn(f,StatusT);
         HideReferrerEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLExtensionBox.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         If Status=1 then htmCheck.Checked:=true else htmCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then cgiCheck.Checked:=true else cgiCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then aspCheck.Checked:=true else aspCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then phtmlCheck.Checked:=true else phtmlCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then php3Check.Checked:=true else php3Check.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then plCheck.Checked:=true else plCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HTTPSCheck.Checked:=true else HTTPSCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IgnoreSequenceErrorsCheck.Checked:=true else IgnoreSequenceErrorsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TopSitesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopReferrersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopCountriesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopEntryPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopExitPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopSearchesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopUsersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSitesCheck.Checked:=true else AllSitesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllURLsCheck.Checked:=true else AllURLsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllReferrersCheck.Checked:=true else AllReferrersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllAgentsCheck.Checked:=true else AllAgentsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             AdditionalTagsMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPreMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLHeadMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLBodyMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPostMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLTailMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLEndMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo1.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo2.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo3.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo4.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo5.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo6.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo7.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo8.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo9.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo10.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo11.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo12.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo13.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo14.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo15.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo16.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo17.Lines.Add(StatusT);
         end;
      end else if ProgramVersion>=151 then begin
         Read(f,LogCount); ReadLn(f);     { Die Anzahl der Logfiles wird geladen }
         For Ctr:=0 to LogCount-1 do begin
             ReadLn(f,StatusT);
             LogList.Items.Add(StatusT);  { Die Logfiles werden geladen }
         end;
         ReadLn(f,TargetDir);             { Zielverzeichnis }
         OutputDir.Text:=TargetDir;
         ReadLn(f,LastLogDir);                { Verzeichnis des zuletzt gewhlten Logfiles }
         If ProgramVersion>=160 then begin
            ReadLn(f,LastURL);
            Read(f,Status); ReadLn(f);
            If Status=1 then SaveDownloadedLog:=true else SaveDownloadedLog:=false;
            ReadLn(f,SaveDownloadedLogIn);
         end;
         Read(f,Status); ReadLn(f);
         If Status=1 then DeleteExisting.Checked:=true else DeleteExisting.Checked:=false;   { Soll das Ziel-Verzeichnis erst gelscht werden? }
         Read(f,Status); ReadLn(f);
         If Status=1 then EnableDomainFilter:=true else EnableDomainFilter:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then MixDomains:=true else MixDomains:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then RemoveDomainInLog:=true else RemoveDomainInLog:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then SaveFilteredLog:=true else SaveFilteredLog:=false;
         ReadLn(f,FilterDomain);
         ReadLn(f,SaveFilteredLogIn);
         If ProgramVersion>=160 then begin
            Read(f,Status); ReadLn(f);
            If Status=1 then CompressFilteredLog:=true else CompressFilteredLog:=false;
         end;
         Read(f,Status); ReadLn(f);
         If Status=1 then BackupCheck.Checked:=true else BackupCheck.Checked:=false;         { Backup der Log-Liste erstellen }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyStatCheck.Checked:=true else DailyStatCheck.Checked:=false;   { Webalizer Optionen laden }
         Read(f,Status); ReadLn(f);
         If Status=1 then DailyGraphCheck.Checked:=true else DailyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyStatCheck.Checked:=true else HourlyStatCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HourlyGraphCheck.Checked:=true else HourlyGraphCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then CountryCheck.Checked:=true else CountryCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IncrementalCheck.Checked:=true else IncrementalCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then ShowStatsCheck.Checked:=true else ShowStatsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TimeoutSpin.Value:=Status;
         ReadLn(f,StatusT);
         ReportTitleEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HostNameEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         GraphLinesSpin.Value:=Status;
         ReadLn(f,StatusT);
         LogTypeBox.Text:=StatusT;
         ReadLn(f,StatusT);
         HideReferrerEdit.Text:=StatusT;
         ReadLn(f,StatusT);
         HTMLExtensionBox.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         If Status=1 then EnableRevDNSLookupsCheck.Checked:=true else EnableRevDNSLookupsCheck.Checked:=false;
         ReadLn(f,StatusT);
         DNSCacheEdit.Text:=StatusT;
         Read(f,Status); ReadLn(f);
         DNSChildSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         MangleAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then htmCheck.Checked:=true else htmCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then cgiCheck.Checked:=true else cgiCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then aspCheck.Checked:=true else aspCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then phtmlCheck.Checked:=true else phtmlCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then php3Check.Checked:=true else php3Check.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then plCheck.Checked:=true else plCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then HTTPSCheck.Checked:=true else HTTPSCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then IgnoreSequenceErrorsCheck.Checked:=true else IgnoreSequenceErrorsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         TopSitesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopURLsKBytesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopReferrersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopAgentsSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopCountriesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopEntryPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopExitPagesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopSearchesSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         TopUsersSpin.Value:=Status;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSitesCheck.Checked:=true else AllSitesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllURLsCheck.Checked:=true else AllURLsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllReferrersCheck.Checked:=true else AllReferrersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllAgentsCheck.Checked:=true else AllAgentsCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllSearchesCheck.Checked:=true else AllSearchesCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         If Status=1 then AllUsersCheck.Checked:=true else AllUsersCheck.Checked:=false;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             AdditionalTagsMemo.Lines.Add(StatusT);
         end;
         If ProgramVersion>=152 then begin
            Read(f,Status); ReadLn(f);
            For Ctr:=0 to Status-1 do begin
               ReadLn(f,StatusT);
               SearchEnginesMemo.Lines.Add(StatusT);
            end;
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPreMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLHeadMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLBodyMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLPostMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLTailMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=0 to Status-1 do begin
             ReadLn(f,StatusT);
             HTMLEndMemo.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo1.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo2.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo3.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo4.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo5.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo6.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo7.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo8.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo9.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo10.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo11.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo12.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo13.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo14.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo15.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo16.Lines.Add(StatusT);
         end;
         Read(f,Status); ReadLn(f);
         For Ctr:=1 to Status do begin
             ReadLn(f,StatusT);
             Memo17.Lines.Add(StatusT);
         end;
      end;
      CloseFile(f);
      SetChanged(false);
   end;
   ListFile:=FileName;
   LogList.ItemIndex:=LogList.Items.Count-1;
   Caption:='Webalizer - '+ExtractFileName(ListFile);
   SearchStatistics;
end;
end;
end;

procedure SaveList;
var f :Textfile;
    Ctr: Integer;
begin
With MainForm do begin
If (ListFile='unknown') or (ListFile='') then
   If SaveDialog.Execute then ListFile:=SaveDialog.Filename;
If ListFile<>'unknown' then begin
   If FileExists(ListFile) then begin  { Von einer bestehenden Log-Liste wird ein Backup erstellt }
      If FileExists(ChangeFileExt(ListFile,'.bak')) then DeleteFile(PChar(ChangeFileExt(ListFile,'.bak')));
      RenameFile(ListFile,ChangeFileExt(ListFile,'.bak'));
   end;
   AssignFile(f,ListFile);
   {$i-} Rewrite(f); {$i+}
   If IOResult<>0 then begin
      RenameFile(ListFile,ChangeFileExt(ListFile,'.lst')); { Tritt beim Speichern ein Fehler auf wird die Backup-Datei wieder umbenannt }
      MessageDlg(GetLangText(4),mtInformation,[mbOK],0);    end else begin
      Write(f,152); WriteLn(f);                     { Programm-Version speichern }
      Write(f,LogList.Items.Count); WriteLn(f);     { Anzahl an Log-Files speichern }
      For Ctr:=0 to LogList.Items.Count-1 do WriteLn(f,LogList.Items[Ctr]);  { Log-Files speichern }
      WriteLn(f,TargetDir);                         { Zielverzeichnis speichern}
      WriteLn(f,LastLogDir);                        { Verzeichnis des zuletzt gewhlten Logfiles speichern }
      {WriteLn(f,LastURL);
      If SaveDownloadedLog then Write(f,1) else Write(f,0); WriteLn(f);
      WriteLn(f,SaveDownloadedLogIn); }
      If DeleteExisting.Checked then Write(f,1) else Write(f,0); WriteLn(f);  { Bestehende Statistik lschen-Status speichern }
      If EnableDomainFilter then Write(f,1) else Write(f,0); WriteLn(f);
      If MixDomains then Write(f,1) else Write(f,0); WriteLn(f);
      If RemoveDomainInLog then Write(f,1) else Write(f,0); WriteLn(f);
      If SaveFilteredLog then Write(f,1) else Write(f,0); WriteLn(f);
      WriteLn(f,FilterDomain);
      WriteLn(f,SaveFilteredLogIn);
      {If CompressFilteredLog then Write(f,1) else Write(f,0); WriteLn(f);}
      If BackupCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);     { Backup-Status speichern }
      If DailyStatCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);  { Webalizer Optionen speichern }
      If DailyGraphCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If HourlyStatCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If HourlyGraphCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If CountryCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If IncrementalCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If ShowStatsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      Write(f,TimeoutSpin.Value); WriteLn(f);
      WriteLn(f,ReportTitleEdit.Text);
      WriteLn(f,HostNameEdit.Text);
      Write(f,GraphLinesSpin.Value); WriteLn(f);
      WriteLn(f,LogTypeBox.Text);
      WriteLn(f,HideReferrerEdit.Text);
      WriteLn(f,HTMLExtensionBox.Text);
      If EnableRevDNSLookupsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      WriteLn(f,DNSCacheEdit.Text);
      Write(f,DNSChildSpin.Value); WriteLn(f);
      Write(f,MangleAgentsSpin.Value); WriteLn(f);
      If htmCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If cgiCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If aspCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If phtmlCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If php3Check.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If plCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If HTTPSCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If IgnoreSequenceErrorsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      Write(f,TopSitesSpin.Value); WriteLn(f);
      Write(f,TopKBytesSpin.Value); WriteLn(f);
      Write(f,TopURLsSpin.Value); WriteLn(f);
      Write(f,TopURLsKBytesSpin.Value); WriteLn(f);
      Write(f,TopReferrersSpin.Value); WriteLn(f);
      Write(f,TopAgentsSpin.Value); WriteLn(f);
      Write(f,TopCountriesSpin.Value); WriteLn(f);
      Write(f,TopEntryPagesSpin.Value); WriteLn(f);
      Write(f,TopExitPagesSpin.Value); WriteLn(f);
      Write(f,TopSearchesSpin.Value); WriteLn(f);
      Write(f,TopUsersSpin.Value); WriteLn(f);
      If AllSitesCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If AllURLsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If AllReferrersCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If AllAgentsCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If AllSearchesCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      If AllUsersCheck.Checked then Write(f,1) else Write(f,0); WriteLn(f);
      Write(f,AdditionalTagsMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to AdditionalTagsMemo.Lines.Count-1 do WriteLn(f,AdditionalTagsMemo.Lines[Ctr]);
      Write(f,SearchEnginesMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to SearchEnginesMemo.Lines.Count-1 do WriteLn(f,SearchEnginesMemo.Lines[Ctr]);
      Write(f,HTMLPreMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to HTMLPreMemo.Lines.Count-1 do WriteLn(f,HTMLPreMemo.Lines[Ctr]);
      Write(f,HTMLHeadMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to HTMLHeadMemo.Lines.Count-1 do WriteLn(f,HTMLHeadMemo.Lines[Ctr]);
      Write(f,HTMLBodyMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to HTMLBodyMemo.Lines.Count-1 do WriteLn(f,HTMLBodyMemo.Lines[Ctr]);
      Write(f,HTMLPostMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to HTMLPostMemo.Lines.Count-1 do WriteLn(f,HTMLPostMemo.Lines[Ctr]);
      Write(f,HTMLTailMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to HTMLTailMemo.Lines.Count-1 do WriteLn(f,HTMLTailMemo.Lines[Ctr]);
      Write(f,HTMLEndMemo.Lines.Count); WriteLn(f);
      For Ctr:=0 to HTMLEndMemo.Lines.Count-1 do WriteLn(f,HTMLEndMemo.Lines[Ctr]);
      Write(f,Memo1.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo1.Lines.Count-1 do WriteLn(f,Memo1.Lines[Ctr]);
      Write(f,Memo2.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo2.Lines.Count-1 do WriteLn(f,Memo2.Lines[Ctr]);
      Write(f,Memo3.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo3.Lines.Count-1 do WriteLn(f,Memo3.Lines[Ctr]);
      Write(f,Memo4.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo4.Lines.Count-1 do WriteLn(f,Memo4.Lines[Ctr]);
      Write(f,Memo5.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo5.Lines.Count-1 do WriteLn(f,Memo5.Lines[Ctr]);
      Write(f,Memo6.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo6.Lines.Count-1 do WriteLn(f,Memo6.Lines[Ctr]);
      Write(f,Memo7.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo7.Lines.Count-1 do WriteLn(f,Memo7.Lines[Ctr]);
      Write(f,Memo8.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo8.Lines.Count-1 do WriteLn(f,Memo8.Lines[Ctr]);
      Write(f,Memo9.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo9.Lines.Count-1 do WriteLn(f,Memo9.Lines[Ctr]);
      Write(f,Memo10.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo10.Lines.Count-1 do WriteLn(f,Memo10.Lines[Ctr]);
      Write(f,Memo11.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo11.Lines.Count-1 do WriteLn(f,Memo11.Lines[Ctr]);
      Write(f,Memo12.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo12.Lines.Count-1 do WriteLn(f,Memo12.Lines[Ctr]);
      Write(f,Memo13.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo13.Lines.Count-1 do WriteLn(f,Memo13.Lines[Ctr]);
      Write(f,Memo14.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo14.Lines.Count-1 do WriteLn(f,Memo14.Lines[Ctr]);
      Write(f,Memo15.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo15.Lines.Count-1 do WriteLn(f,Memo15.Lines[Ctr]);
      Write(f,Memo16.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo16.Lines.Count-1 do WriteLn(f,Memo16.Lines[Ctr]);
      Write(f,Memo17.Lines.Count); WriteLn(f);
      For Ctr:=0 to Memo17.Lines.Count-1 do WriteLn(f,Memo17.Lines[Ctr]);
      SetChanged(false);
      { Wenn kein Backup der Log-Liste erstellt werden soll, kann die Backup-Datei gelscht werden }
      If (BackupCheck.Checked=false) and (FileExists(ChangeFileExt(ListFile,'.bak'))) then DeleteFile(PChar(ChangeFileExt(ListFile,'.bak')));
   end;
   CloseFile(f);
   Caption:='Webalizer - '+ExtractFileName(ListFile);
end;
end;
end;

procedure ImportConfigurationFile;
var LineCtr, CaseCtr: Integer;
    Value: String;
    Command: ShortString;
begin
With MainForm do begin
OpenDialog.InitialDir:=ExtractFileDir(ListFile);
OpenDialog.Filter:=GetLangText(5);
If OpenDialog.Execute then if FileExists(OpenDialog.Filename) then begin
   { Alle Werte werden auf die Default-Werte zurckgesetzt }
   NewList;
   HTMLPreMemo.Clear; HTMLHeadMemo.Clear; HTMLBodyMemo.Clear; HTMLPostMemo.Clear; HTMLTailMemo.Clear; HTMLEndMemo.Clear;
   ConfigMemo.Lines.LoadFromFile(OpenDialog.Filename);
   For LineCtr:=0 to ConfigMemo.Lines.Count-1 do begin
      { Leer- und Steuerzeichen werden entfernt }
      ConfigMemo.Lines[LineCtr]:=Trim(ConfigMemo.Lines[LineCtr]);
      { Lehre Zeilen und Kommentare in der Konfigurationsdatei werden ignoriert }
      If (ConfigMemo.Lines[LineCtr]<>'') and (ConfigMemo.Lines[LineCtr][1]<>'#') then begin
         CaseCtr:=1; Command:=''; Value:='';
         { Es wird nach dem ersten Wort in einer Zeile gesucht und dieses als Konfigurationsoption interpretiert}
         Repeat
            Command:=Command+ConfigMemo.Lines[LineCtr][CaseCtr];
            Inc(CaseCtr);
         until (CaseCtr>Length(ConfigMemo.Lines[LineCtr])) or (ConfigMemo.Lines[LineCtr][CaseCtr]=' ') or (ConfigMemo.Lines[LineCtr][CaseCtr]=#9);
         Command:=LowerCase(Command);
         If CaseCtr<=Length(ConfigMemo.Lines[LineCtr]) then begin
            Inc(CaseCtr);
            { Der Rest jeder Zeile wird als Wert der Konfiguationsoption interpretiert }
            Repeat
               Value:=Value+ConfigMemo.Lines[LineCtr][CaseCtr];
               Inc(CaseCtr);
            until CaseCtr>Length(ConfigMemo.Lines[LineCtr]);
         end;
         Value:=Trim(Value);
         If Value<>'' then begin
            { Die Optionen werden interpretiert }
            If          Command='logfile' then LogList.Items.Add(Value)
            else if     Command='logtype' then LogTypeBox.Text:=Value
            else if     Command='outputdir' then OutputDir.Text:=Value
            else if     Command='incremental' then begin
                           If Value='no' then IncrementalCheck.Checked:=false else if Value='yes' then IncrementalCheck.Checked:=true;
            end else if Command='reporttitle' then ReportTitleEdit.Text:=Value
            else if     Command='hostname' then HostNameEdit.Text:=Value
            else if     Command='htmlextension' then HTMLExtensionBox.Text:=Value
            else if     Command='dnscache' then DNSCacheEdit.Text:=Value
            else if     Command='dnschildren' then DNSChildSpin.Value:=StrToInt(Value)
            else if     Command='mangleagents' then MangleAgentsSpin.Value:=StrToInt(Value)
            else if     Command='pagetype' then begin
                           If Value='htm*' then htmCheck.Checked:=true
                           else if Value='cgi' then cgiCheck.Checked:=true
                           else if Value='asp' then aspCheck.Checked:=true
                           else if Value='phtml' then phtmlCheck.Checked:=true
                           else if Value='php3' then php3Check.Checked:=true
                           else if Value='pl' then plCheck.Checked:=true;
            end else if Command='usehttps' then begin
                           If Value='yes' then HTTPSCheck.Checked:=true else if Value='no' then HTTPSCheck.Checked:=false;
            end else if Command='htmlhead' then HTMLHeadMemo.Lines.Add(Value)
            else if     Command='htmlpre' then HTMLPreMemo.Lines.Add(Value)
            else if     Command='htmlbody' then HTMLBodyMemo.Lines.Add(Value)
            else if     Command='htmlpost' then HTMLPostMemo.Lines.Add(Value)
            else if     Command='htmltail' then HTMLTailMemo.Lines.Add(Value)
            else if     Command='htmlend' then HTMLEndMemo.Lines.Add(Value)
            else if     Command='foldseqerr' then begin
                           If Value='yes' then IgnoreSequenceErrorsCheck.Checked:=true else if Value='no' then IgnoreSequenceErrorsCheck.Checked:=false;
            end else if Command='visittimeout' then TimeoutSpin.Value:=Round(StrToInt(Value)/60)
            else if Command='countrygraph' then begin
                           If Value='yes' then CountryCheck.Checked:=true else if Value='no' then CountryCheck.Checked:=false;
            end else if Command='dailygraph' then begin
                           If Value='yes' then DailyGraphCheck.Checked:=true else if Value='no' then DailyGraphCheck.Checked:=false;
            end else if Command='dailystats' then begin
                           If Value='yes' then DailyStatCheck.Checked:=true else if Value='no' then DailyStatCheck.Checked:=false;
            end else if Command='hourlygraph' then begin
                           If Value='yes' then HourlyGraphCheck.Checked:=true else if Value='no' then HourlyGraphCheck.Checked:=false;
            end else if Command='hourlystats' then begin
                           If Value='yes' then HourlyStatCheck.Checked:=true else if Value='no' then HourlyStatCheck.Checked:=false;
            end else if Command='graphlines' then GraphLinesSpin.Value:=StrToInt(Value)
            else if Command='topsites' then TopSitesSpin.Value:=StrToInt(Value)
            else if Command='topksites' then TopKBytesSpin.Value:=StrToInt(Value)
            else if Command='topurls' then TopURLsSpin.Value:=StrToInt(Value)
            else if Command='topkurls' then TopURLsKBytesSpin.Value:=StrToInt(Value)
            else if Command='topreferrers' then TopReferrersSpin.Value:=StrToInt(Value)
            else if Command='topagents' then TopAgentsSpin.Value:=StrToInt(Value)
            else if Command='topcountries' then TopCountriesSpin.Value:=StrToInt(Value)
            else if Command='topentry' then TopEntryPagesSpin.Value:=StrToInt(Value)
            else if Command='topexit' then TopExitPagesSpin.Value:=StrToInt(Value)
            else if Command='topsearch' then TopSearchesSpin.Value:=StrToInt(Value)
            else if Command='topusers' then TopUsersSpin.Value:=StrToInt(Value)
            else if Command='allsites' then begin
                           If Value='yes' then AllSitesCheck.Checked:=true else if Value='no' then AllSitesCheck.Checked:=false;
            end else if Command='allurls' then begin
                           If Value='yes' then AllURLsCheck.Checked:=true else if Value='no' then AllURLsCheck.Checked:=false;
            end else if Command='allreferrers' then begin
                           If Value='yes' then AllReferrersCheck.Checked:=true else if Value='no' then AllReferrersCheck.Checked:=false;
            end else if Command='allagents' then begin
                           If Value='yes' then AllAgentsCheck.Checked:=true else if Value='no' then AllAgentsCheck.Checked:=false;
            end else if Command='allsearchstr' then begin
                           If Value='yes' then AllSearchesCheck.Checked:=true else if Value='no' then AllSearchesCheck.Checked:=false;
            end else if Command='allusers' then begin
                           If Value='yes' then AllUsersCheck.Checked:=true else if Value='no' then AllUsersCheck.Checked:=false;
            end else if Command='hidesite' then Memo1.Lines.Add(Value)
            else if Command='hideurl' then Memo2.Lines.Add(Value)
            else if Command='hidereferrer' then Memo3.Lines.Add(Value)
            else if Command='hideagent' then Memo4.Lines.Add(Value)
            else if Command='hideuser' then Memo5.Lines.Add(Value)
            else if Command='groupsite' then Memo6.Lines.Add(Value)
            else if Command='groupurl' then Memo7.Lines.Add(Value)
            else if Command='groupreferrer' then Memo8.Lines.Add(Value)
            else if Command='groupagent' then Memo9.Lines.Add(Value)
            else if Command='groupuser' then Memo10.Lines.Add(Value)
            else if Command='ignoresite' then Memo11.Lines.Add(Value)
            else if Command='ignoreurl' then Memo12.Lines.Add(Value)
            else if Command='ignorereferrer' then Memo13.Lines.Add(Value)
            else if Command='ignoreagent' then Memo14.Lines.Add(Value)
            else if Command='ignoreuser' then Memo15.Lines.Add(Value)
            else if Command='includeurl' then Memo16.Lines.Add(Value)
            else if Command='includeuser' then Memo17.Lines.Add(Value)
            else if Command='searchengine' then SearchEnginesMemo.Lines.Add(Value)
            else AdditionalTagsMemo.Lines.Add(Command+' '+Value);
         end;
      end;
   end;
   SearchStatistics;
end;
end;
end;

end.
 
