{ Copyright (C) by Tobias Schwarz, 2003-2005
  Distributed under the GNU General Public License }

unit Main;

interface

uses
  {$IFDEF WIN32}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, ExtCtrls, StdCtrls, Registry, Spin,
  ImgList, ShellAPI, ConsoleApp, ReInit, Menus, DelphiGzip;
  {$ELSE}
  SysUtils, Classes, QForms, QImgList, QDialogs, QStdCtrls, QComCtrls,
  QExtCtrls, QControls, QButtons, QMenus, Types, Libc;
  {$ENDIF}

type
  TMainForm = class(TForm)
    PageControl: TPageControl;
    ChoseFiles: TTabSheet;
    WebalizerOptions: TTabSheet;
    RunBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    HelpBtn: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    LogList: TListBox;
    Label3: TLabel;
    AddBtn: TSpeedButton;
    DelBtn: TSpeedButton;
    UpBtn: TSpeedButton;
    DownBtn: TSpeedButton;
    OutputDir: TEdit;
    Label4: TLabel;
    DeleteExisting: TCheckBox;
    OpenDialog: TOpenDialog;
    ChooseTargetDirBtn: TSpeedButton;
    SaveDialog: TSaveDialog;
    LoadListBtn: TSpeedButton;
    SaveListBtn: TSpeedButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Label5: TLabel;
    DailyStatCheck: TCheckBox;
    DailyGraphCheck: TCheckBox;
    HourlyStatCheck: TCheckBox;
    HourlyGraphCheck: TCheckBox;
    CountryCheck: TCheckBox;
    Label6: TLabel;
    IncrementalCheck: TCheckBox;
    ReportTitleEdit: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    HostNameEdit: TEdit;
    ImageList: TImageList;
    Label12: TLabel;
    NewListBtn: TSpeedButton;
    AdvancedOptions: TTabSheet;
    AdditionalHTML: TTabSheet;
    HTMLPreMemo: TMemo;
    HTMLHeadMemo: TMemo;
    HTMLBodyMemo: TMemo;
    HTMLPostMemo: TMemo;
    HTMLTailMemo: TMemo;
    HTMLEndMemo: TMemo;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    ConfigurationFile: TTabSheet;
    WebalizerOutput: TTabSheet;
    Label35: TLabel;
    HTMLExtensionBox: TComboBox;
    PageTypeGroupBox: TGroupBox;
    htmCheck: TCheckBox;
    cgiCheck: TCheckBox;
    phtmlcheck: TCheckBox;
    php3Check: TCheckBox;
    plCheck: TCheckBox;
    HTTPSCheck: TCheckBox;
    IgnoreSequenceErrorsCheck: TCheckBox;
    HideGroupPage: TTabSheet;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    ModeBtn: TSpeedButton;
    ConfigMemo: TMemo;
    Memo16: TMemo;
    Label55: TLabel;
    Memo17: TMemo;
    Label56: TLabel;
    Label54: TLabel;
    Label48: TLabel;
    Label41: TLabel;
    Memo11: TMemo;
    Label42: TLabel;
    Memo12: TMemo;
    Label43: TLabel;
    Memo13: TMemo;
    Label46: TLabel;
    Memo14: TMemo;
    Label47: TLabel;
    Memo15: TMemo;
    Memo10: TMemo;
    Label61: TLabel;
    Memo9: TMemo;
    Label60: TLabel;
    Memo8: TMemo;
    Label59: TLabel;
    Memo7: TMemo;
    Label58: TLabel;
    Memo6: TMemo;
    Label57: TLabel;
    Label45: TLabel;
    Label44: TLabel;
    Label36: TLabel;
    Memo1: TMemo;
    Label38: TLabel;
    Memo2: TMemo;
    Label37: TLabel;
    Memo3: TMemo;
    Label39: TLabel;
    Memo4: TMemo;
    Label40: TLabel;
    Memo5: TMemo;
    BackupCheck: TCheckBox;
    Label11: TLabel;
    LanguageBox: TComboBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Label32: TLabel;
    Label33: TLabel;
    AllSitesCheck: TCheckBox;
    TopSitesSpin: TSpinEdit;
    Label21: TLabel;
    Label22: TLabel;
    TopKBytesSpin: TSpinEdit;
    AllURLsCheck: TCheckBox;
    TopURLsSpin: TSpinEdit;
    Label23: TLabel;
    Label24: TLabel;
    TopURLsKBytesSpin: TSpinEdit;
    Label25: TLabel;
    TopReferrersSpin: TSpinEdit;
    AllReferrersCheck: TCheckBox;
    AllAgentsCheck: TCheckBox;
    TopAgentsSpin: TSpinEdit;
    Label26: TLabel;
    Label27: TLabel;
    TopCountriesSpin: TSpinEdit;
    Label62: TLabel;
    TopEntryPagesSpin: TSpinEdit;
    Label28: TLabel;
    Label29: TLabel;
    TopExitPagesSpin: TSpinEdit;
    TopSearchesSpin: TSpinEdit;
    Label30: TLabel;
    Bevel4: TBevel;
    TopUsersSpin: TSpinEdit;
    Label31: TLabel;
    AllUsersCheck: TCheckBox;
    AllSearchesCheck: TCheckBox;
    ImportBtn: TSpeedButton;
    ShowStatsCheck: TCheckBox;
    LoadListCheck: TCheckBox;
    AboutBtn: TSpeedButton;
    SaveListAsBtn: TSpeedButton;
    Bevel5: TBevel;
    AdditionalTagsMemo: TMemo;
    Label63: TLabel;
    EditLogfilesBtn: TSpeedButton;
    aspCheck: TCheckBox;
    Label34: TLabel;
    HideReferrerEdit: TEdit;
    Label13: TLabel;
    LogTypeBox: TComboBox;
    Label10: TLabel;
    TimeoutSpin: TSpinEdit;
    Label7: TLabel;
    Label20: TLabel;
    GraphLinesSpin: TSpinEdit;
    DNSCacheEdit: TEdit;
    DNSChildSpin: TSpinEdit;
    Label65: TLabel;
    Label66: TLabel;
    EnableRevDNSLookupsCheck: TCheckBox;
    Label67: TLabel;
    MangleAgentsSpin: TSpinEdit;
    PopupMenu: TPopupMenu;
    DateienAuswaehlenBtn: TMenuItem;
    WebalizerOptionenBtn: TMenuItem;
    WeitereOptionenBtn: TMenuItem;
    ZusaetzlicherHTMLCodeBtn: TMenuItem;
    HideGroupIgnoreIncludeBtn: TMenuItem;
    KonfigurationsdateiOutputBtn: TMenuItem;
    GUIOptionenBtn: TMenuItem;
    N1: TMenuItem;
    AktivenReiterAusblendenBtn: TMenuItem;
    OutputMemo: TMemo;
    OpenRecentPopupMenu: TPopupMenu;
    MonthlyStatisticsBtn: TSpeedButton;
    DailyStatisticsBtn: TSpeedButton;
    EntryPagesBtn: TSpeedButton;
    URLsBtn: TSpeedButton;
    SitesBtn: TSpeedButton;
    ExitPagesBtn: TSpeedButton;
    UserNamesBtn: TSpeedButton;
    ReferrersBtn: TSpeedButton;
    SearchesBtn: TSpeedButton;
    UserAgentsBtn: TSpeedButton;
    HourlyStatisticsBtn: TSpeedButton;
    LastYearStatisticsBtn: TSpeedButton;
    UseStandartBrowserCheck: TCheckBox;
    StatisticsList: TListBox;
    Label68: TLabel;
    NeuOeffnenBtn1: TMenuItem;
    NeuOeffnenBtn2: TMenuItem;
    NeuOeffnenBtn3: TMenuItem;
    NeuOeffnenBtn4: TMenuItem;
    Label69: TLabel;
    Label70: TLabel;
    SearchEnginesMemo: TMemo;
    Label71: TLabel;
    Label64: TLabel;
    ShowHintsCheck: TCheckBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    procedure HideGroupPageShow(Sender: TObject);
    procedure ShowHintsCheckClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RunBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure UpBtnClick(Sender: TObject);
    procedure DownBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure OnBtnClick(Sender: TObject);
    procedure DeleteExistingClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    {$IFDEF WIN32}
    procedure LogListDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    {$ELSE}
    procedure LogListDrawItem(Sender: TObject; Index: Integer; Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
    {$ENDIF}
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
    AdvancedMode: Boolean;
    procedure SetLanguage(LangID: Integer; SaveBeforeChange: Boolean);
    procedure ChangeMode(TurnInAdvancedMode: Boolean);
    procedure GetInstalledLanguages;
    procedure PrepareLogfile;
    procedure SplitLogfile(Filename: String);
    function RunWebalizer(Logfile: String): Integer;
    procedure SetTabStatus(TabIndex: Integer; Status: Boolean);
    {$IFDEF WIN32}
    procedure RunningUpdate(Process: THandle; const NewLine: String);
    {$ELSE}
    WinLeft, WinTop: Integer;
    {$ENDIF}
  public
    { Public-Deklarationen }
    GUIExe: String;
    TempDir: String;
    ProgramVersion, LanguageID: Integer;
    WebalizerExe, LastLogDir, LastURL, TargetDir, ListFile, FilterDomain, SaveFilteredLogIn, SaveDownloadedLogIn: String;
    Changed, EnableDomainFilter, MixDomains, RemoveDomainInLog, SaveFilteredLog, CompressFilteredLog, SaveDownloadedLog: Boolean;
    StatisticsFiles: TStringList;
    procedure SetChanged(Status: Boolean);
    procedure OpenURL(pURL: String);
    procedure SearchStatistics;
    procedure SetOSSpecifics;
    procedure OpenStatistics(Index: Integer; Chapter: String);
  end;

var
  MainForm: TMainForm;

implementation

uses Logfilesplitter, GetTextLang, LoadSave, Config_File, Infofenster, WildMatch,
     Progress,
{$IFDEF WIN32}
Browser;
{$ELSE}
Inifiles;
{$ENDIF}

{$IFDEF WIN32}
const
  ENGLISH = (SUBLANG_ENGLISH_US shl 10) or LANG_ENGLISH;
  GERMAN  = (SUBLANG_GERMAN shl 10) or LANG_GERMAN;
  SPANISH  = (SUBLANG_SPANISH shl 10) or LANG_SPANISH;
  PathDelim = '\';

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var Registry: TRegistry;
    WebalizerDirExists: Boolean;
    WinDir: PChar;
begin
GetDir(0,GUIExe);
If GuiExe[Length(GUIExe)]<>'\' then GUIExe:=GUIExe+'\';
StatisticsFiles:=TStringList.Create;
NewList;
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Volatile Environment') then begin
   Registry.OpenKeyReadOnly('Volatile Environment');
   TempDir:=Registry.ReadString('APPDATA')+'\';
   Registry.CloseKey;
end else begin
   WinDir:=StrAlloc(MAX_PATH+1);
   GetWindowsDirectory(WinDir, MAX_PATH);
   TempDir:=WinDir+'\temp\';
   StrDispose(WinDir);
end;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\Directories') then begin
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\Directories') then begin
      ListFile:=Registry.ReadString('ListFile');     { Der Name der zuletzt verwendeten Log-Liste wird geladen }
      LastLogDir:=Registry.ReadString('LogDir');     { Das Verzeichnis des zuletzt verwendeten Log-Files wird geladen }
      TargetDir:=Registry.ReadString('TargetDir');   { Das zuletzt gewhlte Zielverzeichnis wird geladen }
      Registry.CloseKey;
   end;
end else begin
   ListFile:='';
   LastLogDir:='c:\';
   TargetDir:='c:\';
end;
GetInstalledLanguages;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\Configuration') then begin  { Sonstiges wird aus der Registry geladen }
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\Configuration') then begin
      If Registry.ValueExists('Language') then SetLanguage(Registry.ReadInteger('Language'),false) else SetLanguage(1,false);
      If Registry.ValueExists('Mode') then ChangeMode(Registry.ReadBool('Mode'));
      If Registry.ValueExists('LoadLastList') then LoadListCheck.Checked:=Registry.ReadBool('LoadLastList');
      If Registry.ValueExists('UseStandartBrowser') then UseStandartBrowserCheck.Checked:=Registry.ReadBool('UseStandartBrowser');
      If Registry.ValueExists('ShowHints') then ShowHintsCheck.Checked:=Registry.ReadBool('ShowHints');
      Application.ShowHint:=ShowHintsCheck.Checked;
      If Registry.ValueExists('ShowFileListTab') then SetTabStatus(0,Registry.ReadBool('ShowFilelistTab'));
      If Registry.ValueExists('ShowOptionsTab') then SetTabStatus(1,Registry.ReadBool('ShowOptionsTab'));
      If Registry.ValueExists('ShowAdvancedOptionsTab') then SetTabStatus(2,Registry.ReadBool('ShowAdvancedOptionsTab'));
      If Registry.ValueExists('ShowAdditionalHTMLTab') then SetTabStatus(3,Registry.ReadBool('ShowAdditionalHTMLTab'));
      If Registry.ValueExists('ShowHGIITab') then SetTabStatus(4,Registry.ReadBool('ShowHGIITab'));
      If Registry.ValueExists('ShowConfigOutputTab') then SetTabStatus(5,Registry.ReadBool('ShowConfigOutputTab'));
      If Registry.ValueExists('ShowGUIOptionsTab') then SetTabStatus(6,Registry.ReadBool('ShowGUIOptionsTab'));
      Registry.CloseKey;
   end;
end else begin
   SetLanguage(1,false);
   ChangeMode(true);
   LoadListCheck.Checked:=true;
   UseStandartBrowserCheck.Checked:=false;
end;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\OpenNew') then begin
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\OpenNew') then begin
      If Registry.ValueExists('Open1') then NeuOeffnenBtn1.Caption:=Registry.ReadString('Open1');
      If Registry.ValueExists('Open2') then NeuOeffnenBtn2.Caption:=Registry.ReadString('Open2');
      If Registry.ValueExists('Open3') then NeuOeffnenBtn3.Caption:=Registry.ReadString('Open3');
      If Registry.ValueExists('Open4') then NeuOeffnenBtn4.Caption:=Registry.ReadString('Open4');
      Registry.CloseKey;
   end;
end;
OutputDir.Text:=TargetDir;
WebalizerDirExists:=false;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\ProgramProperty') then begin
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\ProgramProperty') then begin
      If Registry.ValueExists('WebalizerExe') then WebalizerExe:=Registry.ReadString('WebalizerExe'); { Das Verzeichnis in dem Webalizer.exe liegt wird geladen }
      Registry.CloseKey;
      If FileExists(WebalizerExe+'webalizer.exe') then WebalizerDirExists:=true;
   end;
end;
If WebalizerDirExists=false then begin
   Registry.RootKey:=HKEY_LOCAL_MACHINE;
   If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\ProgramProperty') then begin
      If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\ProgramProperty') then begin
         If Registry.ValueExists('WebalizerExe') then WebalizerExe:=Registry.ReadString('WebalizerExe'); { Das Verzeichnis in dem Webalizer.exe liegt wird geladen }
         Registry.CloseKey;
         If FileExists(WebalizerExe+'webalizer.exe') then WebalizerDirExists:=true;
      end;
   end;
end;
If WebalizerDirExists=false then begin    { Falls noch kein Eintrag fr das Verzeichnis von webalizer.exe existiert oder die Datei dort nicht gefunden werden kann }
    If FileExists(GUIExe+'webalizer.exe') then begin  { Falls Webalizer im gleichen Verzeichnis wie die GUI liegt ist alles OK }
       WebalizerExe:=GUIExe;
    end else begin                        { Anderenfalls mu der Anwender das Verzeichnis in dem Webalizer liegt angeben }
      Case MessageDlg(GetLangText(1),mtConfirmation,[mbOK,mbCancel],0) of
         mrCancel: Application.Terminate;
         mrOK: begin
             OpenDialog.InitialDir:='c:\';
             OpenDialog.FileName:='webalizer.exe';
             If OpenDialog.Execute then begin   { Das Verzeichnis in dem webalizer.exe liegt wird bestimmt }
                If FileExists(ExtractFilePath(OpenDialog.Filename)+'webalizer.exe') then begin
                    WebalizerExe:=ExtractFilePath(OpenDialog.Filename);
                end else Application.Terminate;
             end else Application.Terminate;
         end;
      end;
    end;
    Registry.Access:=KEY_ALL_ACCESS;
    If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\ProgramProperty',true) then begin
       Try Registry.WriteString('WebalizerExe',WebalizerExe);
       Finally Registry.CloseKey; end;
    end;
    Registry.RootKey:=HKEY_CURRENT_USER;
    If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\ProgramProperty',true) then begin
       Try Registry.WriteString('WebalizerExe',WebalizerExe);
       Finally Registry.CloseKey; end;
    end;
end;
Registry.Free;
{$ELSE}
const
  TempDir = '/tmp/';

{$R *.xfm}

procedure TMainForm.FormCreate(Sender: TObject);
var WebalizerExists: Boolean;
    Inifile: TInifile;
begin
GUIExe:=ExtractFilePath(Application.ExeName);
StatisticsFiles:=TStringList.Create;
NewList;
IniFile:=TIniFile.Create(GetEnvironmentVariable('HOME')+'/.xwebalizer');
ListFile:=IniFile.ReadString('Directories','ListFile','unknown');     { Der Name der zuletzt verwendeten Log-Liste wird geladen }
LastLogDir:=IniFile.ReadString('Directories','LogDir',GetEnvironmentVariable('HOME'));  { Das Verzeichnis des zuletzt verwendeten Log-Files wird geladen }
TargetDir:=IniFile.ReadString('Directories','TargetDir',GetEnvironmentVariable('HOME'));{ Das zuletzt gewlte Zielverzeichnis wird geladen }
GetInstalledLanguages;
SetLanguage(IniFile.ReadInteger('Configuration','Language',0),false);
ChangeMode(IniFile.ReadBool('Configuration','Mode',true));
LoadListCheck.Checked:=IniFile.ReadBool('Configuration','LoadLastList',true);
UseStandartBrowserCheck.Checked:=IniFile.ReadBool('Configuration','UseStandartBrowser',false);
SetTabStatus(0,IniFile.ReadBool('Configuration','ShowFilelistTab',true));
SetTabStatus(1,IniFile.ReadBool('Configuration','ShowOptionsTab',true));
SetTabStatus(2,IniFile.ReadBool('Configuration','ShowAdvancedOptionsTab',true));
SetTabStatus(3,IniFile.ReadBool('Configuration','ShowAdditionalHTMLTab',true));
SetTabStatus(4,IniFile.ReadBool('Configuration','ShowHGIITab',true));
SetTabStatus(5,IniFile.ReadBool('Configuration','ShowConfigOutputTab',true));
SetTabStatus(6,IniFile.ReadBool('Configuration','ShowGUIOptionsTab',true));
NeuOeffnenBtn1.Caption:=IniFile.ReadString('OpenNew','Open1','1');
NeuOeffnenBtn2.Caption:=IniFile.ReadString('OpenNew','Open2','2');
NeuOeffnenBtn3.Caption:=IniFile.ReadString('OpenNew','Open3','3');
NeuOeffnenBtn4.Caption:=IniFile.ReadString('OpenNew','Open4','4');
OutputDir.Text:=TargetDir;
WinLeft:=IniFile.ReadInteger('WindowPos','Left',20);
WinTop:=IniFile.ReadInteger('WindowPos','Top',20);
WebalizerExists:=false;
WebalizerExe:=IniFile.ReadString('ProgramProperty','WebalizerExe',GUIExe+'webalizer'); { Das Verzeichnis in dem Webalizer.exe liegt wird geladen }
If FileExists(WebalizerExe) then WebalizerExists:=true;
If WebalizerExists=false then begin         { Falls noch kein Eintrag fr das Verzeichnis von webalizer existiert oder die Datei dort nicht gefunden werden kann }
   If FileExists('/usr/bin/webalizer') then WebalizerExe:='/usr/bin/webalizer'
   else if FileExists('/usr/local/bin/webalizer') then WebalizerExe:='/usr/local/bin/webalizer'
   else if FileExists('/usr/X11/bin/webalizer') then WebalizerExe:='/usr/X11/bin'
   else if FileExists('/bin/webalizer') then WebalizerExe:='/bin'
   else if FileExists('/usr/local/xwebalizer/webalizer') then WebalizerExe:='/usr/local/xwebalizer'
   else if FileExists('/opt/xwebalizer/webalizer') then WebalizerExe:='/opt/xwebalizer'
   else begin                          { Anderenfalls mu der Anwender das Verzeichnis in dem Webalizer liegt angeben }
      Case MessageDlg(GetLangText(18),mtConfirmation,[mbOK,mbCancel],0) of
         mrCancel: Application.Terminate;
         mrOK: begin
             If DirectoryExists('/usr/bin') then OpenDialog.InitialDir:='/usr/bin' else OpenDialog.InitialDir:='/';
             If OpenDialog.Execute then begin   { Das Verzeichnis in dem Webalizer liegt wird bestimmt }
                If FileExists(OpenDialog.Filename) then begin
                    WebalizerExe:=OpenDialog.Filename;
                end else Application.Terminate;
             end else Application.Terminate;
         end;
      end;
    end;
end;
IniFile.UpdateFile;
IniFile.Free;
{$ENDIF}
If (LoadListCheck.Checked) and (FileExists(ListFile)) then LoadList(ListFile);
SetChanged(False);
end;

procedure TMainForm.SetOSSpecifics;
begin
{$IFDEF WIN32}
EnableRevDNSLookupsCheck.Checked:=false;
EnableRevDNSLookupsCheck.Enabled:=false;
{$ELSE}
HelpBtn.Enabled:=false;
LastYearStatisticsBtn.Enabled:=false;
MonthlyStatisticsBtn.Enabled:=false;
DailyStatisticsBtn.Enabled:=false;
HourlyStatisticsBtn.Enabled:=false;
URLsBtn.Enabled:=false;
SitesBtn.Enabled:=false;
EntryPagesBtn.Enabled:=false;
ExitPagesBtn.Enabled:=false;
ReferrersBtn.Enabled:=false;
SearchesBtn.Enabled:=false;
UserNamesBtn.Enabled:=false;
UserAgentsBtn.Enabled:=false;
UseStandartBrowserCheck.Checked:=false;
UseStandartBrowserCheck.Enabled:=false;
ShowStatsCheck.Checked:=false;
ShowStatsCheck.Enabled:=false;
LanguageBox.Enabled:=false;
{$ENDIF}
end;

procedure TMainForm.FormShow(Sender: TObject);
{$IFDEF WIN32}
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin  { Die Position des Programm-Fensters wird aus der Registry geladen }
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin
      If Registry.ValueExists('Left') then Left:=Registry.ReadInteger('Left');
      If Registry.ValueExists('Top') then Top:=Registry.ReadInteger('Top');
      Registry.CloseKey;
   end;
end;
Registry.Free;
{$ELSE}
begin
Left:=WinLeft;
Top:=WinTop;
{$ENDIF}
SetOSSpecifics;
end;

procedure TMainForm.SetTabStatus(TabIndex: Integer; Status: Boolean);
begin
PageControl.Pages[TabIndex].TabVisible:=Status;
Case TabIndex of
   0: DateienAuswaehlenBtn.Checked:=Status;
   1: WebalizerOptionenBtn.Checked:=Status;
   2: WeitereOptionenBtn.Checked:=Status;
   3: ZusaetzlicherHTMLCodeBtn.Checked:=Status;
   4: HideGroupIgnoreIncludeBtn.Checked:=Status;
   5: KonfigurationsdateiOutputBtn.Checked:=Status;
   6: GUIOptionenBtn.Checked:=Status;
end;
end;

procedure TMainForm.SearchStatistics;
var SearchRec: TSearchRec;
    EOFound: Boolean;
    DateString: String;
begin
StatisticsList.Clear;
StatisticsFiles.Clear;
EOFound:=false;
If FindFirst(TargetDir+'usage_*.htm*',faAnyFile,SearchRec)=0 then
while not EOFound do begin
   DateString:=GetLangText(StrToInt(Copy(SearchRec.Name,11,2))+18);
   DateString:=DateString+' '+Copy(SearchRec.Name,7,4);
   StatisticsList.Items.Add(DateString);
   StatisticsFiles.Add(SearchRec.Name);
   EOFound:=(FindNext(SearchRec)<>0);
end;
FindClose(SearchRec);
StatisticsList.ItemIndex:=StatisticsList.Items.Count-1;
end;

procedure TMainForm.OpenStatistics(Index: Integer; Chapter: String);
var Filename: String;
begin
If Chapter='index' then Filename:=TargetDir+'index.html' else
   If Index=-1 then begin
      Filename:='';
      MessageDlg(GetLangText(36),mtInformation,[mbOK],0);
   end else
      Filename:='file:///'+TargetDir+StatisticsFiles.Strings[Index]+Chapter;
If Filename<>'' then
   {$IFDEF WIN32}
   If UseStandartBrowserCheck.Checked then begin
      OpenURL(Filename);
   end else begin
      If BrowserForm=nil then BrowserForm:=TBrowserForm.Create(self);
      BrowserForm.WebBrowser.Navigate(Filename);
      BrowserForm.Show;        
      BrowserForm.StatisticsComboBox.ItemIndex:=Index;
   end;
   {$ELSE}
   OpenURL(Filename);
   {$ENDIF}
end;

procedure TMainForm.OpenURL(pURL:String);
{$IFDEF WIN32}
begin
ShellExecute(Application.Handle,'open',PCHar(pURL),nil,nil,sw_ShowNormal);
end;
{$ELSE}
var Browsers: Array[0..4] of String;
   Command, ReturnVAL: String;
   i: Integer;
begin
Browsers[0]:='konqueror';
Browsers[1]:='kfmclient openURL';
Browsers[2]:='mozilla';
Browsers[3]:='netscape';
For i:=0 to 4 do begin
   If i<4 then begin
      { Nach vorhandenem Browser suchen => starten }
      Command:=Browsers[i]+' '+pURL;
      If Libc.system(PChar(Command))=0 then break;
   end else begin
      { keiner der obigen Browser gefunden, manuelle Eingabe erforderlich }
      If InputQuery(GetLangText(15),GetLangText(16),ReturnVAL) then begin
         Command:=ReturnVAL+' '+pURL;
         Libc.system(PChar(Command));
      end;
   end;
end;
{$ENDIF}

procedure TMainForm.OnBtnClick(Sender: TObject);
var Info: TInfofenster;
    SplitterForm: TSplitterForm;
begin
Case TComponent(Sender).Tag of
1: begin
      SetTabStatus(0,true);
      PageControl.ActivePage:=ChoseFiles;
   end;
2: begin
      SetTabStatus(1,true);
      PageControl.ActivePage:=WebalizerOptions;
   end;
3: begin
      SetTabStatus(2,true);
      PageControl.ActivePage:=AdvancedOptions;
   end;
4: begin
      SetTabStatus(3,true);
      PageControl.ActivePage:=AdditionalHTML;
   end;
5: begin
      SetTabStatus(4,true);
      PageControl.ActivePage:=ConfigurationFile;
   end;
6: begin
      SetTabStatus(5,true);
      PageControl.ActivePage:=WebalizerOutput;
   end;
7: begin
      SetTabStatus(6,true);
      PageControl.ActivePage:=HideGroupPage;
   end;
8: SetTabStatus(PageControl.ActivePageIndex,false);
11: If AdvancedMode=true then ChangeMode(false) else ChangeMode(true);
13: Close;
14: If CheckForChangedList then NewList;
15: If CheckForChangedList then ImportConfigurationFile;
16: If CheckForChangedList then LoadList('');
17: SaveList;
18: begin
       ListFile:='unknown';
       SaveList;
    end;
23: begin
       SplitterForm:=TSplitterForm.Create(self);
       Try SplitterForm.ShowModal;
       finally SplitterForm.Free;
       end;
       SetChanged(true);
    end;
25: begin
       OpenDialog.Filename:='index.html';
       OpenDialog.InitialDir:=TargetDir;
       If OpenDialog.Execute then begin
          TargetDir:=ExtractFilePath(OpenDialog.Filename);
          OutputDir.Text:=TargetDir;
          SearchStatistics;
          SetChanged(true);
       end;
    end;
26: begin
       If EnableRevDNSLookupsCheck.Checked then begin
          Label65.Enabled:=true; Label66.Enabled:=true; DNSCacheEdit.Enabled:=true; DNSChildSpin.Enabled:=true;
       end else begin
          Label65.Enabled:=false; Label66.Enabled:=false; DNSCacheEdit.Enabled:=false; DNSChildSpin.Enabled:=false;
       end;
       SetChanged(true);
    end;
29: SetLanguage(LanguageBox.ItemIndex,true);
30: begin
       TargetDir:=Trim(OutputDir.Text);
       If TargetDir[Length(TargetDir)]<>PathDelim then TargetDir:=TargetDir+PathDelim;
       SearchStatistics;
       SetChanged(true);
    end;
31: begin
       Info:=TInfofenster.Create(self);
       Try Info.ShowModal;
       finally Info.free;
       end;
    end;
42: OpenStatistics(StatisticsList.ItemIndex,'index');
10: OpenStatistics(StatisticsList.ItemIndex,'');
32: OpenStatistics(StatisticsList.ItemIndex,'#DAYSTATS');
33: OpenStatistics(StatisticsList.ItemIndex,'#HOURSTATS');
34: OpenStatistics(StatisticsList.ItemIndex,'#TOPURLS');
35: OpenStatistics(StatisticsList.ItemIndex,'#TOPSITES');
36: OpenStatistics(StatisticsList.ItemIndex,'#TOPENTRY');
37: OpenStatistics(StatisticsList.ItemIndex,'#TOPEXIT');
38: OpenStatistics(StatisticsList.ItemIndex,'#TOPREFS');
39: OpenStatistics(StatisticsList.ItemIndex,'#TOPSEARCH');
40: OpenStatistics(StatisticsList.ItemIndex,'#TOPUSERS');
41: OpenStatistics(StatisticsList.ItemIndex,'#TOPAGENTS');
43: If (CheckForChangedList) and (FileExists(TMenuItem(Sender).Caption)) then LoadList(TMenuItem(Sender).Caption);
45: begin
    SaveDialog.Filter:=GetLangText(40);
    SaveDialog.DefaultExt:='config';
    If SaveDialog.Execute then begin
       CreateConfigFile;
       ConfigMemo.Lines.SaveToFile(SaveDialog.FileName);
    end;
    SaveDialog.Filter:=GetLangText(2);
    SaveDialog.DefaultExt:='lst';
    end;
46: begin
    SaveDialog.Filter:=GetLangText(5);
    SaveDialog.DefaultExt:='txt';
    If SaveDialog.Execute then OutputMemo.Lines.SaveToFile(SaveDialog.FileName);
    SaveDialog.Filter:=GetLangText(2);
    SaveDialog.DefaultExt:='lst';
    end;
end;
end;

procedure TMainForm.AddBtnClick(Sender: TObject);   { Logfile zur Liste hinzufgen }
var Exists: Boolean;
    CtrI, CtrII: Integer;
begin
OpenDialog.Filename:='';
OpenDialog.InitialDir:=LastLogDir;
OpenDialog.Filter:=GetLangText(5);
If OpenDialog.Execute then begin
   For CtrI:=0 to OpenDialog.Files.Count-1 do begin
       Exists:=false;
       For CtrII:=0 to LogList.Items.Count-1 do begin
           If CompareText(OpenDialog.Files[CtrI],LogList.Items[CtrII])=0 then begin
              Exists:=true;
              Break;
           end;
       end;
       If Exists=false then begin
          LogList.Items.Add('0'+OpenDialog.Files[CtrI]);   { Ein '0' vor der Dateiangabe bedeutet, da das Logfile noch nicht analysiert wurde }
          LogList.Selected[LogList.Items.Count-1]:=true;
       end;
   end;
   SetChanged(true);
   LastLogDir:=ExtractFileDir(OpenDialog.Filename);
end;
end;

procedure TMainForm.DelBtnClick(Sender: TObject);    { Logfile aus der Liste lschen }
var Ctr: Integer;
begin
Ctr:=0;
While Ctr<LogList.Items.Count do begin
   If LogList.Selected[Ctr] then begin
      LogList.Items.Delete(Ctr);
      Dec(Ctr);
   end;
   Inc(Ctr);
end;
SetChanged(true);
end;

procedure TMainForm.UpBtnClick(Sender: TObject);  { Logfile nach oben verschieben }
var Ctr: Integer;
begin
For Ctr:=1 to LogList.Items.Count-1 do if LogList.Selected[Ctr] then begin
   LogList.Items.Move(Ctr,Ctr-1);
   LogList.Selected[Ctr-1]:=true;
end;
SetChanged(true);
end;

procedure TMainForm.DownBtnClick(Sender: TObject);  { Logfile nach unten verschieben }
var Ctr: Integer;
begin
For Ctr:=LogList.Items.Count-2 downto 0 do if LogList.Selected[Ctr] then begin
    LogList.Items.Move(Ctr,Ctr+1);
    LogList.Selected[Ctr+1]:=true;
end;
SetChanged(true);
end;

procedure TMainForm.LogListDrawItem(
  {$IFDEF WIN32}Control: TWinControl;Index: Integer; Rect: TRect; State: TOwnerDrawState
  {$ELSE}Sender: TObject; Index: Integer; Rect: TRect; State: TOwnerDrawState; var Handled: Boolean{$ENDIF});
var Logfile: String;
begin
LogList.Canvas.FillRect(Rect); { Rechteck lschen }
If Copy(LogList.Items[Index],1,1)='0' then ImageList.Draw(LogList.Canvas,1,Rect.Top+1,0)
   else ImageList.Draw(LogList.Canvas,1,Rect.Top+1,1);  { Status-LED anzeigen }
Logfile:=LogList.Items[Index]; Delete(Logfile,1,1);
If LogList.Canvas.TextWidth(Logfile)>(Rect.Right-18) then begin   { Falls die Dateiangabe nicht in die List-Box passt... }
   Repeat                                                         { ...wird aus der Mitte solange ein Zeichen entfernt... }
      Delete(Logfile,Trunc(Length(Logfile)/2)-2,4);
      Insert('...',Logfile,Trunc(Length(Logfile)/2));             { ...und drei Punkte eingefgt... }
   until LogList.Canvas.TextWidth(Logfile)<=(Rect.Right-18);      { ...bis es passt. }
end;
LogList.Canvas.TextOut(18,Rect.Top+2,Logfile);                    { Text anzeigen }
end;

procedure TMainForm.RunBtnClick(Sender: TObject);   { Webalizer ausfhren }
var Verz: String;
    Search: TSearchRec;
    {$IFDEF WIN32}
    CursorFile: PChar;
    {$ENDIF}
begin
If LogList.SelCount<1 then MessageDlg(GetLangText(8),mtInformation,[mbOK],0) else begin
   If Trim(TargetDir)='' then begin   { Checke ob Ziekverzeichnis angegeben wurde }
      MessageDlg(GetLangText(13),mtError,[mbOK],0);
      Exit;
   end;
   Try
      If DirectoryExists(TargetDir) then begin  { Ausgabeverzeichnis existiert bereits }
         {$IFDEF WIN32}
         If ((FileGetAttr(TargetDir) and faReadOnly)<>0) { Checke, ob man auch Schreibzugriff auf das Zielverzeichnis hat }
         or ((FileExists(TargetDir+'index.htm')) and ((FileGetAttr(TargetDir+'index.htm') and faReadOnly)<>0))
         or ((FileExists(TargetDir+'index.html')) and ((FileGetAttr(TargetDir+'index.html') and faReadOnly)<>0))
         or ((FileExists(TargetDir+'webalizer.current')) and ((FileGetAttr(TargetDir+'webalizer.current') and faReadOnly)<>0))
         or ((FileExists(TargetDir+'webalizer.hist')) and ((FileGetAttr(TargetDir+'webalizer.hist') and faReadOnly)<>0)) then begin
            MessageDlg(GetLangText(39),mtError,[mbOK],0);
            Exit;
         end;
         {$ENDIF}
         If DeleteExisting.Checked then begin   { Gegebenenfalls Ziel-Verzeichnis lschen }
            Verz:=TargetDir;
            If FindFirst(Verz+'*',$23,Search)=0 then repeat
               DeleteFile(Verz+Search.Name);
            until FindNext(Search)<>0;
            FindClose(Search);
         end;
      end else CreateDir(TargetDir); { Falls das Ausgabe-Verzeichniss nicht existiert wird es erzeugt }
   except
      MessageDlg(GetLangText(13),mtError,[mbOK],0);
      Exit;
   end;
   ProgressForm:=TProgressForm.Create(Application);
   If EnableDomainFilter then ProgressForm.ProgressBar.Max:=LogList.SelCount*2
   else ProgressForm.ProgressBar.Max:=LogList.SelCount;
   ProgressForm.Canceled:=false;
   ProgressForm.Show; Application.Processmessages;
   {$IFDEF WIN32}
   CursorFile:=StrAlloc(MAX_PATH+1);
   GetWindowsDirectory(CursorFile, MAX_PATH+25);
   StrCat(CursorFile,StrNew('\cursors\dinosaur.ani'));     { Ein bisschen Spa mu sein }
   If FileExists(CursorFile) then Screen.Cursors[1]:=LoadCursorFromFile(CursorFile)
   else Screen.Cursor:=crHourGlass;
   StrDispose(CursorFile);
   Screen.Cursor:=1;
   {$ENDIF}
   OutputMemo.Clear;
   Try
      CreateConfigFile;   { Konfigurationsdatei fr webalizer.exe erzeugen }
      {$IFDEF WIN32}
      ConfigMemo.Lines.SaveToFile(TempDir+'webalizer.conf');
      {$ELSE}
      If FileExists(GetEnvironmentVariable('HOME')+'/.webalizer.conf.bak') then DeleteFile(GetEnvironmentVariable('HOME')+'/.webalizer.conf.bak');
      If FileExists(GetEnvironmentVariable('HOME')+'/.webalizer.conf') then RenameFile(GetEnvironmentVariable('HOME')+'/.webalizer.conf',GetEnvironmentVariable('HOME')+'/.webalizer.conf.bak');
      ConfigMemo.Lines.SaveToFile(GetEnvironmentVariable('HOME')+'/.webalizer.conf');
      {$ENDIF}
      PrepareLogfile;
      SearchStatistics;
      SetChanged(true);
      If ShowStatsCheck.Checked then LastYearStatisticsBtn.Click;
   finally
      If FileExists(TempDir+'webalizer.conf') then DeleteFile(TempDir+'webalizer.conf');  { Die erzeugte Konfigurationsdatei wird wieder gelscht }
      Screen.Cursor:=crDefault;
      ProgressForm.Free;
   end;
end;
end;

procedure TMainForm.PrepareLogfile;
var Logfile, LogAfterSplit: String;
    Ctr, Succeeded: Integer;
begin
For Ctr:=0 to LogList.Items.Count-1 do
   If LogList.Selected[Ctr] and not ProgressForm.Canceled then begin
      Logfile:=LogList.Items[Ctr]; Delete(Logfile,1,1);      { Der Dateiname wird extrahiert }
      ProgressForm.Label2.Caption:=ExtractFileName(Logfile); { Der Fortschrittsdialog wird aktualisiert }
      ProgressForm.Label2.Update;
      If FileExists(Logfile) then begin                      { Es wird berprft ob das Logfile berhaupt existiert }

         If EnableDomainFilter then begin   { Das Logfile wird ggfs gesplittet }
            If ExtractFileExt(Logfile)='.gz' then begin
               If SaveFilteredLog and FileExists(SaveFilteredLogIn+ChangeFileExt(ExtractFileName(Logfile),'')) then begin
                  { Wenn bereits ein gesplittetes Logfile existiert, wird dieses fr die Analyse verwendet }
                  LogAfterSplit:=SaveFilteredLogIn+ChangeFileExt(ExtractFileName(Logfile),'');
               end else begin
                  SplitLogfile(Logfile);
                  LogAfterSplit:=TempDir+'splitted_log.tmp'; { Das gesplittete Logfile wird als splitted_log.tmp gespeichert }
               end;
            end else begin
               If SaveFilteredLog and FileExists(SaveFilteredLogIn+ExtractFileName(Logfile)) then begin
                  { Wenn bereits ein gesplittetes Logfile existiert, wird dieses fr die Analyse verwendet }
                  LogAfterSplit:=SaveFilteredLogIn+ExtractFileName(Logfile);
               end else begin
                  SplitLogfile(Logfile);
                  LogAfterSplit:=TempDir+'splitted_log.tmp'; { Das gesplittete Logfile wird als splitted_log.tmp gespeichert }
               end;
            end;
            ProgressForm.ProgressBar.Position:=ProgressForm.ProgressBar.Position+1; { Der Fortschrittsdialog wird aktualisiert }
            ProgressForm.ProgressBar.Update;
         end else LogAfterSplit:=Logfile;
         { LogAfterSplit ist somit entweder das ursprngliche Logfile, ein bei einer vorherigen Analyse gesplittetes
           Logfile oder die Datei splitted_log.tmp }

         Succeeded:=RunWebalizer(LogAfterSplit); { Webalizer wird ausgefhrt }

         If FileExists(TempDir+'splitted_log.tmp') then DeleteFile(TempDir+'splitted_log.tmp');  { splitted_log.tmp wird eventuell gelscht }  
         If Succeeded=0 then Insert('1',Logfile,0) else begin { Eine '1' vor dem Logfile, da es analysiert wurde }
            Insert('0',Logfile,0);
            MessageDlg(GetLangText(38),mtError,[mbOK],0);
         end;
         LogList.Items[Ctr]:=Logfile;
      end else MessageDlg(GetLangText(31)+Logfile+GetLangText(32),mtInformation,[mbOK],0); { Fehlermeldung falls das Logfile nicht existiert }
      ProgressForm.ProgressBar.Position:=ProgressForm.ProgressBar.Position+1;  { Der Fortschrittsdialog wird aktualisiert }
      ProgressForm.ProgressBar.Update;
      Application.Processmessages;  { Damit die Erstellung einer Statistik eventuell abgebrochen werden kann }
   end;
end;

function TMainForm.RunWebalizer(Logfile: String):Integer; { Webalizer ausfhren }
{$IFDEF WIN32}
var CAExitCode: Integer;
    ExeCom, OutText: String;
begin
ExeCom:=WebalizerExe+'Webalizer.exe';
CAExitCode:=ExecConsoleApp(ExeCom,'-c "'+TempDir+'webalizer.conf" "'+Logfile+'"',OutputMemo.Lines,RunningUpdate);
OutText:=OutputMemo.Text; { Die Ausgabe von Webalizer wird fomatiert, da sonst alles in einer Zeile steht }
While Pos(#13#10,OutText)>0 do Delete(OutText,Pos(#13#10,OutText),2);
If Pos('Using logfile',OutText)>0 then Insert(#13#10,OutText,Pos('Using logfile',OutText));
If Pos('Creating output',OutText)>0 then Insert(#13#10,OutText,Pos('Creating output',OutText));
If Pos('Hostname for reports',OutText)>0 then Insert(#13#10,OutText,Pos('Hostname for reports',OutText));
If Pos('History file',OutText)>0 then Insert(#13#10,OutText,Pos('History file',OutText));
If Pos('Reading history',OutText)>0 then Insert(#13#10,OutText,Pos('Reading history',OutText));
If Pos('Previous run',OutText)>0 then Insert(#13#10,OutText,Pos('Previous run',OutText));
If Pos('Reading previous',OutText)>0 then Insert(#13#10,OutText,Pos('Reading previous',OutText));
If Pos('Saving current',OutText)>0 then Insert(#13#10,OutText,Pos('Saving current',OutText));
If Pos('Generating report',OutText)>0 then Insert(#13#10,OutText,Pos('Generating report',OutText));
If Pos('Generating summary',OutText)>0 then Insert(#13#10,OutText,Pos('Generating summary',OutText));
If Pos('Saving history',OutText)>0 then begin
   Insert(#13#10,OutText,Pos('Saving history',OutText));
   Insert(#13#10,OutText,Pos('Saving history',OutText)+29);
end;
OutputMemo.Text:=OutText;
OutputMemo.Lines.Add(Format('%s returned %d', [ExeCom, CAExitCode]));
Result:=CAExitCode;
{$ELSE}
var Output: PIOFile; { neuer Standart Output Stream }
    line: PChar;
    txt, str: String;
    rb: Integer;

const
    BufferSize: Integer = 1000;

begin
Result:=0;
SetLength(txt,0);
str:=WebalizerExe+' -c '+GetEnvironmentVariable('HOME')+'/.webalizer.conf '+Logfile;
Output:=popen(PChar(str),'r');    { Hidden ecexution of Arg <pCMD> }
GetMem(Line,BufferSize);
{ Ausgabe von <Output> in das OutputMemo eintragen und dabei Zeilenumbrche [Chr(10)] vornehmen. }
if Assigned(Output) then begin
   while FEOF(Output)=0 do begin
      rb:=libc.fread(line,1,BufferSize,Output);
      SetLength(txt,length(txt)+rb);
      MemCpy(@txt[length(txt)-(rb-1)],line,rb);
      while pos(#10,txt)>0 do begin
         str:=copy(txt,1,pos(#10,txt)-1);
         OutputMemo.Lines.Add(str);
         txt:=copy(txt,pos(#10,txt)+1,length(txt));
      end;
   end;
end;
libc.pclose(Output);   { Output-Stream wieder schliessen }
wait(nil);
FreeMem(Line,BufferSize);
Result:=1;
{$ENDIF}
end;

{$IFDEF WIN32}
procedure TMainForm.RunningUpdate(Process: THandle; const NewLine: String);
begin
  OutputMemo.Update;  {flush paint messages to show progress}
//    TerminateProcess(Process, 101)
end;
{$ENDIF}

procedure TMainForm.SplitLogfile(Filename: String);
var Logfile, Outfile: TStringList;
    Output, LogAfterDecompress: String;
    Domain, AltDomain: Shortstring;
    Index, Entry: Integer;
{$IFDEF WIN32}
    GZip: TGZip;
{$ELSE}
    Source, Destination: TStream;
{$ENDIF}
begin
If ExtractFileExt(Filename)='.gz' then begin         { Ein komprimiertes Logfile wird zum Splitten dekomprimiert }
   LogAfterDecompress:=TempDir+'decompressed_log.tmp'; { Das dekomprimierte Logfile wird als decompressed_log.tmp gespeichert }
   {$IFDEF WIN32}
   GZip:=TGzip.Create(Application);
   GZip.FileSource:=Filename;
   GZip.FileDestination:=LogAfterDecompress;
   GZip.Gunzip; GZip.Free;
   {$ELSE}
   Source:=TFileStream.Create(Filename,fmOpenRead);
   Destination:=TFileStream.Create(LogAfterDecompress+'.gz',fmCreate);
   Destination.CopyFrom(Source,Source.Size);
   Destination.Free;
   Source.Free;
   Libc.system(PChar('gunzip '+LogAfterDecompress+'.gz'));
   {$ENDIF}
end else LogAfterDecompress:=Filename;
Logfile:=TStringList.Create;
Outfile:=TStringList.Create;
Logfile.LoadFromFile(LogAfterDecompress);
If MixDomains then begin
   If Copy(FilterDomain,1,4)='www.' then AltDomain:=Copy(FilterDomain,5,Length(FilterDomain)) else AltDomain:='www.'+FilterDomain;
   For Entry:=0 to Logfile.Count-1 do begin
      Index:=Pos('" ',Logfile[Entry]);
      Output:=Copy(Logfile[Entry],1,Index+1);
      Logfile[Entry]:=Copy(Logfile[Entry],Index+2,Length(Logfile[Entry]));
      Index:=Pos(' ',Logfile[Entry]);
      Output:=Output+Copy(Logfile[Entry],1,Index);
      Logfile[Entry]:=Copy(Logfile[Entry],Index+1,Length(Logfile[Entry]));
      Index:=Pos(' ',Logfile[Entry]);
      Output:=Output+Copy(Logfile[Entry],1,Index);
      Logfile[Entry]:=Copy(Logfile[Entry],Index+1,Length(Logfile[Entry]));
      Index:=Pos(' ',Logfile[Entry]);  { Hier kommt der Eintrag der Domain }
      Domain:=Copy(Logfile[Entry],1,Index-1);
      If (Matching(Domain,FilterDomain)) or (Matching(Domain,AltDomain)) then begin
         If not RemoveDomainInLog then Output:=Output+Copy(Logfile[Entry],1,Index);
         Logfile[Entry]:=Copy(Logfile[Entry],Index+1,Length(Logfile[Entry]));
         Output:=Output+Logfile[Entry];
         Outfile.Add(Output);
      end;
   end;
end else begin
   For Entry:=0 to Logfile.Count-1 do begin
      Index:=Pos('" ',Logfile[Entry]);
      Output:=Copy(Logfile[Entry],1,Index+1);
      Logfile[Entry]:=Copy(Logfile[Entry],Index+2,Length(Logfile[Entry]));
      Index:=Pos(' ',Logfile[Entry]);
      Output:=Output+Copy(Logfile[Entry],1,Index);
      Logfile[Entry]:=Copy(Logfile[Entry],Index+1,Length(Logfile[Entry]));
      Index:=Pos(' ',Logfile[Entry]);
      Output:=Output+Copy(Logfile[Entry],1,Index);
      Logfile[Entry]:=Copy(Logfile[Entry],Index+1,Length(Logfile[Entry]));
      Index:=Pos(' ',Logfile[Entry]);  { Hier kommt der Eintrag der Domain }
      Domain:=Copy(Logfile[Entry],1,Index-1);
      If Matching(Domain,FilterDomain) then begin
         If not RemoveDomainInLog then Output:=Output+Copy(Logfile[Entry],1,Index);
         Logfile[Entry]:=Copy(Logfile[Entry],Index+1,Length(Logfile[Entry]));
         Output:=Output+Logfile[Entry];
         Outfile.Add(Output);
      end;
   end;
end;
Outfile.SaveToFile(TempDir+'splitted_log.tmp'); { Das gesplittete Logfile wird in splitted_log.tmp gespeichert }
If SaveFilteredLog then begin
   If ExtractFileExt(Filename)='.gz' then Outfile.SaveToFile(SaveFilteredLogIn+ChangeFileExt(ExtractFilename(Filename),''))
   else Outfile.SaveToFile(SaveFilteredLogIn+ExtractFilename(Filename)); { Wenn das gesplittete Logfile gespeichert werden soll }
end;
{ Aufgrund eines Fehlers in DelphiZlib knnen die gesplittetes Logfiles bislang nur unkomprimiert gespeichert werden }
If FileExists(TempDir+'decompressed_log.tmp') then DeleteFile(TempDir+'decompressed_log.tmp'); { Das dekomprimierte Logfile decompressed_log.tmp wird wieder gelscht }
Logfile.Free;
Outfile.Free;
end;

procedure TMainForm.SetChanged(Status: Boolean);
begin
If Status=true then begin
   SaveListBtn.Enabled:=true;
   Changed:=true;
end else begin
   SaveListBtn.Enabled:=false;
   Changed:=false;
end;
end;

procedure TMainForm.GetInstalledLanguages;
var Ctr: Integer;
begin
Ctr:=0;
{$IFDEF WIN32}
If FileExists(GUIExe+'WebalizerGUI.DEU') then begin LanguageBox.Items.Add('Deutsch'); Inc(Ctr); end;
If FileExists(GUIExe+'WebalizerGUI.ENU') then begin LanguageBox.Items.Add('English'); Inc(Ctr); end;
If FileExists(GUIExe+'WebalizerGUI.ESP') then begin LanguageBox.Items.Add('Espanol'); Inc(Ctr); end;
{$ELSE}
If FileExists(GUIExe+'xwebalizer.deu') then begin LanguageBox.Items.Add('Deutsch'); Inc(Ctr); end;
If FileExists(GUIExe+'xwebalizer.enu') then begin LanguageBox.Items.Add('English'); Inc(Ctr); end;
If FileExists(GUIExe+'xwebalizer.esp') then begin LanguageBox.Items.Add('Espanol'); Inc(Ctr); end;
{$ENDIF}
If Ctr>1 then begin
   LanguageBox.Enabled:=true; Label11.Enabled:=true;
end else begin
   LanguageBox.Enabled:=false; Label11.Enabled:=false;
end;
end;

procedure TMainForm.SetLanguage(LangID: Integer; SaveBeforeChange: Boolean);
var TmpListFile, Mode: String;
    TmpBackup: Boolean;
    TmpTop, TmpLeft: Integer;
begin
TmpBackup:=BackupCheck.Checked;
TmpTop:=Top; TmpLeft:=Left;
If SaveBeforeChange then begin
   TmpListFile:=ListFile; ListFile:=TempDir+'ListFile.tmp';
   BackupCheck.Checked:=false;
   SaveList;
end;
{$IFDEF WIN32}
Case LangID of
0: { Deutsch }
    If FileExists(GUIExe+'WebalizerGUI.DEU') and (LoadNewResourceModule(GERMAN) <> 0) then ReinitializeForms;
1: { Englisch }
    If FileExists(GUIExe+'WebalizerGUI.ENU') and (LoadNewResourceModule(ENGLISH) <> 0) then ReinitializeForms;
2: { Spanisch }
    If FileExists(GUIExe+'WebalizerGUI.ESP') and (LoadNewResourceModule(SPANISH) <> 0) then ReinitializeForms;
end;
{$ELSE}
Case LangID of
0:  { Deutsch }
      If FileExists(GUIExe+'xwebalizer.deu') then begin
      end;
1:  { Englisch }
      If FileExists(GUIExe+'xwebalizer.enu') then begin
      end;
2:  { Spanisch }
      If FileExists(GUIExe+'xwebalizer.esp') then begin
      end;
end;
{$ENDIF}
LanguageID:=LangID;
If SaveBeforeChange then begin
   LoadList(ListFile);
   If FileExists(ListFile) then DeleteFile(ListFile);
   ListFile:=TmpListFile;
   Caption:='Webalizer - '+ExtractFileName(ListFile);
   BackupCheck.Checked:=TmpBackup;
end;
If AdvancedMode then Mode:=GetLangText(12) else Mode:=GetLangText(11); { Ansonsten zeigt der Mode-Button nach dem Reinitialisieren immer 'Simple Mode' an }
ModeBtn.Caption:=Mode;
Top:=TmpTop; Left:=TmpLeft;
end;

procedure TMainForm.HideGroupPageShow(Sender: TObject);
begin
Case LanguageID of
0: LanguageBox.Text:='Deutsch';
1: LanguageBox.Text:='English';
2: LanguageBox.Text:='Espanol';
end;
end;

procedure TMainForm.DeleteExistingClick(Sender: TObject);
begin
SetChanged(true);
end;

procedure TMainForm.ShowHintsCheckClick(Sender: TObject);
begin
Application.ShowHint:=ShowHintsCheck.Checked;
end;

procedure TMainForm.ChangeMode(TurnInAdvancedMode: Boolean);
var Ctr: Integer;
begin
If TurnInAdvancedMode=false then begin { In Simple Mode schalten }
   AdvancedMode:=false;
   ModeBtn.Caption:=GetLangText(11);   {'Advanced Mode'}
   For Ctr:=0 to 2 do SetTabStatus(Ctr,true);
   For Ctr:=3 to 5 do SetTabStatus(Ctr,false);
   SetTabStatus(6,true);
   TimeOutSpin.Visible:=false; Label10.Visible:=false; Label7.Visible:=false;
   GraphLinesSpin.Visible:=false; Label20.Visible:=false;
   HTMLExtensionBox.Visible:=false; Label35.Visible:=false;
   PageTypeGroupBox.Visible:=false;
   HTTPSCheck.Visible:=false;
   IgnoreSequenceErrorsCheck.Visible:=false;
   AdditionalTagsMemo.Visible:=false; Label63.Visible:=false;
end else begin       { In Advanced Mode schalten }
   AdvancedMode:=true;
   ModeBtn.Caption:=GetLangText(12);    {'Simple Mode' }
   For Ctr:=0 to 6 do SetTabStatus(Ctr,true);
   TimeOutSpin.Visible:=true; Label10.Visible:=true; Label7.Visible:=true;
   GraphLinesSpin.Visible:=true; Label20.Visible:=true;
   HTMLExtensionBox.Visible:=true; Label35.Visible:=true;
   PageTypeGroupBox.Visible:=true;
   HTTPSCheck.Visible:=true;
   IgnoreSequenceErrorsCheck.Visible:=true;
   AdditionalTagsMemo.Visible:=true; Label63.Visible:=true;
end;
end;

procedure TMainForm.HelpBtnClick(Sender: TObject);
var Command: String;
begin
Case LanguageID of
{$IFDEF WIN32}
0: Command:=GUIexe+'Help\Deu\';
1: Command:=GUIexe+'Help\Enu\';
2: Command:=GUIexe+'Help\Esp\';
{$ELSE}
0: Command:=GUIExe+'help/deu/';
1: Command:=GUIExe+'help/enu/';
2: Command:=GUIExe+'help/esp/';
{$ENDIF}
end;
Case PageControl.ActivePageIndex of
0: Command:=Command+'chose_log_files.html';
1: Command:=Command+'basic_webalizer_options.html';
2: Command:=Command+'advanced_webalizer_options.html';
3: Command:=Command+'additional_html_code.html';
4: Command:=Command+'hide_group_ignore_include.html';
5: Command:=Command+'configuration_file.html';
6: Command:=Command+'gui_options.html';
end;
If FileExists(Command) then begin
   OpenURL(Command);
end else MessageDlg(GetLangText(17),mtInformation,[mbOK],0);
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
{$IFDEF WIN32}
var Registry: TRegistry;
begin
canClose:=CheckForChangedList;
If canClose then begin
   Registry:=TRegistry.Create;
   Registry.RootKey:=HKEY_CURRENT_USER;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true) then begin   { Fensterposition in der Registry speichern }
      Registry.WriteInteger('Left',Left);
      Registry.WriteInteger('Top',Top);
      Registry.CloseKey;
   end;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\Directories',true) then begin  { Verzeichnisse in der Registry speichern }
      Registry.WriteString('ListFile',ListFile);
      Registry.WriteString('LogDir',LastLogDir);
      Registry.WriteString('TargetDir',TargetDir);
      Registry.CloseKey;
   end;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\Configuration',true) then begin  { Sonstiges in der Registry speichern }
      Registry.WriteBool('Mode',AdvancedMode);
      Registry.WriteInteger('Language',LanguageID);
      Registry.WriteBool('LoadLastList',LoadListCheck.Checked);
      Registry.WriteBool('UseStandartBrowser',UseStandartBrowserCheck.Checked);
      Registry.WriteBool('ShowHints',ShowHintsCheck.Checked);
      Registry.WriteString('LastOpenList',SaveDialog.Filename);
      Registry.WriteBool('ShowFilelistTab',PageControl.Pages[0].TabVisible);
      Registry.WriteBool('ShowOptionsTab',PageControl.Pages[1].TabVisible);
      Registry.WriteBool('ShowAdvancedOptionsTab',PageControl.Pages[2].TabVisible);
      Registry.WriteBool('ShowAdditionalHTMLTab',PageControl.Pages[3].TabVisible);
      Registry.WriteBool('ShowHGIITab',PageControl.Pages[4].TabVisible);
      Registry.WriteBool('ShowConfigOutputTab',PageControl.Pages[5].TabVisible);
      Registry.WriteBool('ShowGUIOptionsTab',PageControl.Pages[6].TabVisible);
      Registry.CloseKey;
   end;
   If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\OpenNew',true) then begin
      Registry.WriteString('Open1',NeuOeffnenBtn1.Caption);
      Registry.WriteString('Open2',NeuOeffnenBtn2.Caption);
      Registry.WriteString('Open3',NeuOeffnenBtn3.Caption);
      Registry.WriteString('Open4',NeuOeffnenBtn4.Caption);
      Registry.CloseKey;
   end;
   Registry.Free;
end;

{$ELSE}
var IniFile: TIniFile;
begin
canClose:=CheckForChangedList;
If canClose then begin
   IniFile:=TIniFile.Create(GetEnvironmentVariable('HOME')+'/.xwebalizer');
   IniFile.WriteString('Directories','ListFile',ListFile);     { Der Name der zuletzt verwendeten Log-Liste wird gespeichert }
   IniFile.WriteString('Directories','LogDir',LastLogDir);     { Das Verzeichnis des zuletzt verwendeten Log-Files wird gespeichert }
   IniFile.WriteString('Directories','TargetDir',TargetDir);   { Das zuletzt gewlte Zielverzeichnis wird gespeichert }
   IniFile.WriteInteger('Configuration','Language',LanguageID);
   IniFile.WriteBool('Configuration','Mode',AdvancedMode);
   IniFile.WriteBool('Configuration','LoadLastList',LoadListCheck.Checked);
   IniFile.WriteBool('Configuration','UseStandartBrowser',UseStandartBrowserCheck.Checked);
   IniFile.WriteBool('Configuration','ShowFilelistTab',PageControl.Pages[0].TabVisible));
   IniFile.WriteBool('Configuration','ShowOptionsTab',PageControl.Pages[1].TabVisible));
   IniFile.WriteBool('Configuration','ShowAdvancedOptionsTab',PageControl.Pages[2].TabVisible));
   IniFile.WriteBool('Configuration','ShowAdditionalHTMLTab',PageControl.Pages[3].TabVisible));
   IniFile.WriteBool('Configuration','ShowHGIITab',PageControl.Pages[4].TabVisible));
   IniFile.WriteBool('Configuration','ShowConfigOutputTab',PageControl.Pages[5].TabVisible));
   IniFile.WriteBool('Configuration','ShowGUIOptionsTab',PageControl.Pages[6].TabVisible));
   IniFile.WriteString('OpenNew','Open1',NeuOeffnenBtn1.Caption);
   IniFile.WriteString('OpenNew','Open2',NeuOeffnenBtn2.Caption);
   IniFile.WriteString('OpenNew','Open3',NeuOeffnenBtn3.Caption);
   IniFile.WriteString('OpenNew','Open4',NeuOeffnenBtn4.Caption);
   IniFile.WriteInteger('WindowPos','Left',WinLeft);
   IniFile.WriteInteger('WindowPos','Top',WinTop);
   IniFile.WriteString('ProgramProperty','WebalizerExe',WebalizerExe); { Das Verzeichnis in dem Webalizer.exe liegt wird gespeichert }
   IniFile.UpdateFile;
   IniFile.Free;
end;
{$ENDIF}
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
StatisticsFiles.Free;
end;

end.
