{ Copyright (C) by Tobias Schwarz, 2003-2005
  Distributed under the GNU General Public License }

unit Logfilesplitter;

interface

uses
  {$IFDEF WIN32}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, Dialogs, ExtCtrls, Registry;
  {$ELSE}
  SysUtils, Classes, QDialogs, QStdCtrls, QButtons,
  QControls, QForms;
  {$ENDIF}

type
  TSplitterForm = class(TForm)
    Label2: TLabel;
    DomainEdit: TEdit;
    OutputFileEdit: TEdit;
    OutputFileDialogBtn: TSpeedButton;
    ExitBtn: TBitBtn;
    RemoveDomainBox: TCheckBox;
    EnableDomainFilterCheck: TCheckBox;
    SaveFilteredLogCheck: TCheckBox;
    MixDomainsCheck: TCheckBox;
    HelpBtn: TBitBtn;
    CompressLogCheck: TCheckBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    BitBtn1: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OutputFileDialogBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EnableDomainFilterCheckClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure HelpBtnClick(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure SetDomainFilter(Status: Boolean);
  public
    { Public-Deklarationen }
  end;

implementation

uses Main, GetTextLang;

{$IFDEF WIN32}
{$R *.DFM}
{$ELSE}
{$R *.xfm}
{$ENDIF}

procedure TSplitterForm.FormCreate(Sender: TObject);
{$IFDEF WIN32}
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin  { Die Position des Programm-Fensters wird aus der Registry geladen }
   Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true);
   If Registry.ValueExists('SplitterLeft') then Left:=Registry.ReadInteger('SplitterLeft');
   If Registry.ValueExists('SplitterTop') then Top:=Registry.ReadInteger('SplitterTop');
   Registry.CloseKey;
end;
Registry.Free;
{$ELSE}
begin
HelpBtn.Enabled:=false;
{$ENDIF}
EnableDomainFilterCheck.Checked:=MainForm.EnableDomainFilter;
DomainEdit.Text:=MainForm.FilterDomain;
MixDomainsCheck.Checked:=MainForm.MixDomains;
RemoveDomainBox.Checked:=MainForm.RemoveDomainInLog;
SaveFilteredLogCheck.Checked:=MainForm.SaveFilteredLog;
OutputFileEdit.Text:=MainForm.SaveFilteredLogIn;
CompressLogCheck.Checked:=MainForm.CompressFilteredLog;
SetDomainFilter(EnableDomainFilterCheck.Checked);
end;

procedure TSplitterForm.SetDomainFilter(Status: Boolean);
begin
DomainEdit.Enabled:=Status;
SaveFilteredLogCheck.Enabled:=Status;
If (Status) and (SaveFilteredLogCheck.Checked) then begin
   OutputFileEdit.Enabled:=true;
   OutputFileDialogBtn.Enabled:=true;
   CompressLogCheck.Enabled:=true;
end else begin
   OutputFileEdit.Enabled:=false;
   OutputFileDialogBtn.Enabled:=false;
   CompressLogCheck.Enabled:=false;
end;
RemoveDomainBox.Enabled:=Status;
MixDomainsCheck.Enabled:=Status;
Label2.Enabled:=Status;
end;

procedure TSplitterForm.OutputFileDialogBtnClick(Sender: TObject);
begin
MainForm.OpenDialog.FileName:=OutputFileEdit.Text+'logfile';
MainForm.OpenDialog.DefaultExt:='*.*';
MainForm.OpenDialog.InitialDir:=OutputFileEdit.Text;
If MainForm.OpenDialog.Execute then OutputFileEdit.Text:=ExtractFileDir(MainForm.OpenDialog.FileName);
end;

procedure TSplitterForm.EnableDomainFilterCheckClick(Sender: TObject);
begin
SetDomainFilter(EnableDomainFilterCheck.Checked);
end;

procedure TSplitterForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
{$IFDEF WIN32}
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true) then begin   { Fensterposition in der Registry speichern }
   Registry.WriteInteger('SplitterLeft',Left);
   Registry.WriteInteger('SplitterTop',Top);
   Registry.CloseKey;
end;
{$ELSE}
begin
{$ENDIF}
If ModalResult=mrOK then begin
   MainForm.EnableDomainFilter:=EnableDomainFilterCheck.Checked;
   MainForm.FilterDomain:=Trim(DomainEdit.Text);
   MainForm.MixDomains:=MixDomainsCheck.Checked;
   MainForm.SaveFilteredLog:=SaveFilteredLogCheck.Checked;
   If MainForm.SaveFilteredLog then begin
      MainForm.SaveFilteredLogIn:=Trim(OutputFileEdit.Text);
      {$IFDEF WIN32}
      If (MainForm.SaveFilteredLogIn<>'') and (MainForm.SaveFilteredLogIn[Length(MainForm.SaveFilteredLogIn)]<>'\') then MainForm.SaveFilteredLogIn:=MainForm.SaveFilteredLogIn+'\';
      {$ELSE}
      If (MainForm.SaveFilteredLogIn<>'') and (MainForm.SaveFilteredLogIn[Length(MainForm.SaveFilteredLogIn)]<>'/') then MainForm.SaveFilteredLogIn:=MainForm.SaveFilteredLogIn+'/';
      {$ENDIF}
      If (EnableDomainFilterCheck.Checked) and (not DirectoryExists(MainForm.SaveFilteredLogIn)) then
         Case MessageDlg(GetLangText(33)+MainForm.SaveFilteredLogIn+GetLangText(34),mtConfirmation,[mbYes,mbNo,mbCancel],0) of
            mrYes: CreateDir(MainForm.SaveFilteredLogIn);
            mrCancel: CanClose:=false;
         end;
   end else MainForm.SaveFilteredLogIn:='';
   MainForm.CompressFilteredLog:=CompressLogCheck.Checked;
   MainForm.RemoveDomainInLog:=RemoveDomainBox.Checked;
end;
end;

procedure TSplitterForm.HelpBtnClick(Sender: TObject);
var Command: String;
begin
Case MainForm.LanguageID of
{$IFDEF WIN32}
0: Command:=MainForm.GUIexe+'Help\Deu\Splitter.html';
1: Command:=MainForm.GUIexe+'Help\Enu\Splitter.html';
2: Command:=MainForm.GUIexe+'Help\Esp\Splitter.html';
{$ELSE}
0: Command:='/opt/xwebalizer/help/deu/splitter.html';
1: Command:='/opt/xwebalizer/help/enu/splitter.html';
2: Command:='/opt/xwebalizer/help/esp/splitter.html';
{$ENDIF}
end;
If FileExists(Command) then begin
   MainForm.OpenURL(Command);
end else MessageDlg(GetLangText(17),mtInformation,[mbOK],0);
end;

procedure TSplitterForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Action:=caFree;
end;

end.
