{ Copyright (C) by Tobias Schwarz, 2003-2005
  Distributed under the GNU General Public License }

unit Config_File;

interface

uses Sysutils;

procedure CreateConfigFile;

implementation

uses Main, GetTextLang;

procedure CreateConfigFile;      { Konfigurationsdatei erstellen }
var Ctr: Integer;
begin
With MainForm do begin
ConfigMemo.Clear;
ConfigMemo.Lines.Add(GetLangText(6));
ConfigMemo.Lines.Add(GetLangText(7));
ConfigMemo.Lines.Add('#');
If Trim(TargetDir)<>'' then ConfigMemo.Lines.Add('OutputDir '+Trim(TargetDir));
If DailyStatCheck.Checked then ConfigMemo.Lines.Add('DailyStats yes') else ConfigMemo.Lines.Add('DailyStats no');
If DailyGraphCheck.Checked then ConfigMemo.Lines.Add('DailyGraph yes') else ConfigMemo.Lines.Add('DailyGraph no');
If HourlyStatCheck.Checked then ConfigMemo.Lines.Add('HourlyStats yes') else ConfigMemo.Lines.Add('HourlyStats no');
If HourlyGraphCheck.Checked then ConfigMemo.Lines.Add('HourlyGraph yes') else ConfigMemo.Lines.Add('HourlyGraph no');
If CountryCheck.Checked then ConfigMemo.Lines.Add('CountryGraph yes') else ConfigMemo.Lines.Add('CountryGraph no');
If IncrementalCheck.Checked then ConfigMemo.Lines.Add('Incremental yes') else ConfigMemo.Lines.Add('Incremental no');
ConfigMemo.Lines.Add('VisitTimeout '+IntToStr(TimeoutSpin.Value*60));
If Trim(ReportTitleEdit.Text)<>'' then ConfigMemo.Lines.Add('ReportTitle '+Trim(ReportTitleEdit.Text));
If Trim(HostNameEdit.Text)<>'' then ConfigMemo.Lines.Add('HostName '+Trim(HostNameEdit.Text));
ConfigMemo.Lines.Add('GraphLines '+IntToStr(GraphLinesSpin.Value));
If Trim(LogTypeBox.Text)<>'' then ConfigMemo.Lines.Add('LogType '+Trim(LogTypeBox.Text));
If Trim(HideReferrerEdit.Text)<>'' then ConfigMemo.Lines.Add('HideReferrer '+Trim(HideReferrerEdit.Text));
If Trim(HTMLExtensionBox.Text)<>'' then ConfigMemo.Lines.Add('HTMLExtension '+Trim(HTMLExtensionBox.Text));
If EnableRevDNSLookupsCheck.Checked then begin
   If Trim(DNSCacheEdit.Text)<>'' then ConfigMemo.Lines.Add('DNSCache '+Trim(DNSCacheEdit.Text));
   ConfigMemo.Lines.Add('DNSChildren '+IntToStr(DNSChildSpin.Value));
end;
ConfigMemo.Lines.Add('MangleAgents '+IntToStr(MangleAgentsSpin.Value));
If htmCheck.Checked=true then ConfigMemo.Lines.Add('PageType htm*');
If cgiCheck.Checked=true then ConfigMemo.Lines.Add('PageType cgi');
If aspCheck.Checked=true then ConfigMemo.Lines.Add('PageType asp*');
If phtmlCheck.Checked=true then ConfigMemo.Lines.Add('PageType phtml');
If php3Check.Checked=true then ConfigMemo.Lines.Add('PageType php3');
If plCheck.Checked=true then ConfigMemo.Lines.Add('PageType pl');
If HTTPSCheck.Checked=true then ConfigMemo.Lines.Add('UseHTTPS yes');
If IgnoreSequenceErrorsCheck.Checked=true then ConfigMemo.Lines.Add('FoldSeqErr yes');
ConfigMemo.Lines.Add('TopSites '+IntToStr(TopSitesSpin.Value));
ConfigMemo.Lines.Add('TopKSites '+IntToStr(TopKBytesSpin.Value));
ConfigMemo.Lines.Add('TopURLs '+IntToStr(TopURLsSpin.Value));
ConfigMemo.Lines.Add('TopKURLs '+IntToStr(TopURLsKBytesSpin.Value));
ConfigMemo.Lines.Add('TopReferrers '+IntToStr(TopReferrersSpin.Value));
ConfigMemo.Lines.Add('TopAgents '+IntToStr(TopAgentsSpin.Value));
ConfigMemo.Lines.Add('TopCountries '+IntToStr(TopCountriesSpin.Value));
ConfigMemo.Lines.Add('TopEntry '+IntToStr(TopEntryPagesSpin.Value));
ConfigMemo.Lines.Add('TopExit '+IntToStr(TopExitPagesSpin.Value));
ConfigMemo.Lines.Add('TopSearch '+IntToStr(TopSearchesSpin.Value));
ConfigMemo.Lines.Add('TopUsers '+IntToStr(TopUsersSpin.Value));
If AllSitesCheck.Checked then ConfigMemo.Lines.Add('AllSites yes') else ConfigMemo.Lines.Add('AllSites no');
If AllURLsCheck.Checked then ConfigMemo.Lines.Add('AllURLs yes') else ConfigMemo.Lines.Add('AllURLs no');
If AllReferrersCheck.Checked then ConfigMemo.Lines.Add('AllReferrers yes') else ConfigMemo.Lines.Add('AllReferrers no');
If AllAgentsCheck.Checked then ConfigMemo.Lines.Add('AllAgents yes') else ConfigMemo.Lines.Add('AllAgents no');
If AllSearchesCheck.Checked then ConfigMemo.Lines.Add('AllSearchStr yes') else ConfigMemo.Lines.Add('AllSearchStr no');
If AllUsersCheck.Checked then ConfigMemo.Lines.Add('AllUsers yes') else ConfigMemo.Lines.Add('AllUsers no');
For Ctr:=0 to SearchEnginesMemo.Lines.Count-1 do if Trim(SearchEnginesMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('SearchEngine '+Trim(SearchEnginesMemo.Lines[Ctr]));
For Ctr:=0 to HTMLPreMemo.Lines.Count-1 do if Trim(HTMLPreMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HTMLPre '+Trim(HTMLPreMemo.Lines[Ctr]));
For Ctr:=0 to HTMLHeadMemo.Lines.Count-1 do if Trim(HTMLHeadMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HTMLHead '+Trim(HTMLHeadMemo.Lines[Ctr]));
For Ctr:=0 to HTMLBodyMemo.Lines.Count-1 do if Trim(HTMLBodyMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HTMLBody '+Trim(HTMLBodyMemo.Lines[Ctr]));
For Ctr:=0 to HTMLPostMemo.Lines.Count-1 do if Trim(HTMLPostMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HTMLPost '+Trim(HTMLPostMemo.Lines[Ctr]));
For Ctr:=0 to HTMLTailMemo.Lines.Count-1 do if Trim(HTMLTailMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HTMLTail '+Trim(HTMLTailMemo.Lines[Ctr]));
For Ctr:=0 to HTMLEndMemo.Lines.Count-1 do if Trim(HTMLEndMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HTMLEnd '+Trim(HTMLEndMemo.Lines[Ctr]));
For Ctr:=0 to Memo1.Lines.Count-1 do if Trim(Memo1.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HideSite '+Trim(Memo1.Lines[Ctr]));
For Ctr:=0 to Memo2.Lines.Count-1 do if Trim(Memo2.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HideURL '+Trim(Memo2.Lines[Ctr]));
For Ctr:=0 to Memo3.Lines.Count-1 do if Trim(Memo3.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HideReferrer '+Trim(Memo3.Lines[Ctr]));
For Ctr:=0 to Memo4.Lines.Count-1 do if Trim(Memo4.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HideAgent '+Trim(Memo4.Lines[Ctr]));
For Ctr:=0 to Memo5.Lines.Count-1 do if Trim(Memo5.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('HideUser '+Trim(Memo5.Lines[Ctr]));
For Ctr:=0 to Memo6.Lines.Count-1 do if Trim(Memo6.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('GroupSite '+Trim(Memo6.Lines[Ctr]));
For Ctr:=0 to Memo7.Lines.Count-1 do if Trim(Memo7.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('GroupURL '+Trim(Memo7.Lines[Ctr]));
For Ctr:=0 to Memo8.Lines.Count-1 do if Trim(Memo8.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('GroupReferrer '+Trim(Memo8.Lines[Ctr]));
For Ctr:=0 to Memo9.Lines.Count-1 do if Trim(Memo9.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('GroupAgent '+Trim(Memo9.Lines[Ctr]));
For Ctr:=0 to Memo10.Lines.Count-1 do if Trim(Memo10.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('GroupUser '+Trim(Memo10.Lines[Ctr]));
For Ctr:=0 to Memo11.Lines.Count-1 do if Trim(Memo11.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IgnoreSite '+Trim(Memo11.Lines[Ctr]));
For Ctr:=0 to Memo12.Lines.Count-1 do if Trim(Memo12.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IgnoreURL '+Trim(Memo12.Lines[Ctr]));
For Ctr:=0 to Memo13.Lines.Count-1 do if Trim(Memo13.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IgnoreReferrer '+Trim(Memo13.Lines[Ctr]));
For Ctr:=0 to Memo14.Lines.Count-1 do if Trim(Memo14.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IgnoreAgent '+Trim(Memo14.Lines[Ctr]));
For Ctr:=0 to Memo15.Lines.Count-1 do if Trim(Memo15.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IgnoreUser '+Trim(Memo15.Lines[Ctr]));
For Ctr:=0 to Memo16.Lines.Count-1 do if Trim(Memo16.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IncludeURL '+Trim(Memo16.Lines[Ctr]));
For Ctr:=0 to Memo17.Lines.Count-1 do if Trim(Memo17.Lines[Ctr])<>'' then ConfigMemo.Lines.Add('IncludeUser '+Trim(Memo17.Lines[Ctr]));
ConfigMemo.Lines.Add('#');
ConfigMemo.Lines.Add('# User defined configuration lines:');
For Ctr:=0 to AdditionalTagsMemo.Lines.Count-1 do if Trim(AdditionalTagsMemo.Lines[Ctr])<>'' then ConfigMemo.Lines.Add(Trim(AdditionalTagsMemo.Lines[Ctr]));
end;
end;

end.
 