{ Copyright (C) by Tobias Schwarz, 2003-2005
  Distributed under the GNU General Public License }

unit Browser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, SHDocVw, Registry, StdCtrls, Buttons, ExtCtrls;

type
  TBrowserForm = class(TForm)
    WebBrowser: TWebBrowser;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    StatisticsComboBox: TComboBox;
    SpeedButton13: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure SpeedButton13Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var BrowserForm: TBrowserForm;

implementation

uses Main;

{$R *.DFM}

procedure TBrowserForm.FormCreate(Sender: TObject);
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos') then begin  { Die Position des Programm-Fensters wird aus der Registry geladen }
   Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true);
   If Registry.ValueExists('BrowserLeft') then Left:=Registry.ReadInteger('BrowserLeft');
   If Registry.ValueExists('BrowserTop') then Top:=Registry.ReadInteger('BrowserTop');
   If Registry.ValueExists('BrowserWidth') then Width:=Registry.ReadInteger('BrowserWidth');
   If Registry.ValueExists('BrowserHeight') then Height:=Registry.ReadInteger('BrowserHeight');
   Registry.CloseKey;
end;
Registry.Free;
end;
    
procedure TBrowserForm.FormShow(Sender: TObject);
begin
StatisticsComboBox.Items:=MainForm.StatisticsList.Items;
end;

procedure TBrowserForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
Registry.OpenKey('Software\Sir_Tobe&Co\WebalizerGUI\WindowPos',true);   { Fensterposition in der Registry speichern }
Registry.WriteInteger('BrowserLeft',Left);
Registry.WriteInteger('BrowserTop',Top);
Registry.WriteInteger('BrowserWidth',Width);
Registry.WriteInteger('BrowserHeight',Height);
Registry.CloseKey;
end;

procedure TBrowserForm.SpeedButton13Click(Sender: TObject);
begin
With MainForm do begin
   Case TComponent(Sender).Tag of
      1: OpenStatistics(StatisticsComboBox.ItemIndex,'index');
      2: OpenStatistics(StatisticsComboBox.ItemIndex,'');
      3: OpenStatistics(StatisticsComboBox.ItemIndex,'#DAYSTATS');
      4: OpenStatistics(StatisticsComboBox.ItemIndex,'#HOURSTATS');
      5: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPURLS');
      6: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPSITES');
      7: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPENTRY');
      8: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPEXIT');
      9: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPREFS');
      10: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPSEARCH');
      11: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPUSERS');
      12: OpenStatistics(StatisticsComboBox.ItemIndex,'#TOPAGENTS');
   end;
end;
end;

end.
